/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.DefaultRemoteCommand;
import org.openqa.selenium.server.SeleniumCommandTimedOutException;

public class SingleEntryAsyncQueue {
    static Log log = LogFactory.getLog(SingleEntryAsyncQueue.class);
    private static int idGenerator = 1;
    private Object thing = null;
    private boolean done = false;
    private static int defaultTimeout = 1800;
    private int timeout;
    private int id = idGenerator++;
    private boolean hasBlockedGetter = false;
    private String loggingPreamble;
    private String label;
    private int countOfCallsToGet = 0;
    private int clearCallsToGetPrecedingThisThreshold = 0;
    private final Lock dataLock;
    private final Condition condition;
    private boolean retry;

    public SingleEntryAsyncQueue(String label, Lock dataLock, Condition condition) {
        this.label = label;
        this.dataLock = dataLock;
        this.condition = condition;
        this.timeout = defaultTimeout;
        this.loggingPreamble = this.label + "-" + this.id + ": ";
    }

    public void clear() {
        this.clearCallsToGetPrecedingThisThreshold = this.countOfCallsToGet;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() {
        log.debug(this + " get()");
        int thisCall = this.countOfCallsToGet++;
        if (this.done) {
            return null;
        }
        int retries = 0;
        this.hasBlockedGetter = true;
        Object t = null;
        try {
            while (t == null) {
                block15: {
                    if (t == null & retries >= this.timeout) {
                        throw new SeleniumCommandTimedOutException();
                    }
                    if (this.retry && retries > 0 && retries % 10 == 0) {
                        DefaultRemoteCommand defaultRemoteCommand = new DefaultRemoteCommand("retryLast", "", "", "");
                        return defaultRemoteCommand;
                    }
                    try {
                        this.dataLock.lock();
                        t = this.thing;
                        this.thing = null;
                        if (t != null) break block15;
                        this.condition.await(1000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {}
                    continue;
                    finally {
                        this.dataLock.unlock();
                        continue;
                    }
                }
                if (this.done || thisCall < this.clearCallsToGetPrecedingThisThreshold) {
                    Object var4_6 = null;
                    return var4_6;
                }
                ++retries;
            }
        }
        finally {
            this.hasBlockedGetter = false;
        }
        log.debug(this + " get() returned " + t);
        return t;
    }

    public Object peek() {
        if (this.done) {
            throw new RuntimeException("peek(" + this + ") on a retired queue");
        }
        if (this.isEmpty()) {
            throw new RuntimeException("peek() called on an empty queue");
        }
        return this.thing;
    }

    public boolean isEmpty() {
        return this.thing == null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.loggingPreamble);
        sb.append(this.thing == null ? "null" : this.thing.toString());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object newObj) {
        log.debug(this + " put() " + newObj);
        if (this.done) {
            throw new RuntimeException("put(" + newObj + ") on a retired queue");
        }
        if (newObj == null) {
            this.thing = null;
        } else {
            this.dataLock.lock();
            try {
                this.thing = newObj;
                this.condition.signalAll();
            }
            finally {
                this.dataLock.unlock();
            }
        }
    }

    public static void setDefaultTimeout(int defaultTimeout) {
        SingleEntryAsyncQueue.defaultTimeout = defaultTimeout;
    }

    public boolean hasBlockedGetter() {
        return this.hasBlockedGetter;
    }

    public void setRetry(boolean retry) {
        this.retry = retry;
    }
}

