/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.manager.interfaces.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.jboss.console.manager.interfaces.ManageableResource;
import org.jboss.console.manager.interfaces.TreeAction;
import org.jboss.console.manager.interfaces.TreeInfo;
import org.jboss.console.manager.interfaces.TreeNode;
import org.jboss.console.manager.interfaces.TreeNodeMenuEntry;

public class DefaultTreeInfo
implements TreeInfo {
    protected ManageableResource[] roots = null;
    protected HashMap resources = new HashMap();
    protected TreeAction homeAction = null;
    protected String jbossVersion = null;
    protected long version = 0L;
    protected TreeNodeMenuEntry[] rootMenus = new TreeNodeMenuEntry[0];
    protected String iconUrl = null;

    public DefaultTreeInfo() {
        Package jbossPackage = Package.getPackage("org.jboss");
        this.jbossVersion = jbossPackage.getImplementationTitle() + " " + jbossPackage.getImplementationVersion();
    }

    public ManageableResource[] getRootResources() {
        return this.roots;
    }

    public void setRootResources(ManageableResource[] roots) {
        this.roots = roots;
    }

    public synchronized TreeNode[] getTreesForResource(ManageableResource resource) {
        ArrayList content = (ArrayList)this.resources.get(resource);
        if (content == null || content.size() == 0) {
            return null;
        }
        TreeNode[] result = new TreeNode[content.size()];
        return content.toArray(result);
    }

    public synchronized void addTreeToResource(ManageableResource resource, TreeNode tree) {
        ArrayList<TreeNode> content = (ArrayList<TreeNode>)this.resources.get(resource);
        if (content == null || content.size() == 0) {
            content = new ArrayList<TreeNode>();
            this.resources.put(resource, content);
        }
        if (!content.contains(tree)) {
            content.add(tree);
        }
    }

    public TreeAction getHomeAction() {
        return this.homeAction;
    }

    public void setHomeAction(TreeAction homeAction) {
        this.homeAction = homeAction;
    }

    public String getDescription() {
        return this.jbossVersion;
    }

    public void setRootMenus(TreeNodeMenuEntry[] menus) {
        this.rootMenus = menus;
    }

    public TreeNodeMenuEntry[] getRootMenus() {
        return this.rootMenus;
    }

    public String toString() {
        String result = "Root: " + this.roots + "\n";
        Iterator iter = this.resources.keySet().iterator();
        while (iter.hasNext()) {
            ManageableResource key = (ManageableResource)iter.next();
            ArrayList content = (ArrayList)this.resources.get(key);
            result = result + "  Key: " + key + "\n";
            for (int i = 0; i < content.size(); ++i) {
                result = result + "    Value: " + content.get(i);
            }
            result = result + "  ----\n";
        }
        return result;
    }

    public long getTreeVersion() {
        return this.version;
    }

    public void setTreeVersion(long version) {
        this.version = version;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String url) {
        this.iconUrl = url;
    }
}

