/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.form;

import com.ampiere.web.struts.form.PaymentPrintForm;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.util.CLogger;
import org.compiere.util.Msg;
import org.compiere.util.WebSessionCtx;

public class PaymentPrintAction
extends Action {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String PAYMENT_LIST = "paymentlist";
    private static final String ACTION_FORM = "PaymentPrintForm";
    private static final String ERROR_FORWARD = "error";

    public final ActionForward execute(ActionMapping mapping, ActionForm form2, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.log.fine("Begin " + ((Object)((Object)this)).getClass().getName() + ";execute");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        ActionForward actionForward = mapping.findForward(PAYMENT_LIST);
        PaymentPrintForm myForm = (PaymentPrintForm)request.getAttribute(ACTION_FORM);
        String column = myForm.getChangedColumn();
        if (column.equals("paymentSelectionId")) {
            actionForward = mapping.findForward(PAYMENT_LIST);
        } else if (column.equals("paymentRule")) {
            actionForward = mapping.findForward(PAYMENT_LIST);
        } else if (column.equals("export")) {
            this.export(wsc, myForm);
            actionForward = mapping.findForward(PAYMENT_LIST);
        } else {
            actionForward = column.equals("print") ? mapping.findForward(PAYMENT_LIST) : (column.equals("process") ? mapping.findForward(PAYMENT_LIST) : mapping.findForward(PAYMENT_LIST));
        }
        myForm.setChangedColumn(null);
        request.setAttribute(ACTION_FORM, (Object)myForm);
        this.log.fine("End " + ((Object)((Object)this)).getClass().getName() + ";execute");
        return actionForward;
    }

    private void export(WebSessionCtx wsc, PaymentPrintForm form2) {
        if (!this.getChecks(wsc, form2)) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("openHistoryWindow(").append("\"").append("/compiere/ampiere/WPaymentExport").append("?paymentSelectionId=" + form2.getPaymentSelectionId()).append("&paymentRule=" + form2.getPaymentRule()).append("&documentNumber=" + form2.getDocumentNumber()).append("\",").append("\"WPaymentExport\" );");
        form2.setResultInfo(sb.toString());
    }

    private boolean getChecks(WebSessionCtx wsc, PaymentPrintForm form2) {
        if (form2.getPaymentSelectionId() <= 0 || form2.getBankAccountId() <= 0 || form2.getPaymentRule().equals("") || form2.getDocumentNumber() == 0) {
            form2.setResultInfo("alert('" + Msg.translate(wsc.ctx, "VPayPrintNoRecords") + ":" + Msg.translate(wsc.ctx, "C_PaySelectionLine_ID") + " #0');");
            return false;
        }
        this.log.config("C_PaySelection_ID=" + form2.getPaymentSelectionId() + ", PaymentRule=" + form2.getPaymentRule() + ", DocumentNo=" + form2.getDocumentNumber());
        MPaySelectionCheck[] checks = MPaySelectionCheck.get(form2.getPaymentSelectionId(), form2.getPaymentRule(), form2.getDocumentNumber(), null);
        if (checks == null || checks.length == 0) {
            form2.setResultInfo("alert('" + Msg.translate(wsc.ctx, "VPayPrintNoRecords") + ":" + Msg.translate(wsc.ctx, "C_PaySelectionLine_ID") + " #0');");
            return false;
        }
        return true;
    }
}

