/*
 * Decompiled with CFR 0.152.
 */
package com.jware.apps.scheduler.jobs;

import com.jware.apps.scheduler.jobs.DumbInterruptableJob;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.SchedulerMetaData;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.helpers.TriggerUtils;
import org.quartz.impl.StdSchedulerFactory;

public class InterruptableJobTest {
    public static void schedTest(SchedulerFactory sf) throws Exception {
        int j;
        String[] names;
        int i2;
        Log lg = LogFactory.getLog(InterruptableJobTest.class);
        lg.info((Object)"------- Initializing -------------------");
        Scheduler sched = sf.getScheduler();
        lg.info((Object)"------- Initializing 2 -------------------");
        String[] groups = sched.getTriggerGroupNames();
        for (i2 = 0; i2 < groups.length; ++i2) {
            names = sched.getTriggerNames(groups[i2]);
            for (j = 0; j < names.length; ++j) {
                sched.unscheduleJob(names[j], groups[i2]);
            }
        }
        groups = sched.getJobGroupNames();
        for (i2 = 0; i2 < groups.length; ++i2) {
            names = sched.getJobNames(groups[i2]);
            for (j = 0; j < names.length; ++j) {
                sched.deleteJob(names[j], groups[i2]);
            }
        }
        lg.info((Object)"------- Initialization Complete -----------");
        lg.info((Object)"------- Scheduling Jobs -----------");
        long ts = TriggerUtils.getNextGivenSecondDate(null, (int)5).getTime();
        JobDetail job = new JobDetail("interruptableJob1", "group1", DumbInterruptableJob.class);
        job.getJobDataMap().put("ExecutionDelay", 10000L);
        SimpleTrigger trigger = new SimpleTrigger("trigg1", "group1", new Date(ts), null, SimpleTrigger.REPEAT_INDEFINITELY, 5000L);
        Date ft = sched.scheduleJob(job, (Trigger)trigger);
        lg.info((Object)(job.getFullName() + " will run at: " + ft + " & repeat: " + trigger.getRepeatCount() + "/" + trigger.getRepeatInterval()));
        lg.info((Object)"------- Starting Scheduler ----------------");
        sched.start();
        lg.info((Object)"------- Started Scheduler -----------------");
        lg.info((Object)"------- Starting loop to interrupt job every 7 seconds ----------");
        for (int i3 = 0; i3 < 50; ++i3) {
            try {
                Thread.sleep(7000L);
                sched.interrupt(job.getName(), job.getGroup());
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        lg.info((Object)"------- Shutting Down ---------------------");
        sched.shutdown(true);
        lg.info((Object)"------- Shutdown Complete -----------------");
        SchedulerMetaData metaData = sched.getMetaData();
        lg.info((Object)("Executed " + metaData.numJobsExecuted() + " jobs."));
    }

    public static void main(String[] args) throws Exception {
        try {
            InterruptableJobTest.schedTest((SchedulerFactory)new StdSchedulerFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

