/*
 * Decompiled with CFR 0.152.
 */
package com.jware.apps.scheduler.jobs;

import com.jware.apps.scheduler.jobs.DumbJob;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.SchedulerMetaData;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.helpers.TriggerUtils;
import org.quartz.impl.StdSchedulerFactory;

public class SchedTest {
    public static void schedTest(SchedulerFactory sf) throws Exception {
        int j;
        String[] names;
        int i2;
        Log lg = LogFactory.getLog(SchedTest.class);
        lg.info((Object)"------- Initializing -------------------");
        Scheduler sched = sf.getScheduler();
        lg.info((Object)"------- Initializing 2 -------------------");
        String[] groups = sched.getTriggerGroupNames();
        for (i2 = 0; i2 < groups.length; ++i2) {
            names = sched.getTriggerNames(groups[i2]);
            for (j = 0; j < names.length; ++j) {
                sched.unscheduleJob(names[j], groups[i2]);
            }
        }
        groups = sched.getJobGroupNames();
        for (i2 = 0; i2 < groups.length; ++i2) {
            names = sched.getJobNames(groups[i2]);
            for (j = 0; j < names.length; ++j) {
                sched.deleteJob(names[j], groups[i2]);
            }
        }
        lg.info((Object)"------- Initialization Complete -----------");
        lg.info((Object)"------- Scheduling Jobs -----------");
        long ts = TriggerUtils.getNextGivenSecondDate(null, (int)15).getTime();
        JobDetail job = new JobDetail("job1", "group1", DumbJob.class);
        SimpleTrigger trigger = new SimpleTrigger("trigg1", "group1", new Date(ts));
        Date ft = sched.scheduleJob(job, (Trigger)trigger);
        lg.info((Object)(job.getFullName() + " will run at: " + ft + " & repeat: " + trigger.getRepeatCount() + "/" + trigger.getRepeatInterval()));
        job = new JobDetail("job2", "group1", DumbJob.class);
        trigger = new SimpleTrigger("trigg2", "group1", "job2", "group1", new Date(ts), null, 0, 0L);
        ft = sched.scheduleJob(job, (Trigger)trigger);
        lg.info((Object)(job.getFullName() + " will run at: " + ft + " & repeat: " + trigger.getRepeatCount() + "/" + trigger.getRepeatInterval()));
        job = new JobDetail("job3", "group1", DumbJob.class);
        trigger = new SimpleTrigger("trigg3", "group1", "job3", "group1", new Date(ts), null, 10, 10000L);
        ft = sched.scheduleJob(job, (Trigger)trigger);
        lg.info((Object)(job.getFullName() + " will run at: " + ft + " & repeat: " + trigger.getRepeatCount() + "/" + trigger.getRepeatInterval()));
        trigger = new SimpleTrigger("trigg3", "group2", "job3", "group1", new Date(ts), null, 2, 7000L);
        ft = sched.scheduleJob((Trigger)trigger);
        lg.info((Object)(job.getFullName() + " will [also] run at: " + ft + " & repeat: " + trigger.getRepeatCount() + "/" + trigger.getRepeatInterval()));
        job = new JobDetail("job4", "group1", DumbJob.class);
        trigger = new SimpleTrigger("trigg4", "group1", "job4", "group1", new Date(ts), null, 5, 20000L);
        ft = sched.scheduleJob(job, (Trigger)trigger);
        lg.info((Object)(job.getFullName() + " will run at: " + ft + " & repeat: " + trigger.getRepeatCount() + "/" + trigger.getRepeatInterval()));
        job = new JobDetail("job5", "group1", DumbJob.class);
        trigger = new SimpleTrigger("trigg5", "group1", "job5", "group1", new Date(ts + 30000L), null, 0, 0L);
        ft = sched.scheduleJob(job, (Trigger)trigger);
        lg.info((Object)(job.getFullName() + " will run at: " + ft + " & repeat: " + trigger.getRepeatCount() + "/" + trigger.getRepeatInterval()));
        job = new JobDetail("job6", "group1", DumbJob.class);
        trigger = new SimpleTrigger("trigg6", "group1", "job6", "group1", new Date(ts), null, SimpleTrigger.REPEAT_INDEFINITELY, 5000L);
        ft = sched.scheduleJob(job, (Trigger)trigger);
        lg.info((Object)(job.getFullName() + " will run at: " + ft + " & repeat: " + trigger.getRepeatCount() + "/" + trigger.getRepeatInterval()));
        job = new JobDetail("job10", "group10", DumbJob.class);
        CronTrigger cTrigger = new CronTrigger("trigg10", "group10", "job10", "group10", "0/15 * * * * ?");
        ft = sched.scheduleJob(job, (Trigger)cTrigger);
        lg.info((Object)(job.getFullName() + " will run at: " + ft + " & repeat based on expression: " + cTrigger.getCronExpression()));
        lg.info((Object)"------- Starting Scheduler ----------------");
        sched.start();
        lg.info((Object)"------- Started Scheduler -----------------");
        job = new JobDetail("job11", "group10", DumbJob.class);
        cTrigger = new CronTrigger("trigg11", "group10", "job11", "group10", "0/2 * * * * ?");
        ft = sched.scheduleJob(job, (Trigger)cTrigger);
        lg.info((Object)(job.getFullName() + " will run at: " + ft + " & repeat based on expression: " + cTrigger.getCronExpression()));
        job = new JobDetail("job20", "group20", DumbJob.class);
        job.setDurability(true);
        sched.addJob(job, true);
        lg.info((Object)"'Manually' triggering job20...");
        sched.triggerJob("job20", "group20");
        lg.info((Object)"------- Waiting... -----------------------");
        try {
            Thread.sleep(30000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        cTrigger = new CronTrigger("trigg11", "group10", "job11", "group10", "0/1 * * * * ?");
        ft = sched.rescheduleJob("trigg11", "group10", (Trigger)cTrigger);
        lg.info((Object)(job.getFullName() + " has been re-scheduled to run at: " + ft + " & repeat based on expression: " + cTrigger.getCronExpression()));
        try {
            Thread.sleep(300000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lg.info((Object)"------- Shutting Down ---------------------");
        sched.shutdown(true);
        lg.info((Object)"------- Shutdown Complete -----------------");
        SchedulerMetaData metaData = sched.getMetaData();
        lg.info((Object)("Executed " + metaData.numJobsExecuted() + " jobs."));
    }

    public static void main(String[] args) throws Exception {
        try {
            SchedTest.schedTest((SchedulerFactory)new StdSchedulerFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

