/*
 * Decompiled with CFR 0.152.
 */
package com.jware.apps.scheduler.web.struts.schedule;

import com.jware.apps.scheduler.util.JobSchedulerUtils;
import com.jware.apps.scheduler.web.struts.schedule.JobScheduleViewForm;
import com.jware.apps.scheduler.web.struts.schedule.JobTriggerForm;
import com.jware.base.web.struts.jWareBaseAction;
import java.util.LinkedList;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.quartz.Scheduler;
import org.quartz.Trigger;

public final class JobTriggerList
extends jWareBaseAction {
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public ActionForward doExecute(ActionMapping mapping, ActionForm form2, HttpServletRequest request, HttpServletResponse response, ActionErrors errors, boolean mochaFlag) throws Exception {
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        JobScheduleViewForm info = (JobScheduleViewForm)form2;
        MessageResources messages = this.getResources(request);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JobTriggerList:  Processing actions");
        }
        if (info == null) {
            info = new JobScheduleViewForm();
        }
        Scheduler scheduler = JobSchedulerUtils.getCurrentScheduler(session);
        String[] triggerGroups = scheduler.getTriggerGroupNames();
        LinkedList<JobTriggerForm> triggerList = new LinkedList<JobTriggerForm>();
        for (int i2 = 0; i2 < triggerGroups.length; ++i2) {
            String groupName = triggerGroups[i2];
            String[] triggerNames = scheduler.getTriggerNames(groupName);
            for (int j = 0; j < triggerNames.length; ++j) {
                String triggerName = triggerNames[j];
                Trigger trigger = scheduler.getTrigger(triggerName, groupName);
                JobTriggerForm tForm = new JobTriggerForm();
                tForm.setDescription(trigger.getDescription());
                tForm.setJobGroup(trigger.getJobGroup());
                tForm.setJobName(trigger.getJobName());
                tForm.setMisFireInstruction(trigger.getMisfireInstruction());
                tForm.setStartTime(JobSchedulerUtils.getDateAsString(trigger.getStartTime()));
                tForm.setStopTime(JobSchedulerUtils.getDateAsString(trigger.getEndTime()));
                tForm.setTriggerGroup(trigger.getGroup());
                tForm.setTriggerName(trigger.getName());
                tForm.setNextFireTime(JobSchedulerUtils.getDateAsString(trigger.getNextFireTime()));
                tForm.setPreviousFireTime(JobSchedulerUtils.getDateAsString(trigger.getPreviousFireTime()));
                tForm.setType(JobSchedulerUtils.getTriggerType(trigger));
                tForm.getParamMap().put("triggerName", trigger.getName());
                tForm.getParamMap().put("groupName", trigger.getGroup());
                tForm.getJobParamMap().put("jobName", trigger.getJobName());
                tForm.getJobParamMap().put("groupName", trigger.getJobGroup());
                triggerList.add(tForm);
            }
        }
        request.setAttribute("jobTriggerList", triggerList);
        return mapping.findForward("success");
    }
}

