/*
 * Decompiled with CFR 0.152.
 */
package com.jware.util.crypt;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class UniqIDUtils {
    public static void main(String[] arguments) {
        System.out.println("UniqID = " + UniqIDUtils.generateUniqID());
    }

    public static String generateUniqID() {
        String uniqID = null;
        try {
            SecureRandom prng = SecureRandom.getInstance("SHA1PRNG");
            String randomNum = new Integer(prng.nextInt()).toString();
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            byte[] result = sha.digest(randomNum.getBytes());
            uniqID = UniqIDUtils.hexEncode(result);
        }
        catch (NoSuchAlgorithmException ex) {
            System.err.println(ex);
        }
        return uniqID;
    }

    private static String hexEncode(byte[] aInput) {
        StringBuffer result = new StringBuffer();
        char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        for (int idx = 0; idx < aInput.length; ++idx) {
            byte b2 = aInput[idx];
            result.append(digits[(b2 & 0xF0) >> 4]);
            result.append(digits[b2 & 0xF]);
        }
        return result.toString();
    }
}

