/*
 * Decompiled with CFR 0.152.
 */
package com.jware.util.xml;

import com.jware.base.error.JwareApplicationException;
import com.jware.util.xml.GetMethodUtil;
import com.jware.util.xml.PostMethodUtil;
import com.jware.util.xml.XHtmlUtils;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpClientUtil {
    protected static Log log = LogFactory.getLog(XHtmlUtils.class);
    private HttpClient httpClient;
    private GetMethodUtil getMethod = null;
    private PostMethodUtil postMethod = null;
    private String requestUserAgent = null;
    private String requestAccept = null;
    private String requestAcceptCharset = null;
    private String requestAcceptEncoding = null;
    private String requestAcceptLanguage = null;
    private String requestAcceptAuthorization = null;
    private String charset = null;
    private String getMethodContentType = null;
    private String postMethodContentType = null;
    private String sessionId = null;

    public HttpClientUtil() {
        HttpState initialState = new HttpState();
        initialState.setCookiePolicy(2);
        this.httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(30000);
        this.httpClient.setState(initialState);
    }

    public void copyRequestHeader(HttpServletRequest request) {
        this.requestUserAgent = request.getHeader("User-Agent");
        this.requestAccept = request.getHeader("Accept");
        this.requestAcceptCharset = request.getHeader("Accept-Charset");
        this.requestAcceptEncoding = request.getHeader("Accept-Encoding");
        this.requestAcceptLanguage = request.getHeader("Accept-Language");
        this.requestAcceptAuthorization = request.getHeader("Accept-Authorization");
    }

    public String submitGet(String url) throws JwareApplicationException {
        return this.submitGet(url, null);
    }

    public String submitGet(String url, NameValuePair[] nameValuePairs) throws JwareApplicationException {
        String result = null;
        this.getMethod = new GetMethodUtil(url);
        if (this.getMethodContentType != null) {
            this.getMethod.setRequestHeader("Content-Type", this.getMethodContentType);
        }
        if (this.requestUserAgent != null) {
            this.getMethod.setRequestHeader("User-Agent", this.requestUserAgent);
        }
        if (this.requestAccept != null) {
            this.getMethod.setRequestHeader("Accept", this.requestAccept);
        }
        if (this.requestAcceptEncoding != null) {
            this.getMethod.setRequestHeader("Accept-Encoding", this.requestAcceptEncoding);
        }
        if (this.requestAcceptLanguage != null) {
            this.getMethod.setRequestHeader("Accept-Language", this.requestAcceptLanguage);
        }
        if (this.sessionId != null) {
            this.getMethod.setRequestHeader("JSESSIONID", this.sessionId);
        }
        this.getMethod.setFollowRedirects(true);
        if (nameValuePairs != null && nameValuePairs.length > 0) {
            this.getMethod.setQueryString(nameValuePairs);
        }
        try {
            int iGetResultCode = this.httpClient.executeMethod((HttpMethod)this.getMethod);
            result = this.charset != null ? this.getMethod.getResponseBodyAsString(this.charset) : this.getMethod.getResponseBodyAsString();
            Header header = this.getMethod.getResponseHeader("Content-Type");
            String contentType = header.getValue();
            String tempCharset = null;
            if (this.getMethod != null) {
                tempCharset = this.getMethod.getRequestCharSet();
            }
            if (contentType != null && contentType.indexOf("text/html") >= 0 && contentType.indexOf("charset") < 0) {
                if (!StringUtils.isEmpty(this.charset)) {
                    result = new String(result.getBytes("iso-8859-1"), this.charset);
                } else if (!StringUtils.isEmpty(tempCharset)) {
                    result = new String(result.getBytes("iso-8859-1"), tempCharset);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new JwareApplicationException("E300001", ex);
        }
        finally {
            this.getMethod.releaseConnection();
        }
        return result;
    }

    public byte[] submitGetByte(String url, NameValuePair[] nameValuePairs) throws JwareApplicationException {
        byte[] result = null;
        this.getMethod = new GetMethodUtil(url);
        if (this.getMethodContentType != null) {
            this.getMethod.setRequestHeader("Content-Type", this.getMethodContentType);
        }
        if (this.requestUserAgent != null) {
            this.getMethod.setRequestHeader("User-Agent", this.requestUserAgent);
        }
        if (this.requestAccept != null) {
            this.getMethod.setRequestHeader("Accept", this.requestAccept);
        }
        if (this.requestAcceptEncoding != null) {
            this.getMethod.setRequestHeader("Accept-Encoding", this.requestAcceptEncoding);
        }
        if (this.requestAcceptLanguage != null) {
            this.getMethod.setRequestHeader("Accept-Language", this.requestAcceptLanguage);
        }
        if (this.sessionId != null) {
            this.getMethod.setRequestHeader("JSESSIONID", this.sessionId);
        }
        this.getMethod.setFollowRedirects(true);
        if (nameValuePairs != null && nameValuePairs.length > 0) {
            this.getMethod.setQueryString(nameValuePairs);
        }
        try {
            int iGetResultCode = this.httpClient.executeMethod((HttpMethod)this.getMethod);
            result = this.getMethod.getResponseBody();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new JwareApplicationException("E300001", ex);
        }
        finally {
            this.getMethod.releaseConnection();
        }
        return result;
    }

    public String submitPost(String url, NameValuePair[] nameValuePairs) throws JwareApplicationException {
        String result = null;
        this.postMethod = new PostMethodUtil(url);
        if (this.postMethodContentType != null) {
            this.postMethod.setRequestHeader("Content-Type", this.postMethodContentType);
        }
        if (this.requestUserAgent != null) {
            this.postMethod.setRequestHeader("User-Agent", this.requestUserAgent);
        }
        if (this.requestAccept != null) {
            this.postMethod.setRequestHeader("Accept", this.requestAccept);
        }
        if (this.requestAcceptEncoding != null) {
            this.postMethod.setRequestHeader("Accept-Encoding", this.requestAcceptEncoding);
        }
        if (this.requestAcceptLanguage != null) {
            this.postMethod.setRequestHeader("Accept-Language", this.requestAcceptLanguage);
        }
        if (this.sessionId != null) {
            this.postMethod.setRequestHeader("JSESSIONID", this.sessionId);
        }
        if (nameValuePairs != null) {
            this.postMethod.setRequestBody(nameValuePairs);
        }
        try {
            int iGetResultCode = this.httpClient.executeMethod((HttpMethod)this.postMethod);
            result = this.charset != null ? this.postMethod.getResponseBodyAsString(this.charset) : this.postMethod.getResponseBodyAsString();
            Header header = this.postMethod.getResponseHeader("Content-Type");
            String contentType = header.getValue();
            String tempCharset = null;
            if (this.getMethod != null) {
                tempCharset = this.getMethod.getRequestCharSet();
            }
            if (contentType != null && contentType.indexOf("text/html") >= 0 && contentType.indexOf("charset") < 0) {
                if (!StringUtils.isEmpty(this.charset)) {
                    result = new String(result.getBytes("iso-8859-1"), this.charset);
                } else if (!StringUtils.isEmpty(tempCharset)) {
                    result = new String(result.getBytes("iso-8859-1"), tempCharset);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new JwareApplicationException("E300001", ex);
        }
        finally {
            this.postMethod.releaseConnection();
        }
        return result;
    }

    public GetMethod getGetMethod() {
        return this.getMethod;
    }

    public void setGetMethod(GetMethodUtil getMethod) {
        this.getMethod = getMethod;
    }

    public PostMethod getPostMethod() {
        return this.postMethod;
    }

    public void setPostMethod(PostMethodUtil postMethod) {
        this.postMethod = postMethod;
    }

    public String getRequestAccept() {
        return this.requestAccept;
    }

    public void setRequestAccept(String requestAccept) {
        this.requestAccept = requestAccept;
    }

    public String getRequestAcceptAuthorization() {
        return this.requestAcceptAuthorization;
    }

    public void setRequestAcceptAuthorization(String requestAcceptAuthorization) {
        this.requestAcceptAuthorization = requestAcceptAuthorization;
    }

    public String getRequestAcceptCharset() {
        return this.requestAcceptCharset;
    }

    public void setRequestAcceptCharset(String requestAcceptCharset) {
        this.requestAcceptCharset = requestAcceptCharset;
    }

    public String getRequestAcceptEncoding() {
        return this.requestAcceptEncoding;
    }

    public void setRequestAcceptEncoding(String requestAcceptEncoding) {
        this.requestAcceptEncoding = requestAcceptEncoding;
    }

    public String getRequestAcceptLanguage() {
        return this.requestAcceptLanguage;
    }

    public void setRequestAcceptLanguage(String requestAcceptLanguage) {
        this.requestAcceptLanguage = requestAcceptLanguage;
    }

    public String getRequestUserAgent() {
        return this.requestUserAgent;
    }

    public void setRequestUserAgent(String requestUserAgent) {
        this.requestUserAgent = requestUserAgent;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getGetMethodContentType() {
        return this.getMethodContentType;
    }

    public void setGetMethodContentType(String contentType) {
        this.getMethodContentType = contentType;
    }

    public String getPostMethodContentType() {
        return this.postMethodContentType;
    }

    public void setPostMethodContentType(String contentType) {
        this.postMethodContentType = contentType;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }
}

