/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.pagination;

import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.Messages;
import org.displaytag.pagination.Pagination;
import org.displaytag.properties.TableProperties;
import org.displaytag.util.Href;
import org.displaytag.util.ShortToStringStyle;

public class SmartListHelper {
    private static Log log = LogFactory.getLog(SmartListHelper.class);
    private List fullList;
    private int fullListSize;
    private int pageSize;
    private int pageCount;
    private int currentPage;
    private TableProperties properties;

    public SmartListHelper(List list, int fullSize, int itemsInPage, TableProperties tableProperties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getString("SmartListHelper.debug.instantiated", new Object[]{new Integer(list.size()), new Integer(itemsInPage), new Integer(fullSize)}));
        }
        this.properties = tableProperties;
        this.pageSize = itemsInPage;
        this.fullList = list;
        this.fullListSize = fullSize;
        this.pageCount = this.computedPageCount();
        this.currentPage = 1;
    }

    protected int computedPageCount() {
        int size = this.fullListSize;
        int div2 = size / this.pageSize;
        int mod = size % this.pageSize;
        int result = mod == 0 ? div2 : div2 + 1;
        return result;
    }

    public int getFirstIndexForCurrentPage() {
        return this.getFirstIndexForPage(this.currentPage);
    }

    protected int getLastIndexForCurrentPage() {
        return this.getLastIndexForPage(this.currentPage);
    }

    protected int getFirstIndexForPage(int pageNumber) {
        return (pageNumber - 1) * this.pageSize;
    }

    protected int getLastIndexForPage(int pageNumber) {
        int firstIndex = this.getFirstIndexForPage(pageNumber);
        int pageIndex = this.pageSize - 1;
        int lastIndex = this.fullListSize - 1;
        return Math.min(firstIndex + pageIndex, lastIndex);
    }

    public List getListForCurrentPage() {
        return this.getListForPage(this.currentPage);
    }

    protected List getListForPage(int pageNumber) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getString("SmartListHelper.debug.sublist", new Object[]{new Integer(pageNumber)}));
        }
        int firstIndex = this.getFirstIndexForPage(pageNumber);
        int lastIndex = this.getLastIndexForPage(pageNumber);
        return this.fullList.subList(firstIndex, lastIndex + 1);
    }

    public void setCurrentPage(int pageNumber) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getString("SmartListHelper.debug.currentpage", new Object[]{new Integer(pageNumber), new Integer(this.pageCount)}));
        }
        this.currentPage = pageNumber < 1 || pageNumber != 1 && pageNumber > this.pageCount ? 1 : pageNumber;
    }

    public String getSearchResultsSummary() {
        String message;
        Object[] objs;
        if (this.fullListSize == 0) {
            objs = new Object[]{this.properties.getPagingItemsName()};
            message = this.properties.getPagingFoundNoItems();
        } else if (this.fullListSize == 1) {
            objs = new Object[]{this.properties.getPagingItemName()};
            message = this.properties.getPagingFoundOneItem();
        } else if (this.computedPageCount() == 1) {
            objs = new Object[]{new Integer(this.fullListSize), this.properties.getPagingItemsName(), this.properties.getPagingItemsName()};
            message = this.properties.getPagingFoundAllItems();
        } else {
            objs = new Object[]{new Integer(this.fullListSize), this.properties.getPagingItemsName(), new Integer(this.getFirstIndexForCurrentPage() + 1), new Integer(this.getLastIndexForCurrentPage() + 1), new Integer(this.currentPage), new Integer(this.pageCount)};
            message = this.properties.getPagingFoundSomeItems();
        }
        return MessageFormat.format(message, objs);
    }

    public String getPageNavigationBar(Href baseHref, String pageParameter) {
        int groupSize = this.properties.getPagingGroupSize();
        Pagination pagination = new Pagination(baseHref, pageParameter);
        pagination.setCurrent(new Integer(this.currentPage));
        if (this.pageCount == 0) {
            pagination.addPage(1, true);
        }
        int startPage = Math.max(Math.min(this.currentPage - groupSize / 2, this.pageCount - groupSize), 1);
        int endPage = Math.min(startPage + groupSize - 1, this.pageCount);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Displaying pages from " + startPage + " to " + endPage));
        }
        if (this.currentPage != 1) {
            pagination.setFirst(new Integer(1));
            pagination.setPrevious(new Integer(this.currentPage - 1));
        }
        for (int j = startPage; j <= endPage; ++j) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("adding page " + j));
            }
            pagination.addPage(j, j == this.currentPage);
        }
        if (this.currentPage != this.pageCount) {
            pagination.setNext(new Integer(this.currentPage + 1));
            pagination.setLast(new Integer(this.pageCount));
        }
        String bannerFormat = pagination.isOnePage() ? this.properties.getPagingBannerOnePage() : (pagination.isFirst() ? this.properties.getPagingBannerFirst() : (pagination.isLast() ? this.properties.getPagingBannerLast() : this.properties.getPagingBannerFull()));
        return pagination.getFormattedBanner(this.properties.getPagingPageLink(), this.properties.getPagingPageSelected(), this.properties.getPagingPageSeparator(), bannerFormat);
    }

    public String toString() {
        return new ToStringBuilder(this, ShortToStringStyle.SHORT_STYLE).append("fullList", this.fullList).append("fullListSize", this.fullListSize).append("pageSize", this.pageSize).append("pageCount", this.pageCount).append("properties", this.properties).append("currentPage", this.currentPage).toString();
    }
}

