/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.tags;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.decorator.DecoratorFactory;
import org.displaytag.exception.DecoratorInstantiationException;
import org.displaytag.exception.ObjectLookupException;
import org.displaytag.exception.TagStructureException;
import org.displaytag.model.Cell;
import org.displaytag.model.HeaderCell;
import org.displaytag.properties.MediaTypeEnum;
import org.displaytag.tags.TableTag;
import org.displaytag.util.Href;
import org.displaytag.util.HtmlAttributeMap;
import org.displaytag.util.MultipleHtmlAttribute;
import org.displaytag.util.ShortToStringStyle;

public class ColumnTag
extends BodyTagSupport {
    private static final long serialVersionUID = 899149338534L;
    private static Log log = LogFactory.getLog(ColumnTag.class);
    private HtmlAttributeMap attributeMap = new HtmlAttributeMap();
    private HtmlAttributeMap headerAttributeMap = new HtmlAttributeMap();
    private String property;
    private String title;
    private boolean nulls;
    private boolean sortable;
    private boolean autolink;
    private int group = -1;
    private Href href;
    private String paramId;
    private String paramName;
    private String paramProperty;
    private String paramScope;
    private int maxLength;
    private int maxWords;
    private String decorator;
    private boolean alreadySorted;
    private List supportedMedia;
    private String titleKey;
    private String sortProperty;

    public void setProperty(String value) {
        this.property = value;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public void setNulls(boolean value) {
        this.nulls = value;
    }

    public void setSortable(boolean value) {
        this.sortable = value;
    }

    public void setAutolink(boolean value) {
        this.autolink = value;
    }

    public void setGroup(int value) {
        this.group = value;
    }

    public void setTitleKey(String value) {
        this.titleKey = value;
    }

    public void setHref(String value) {
        String encodedHref = ((HttpServletResponse)this.pageContext.getResponse()).encodeURL(StringUtils.defaultString(value));
        this.href = new Href(encodedHref);
    }

    public void setUrl(String value) {
        HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
        String encodedHref = ((HttpServletResponse)this.pageContext.getResponse()).encodeURL(StringUtils.defaultString(req.getContextPath() + value));
        this.href = new Href(encodedHref);
    }

    public void setParamId(String value) {
        this.paramId = value;
    }

    public void setParamName(String value) {
        this.paramName = value;
    }

    public void setParamProperty(String value) {
        this.paramProperty = value;
    }

    public void setParamScope(String value) {
        this.paramScope = value;
    }

    public void setMaxLength(int value) {
        this.maxLength = value;
    }

    public void setMaxWords(int value) {
        this.maxWords = value;
    }

    public void setWidth(String value) {
        this.attributeMap.put("width", value);
        this.headerAttributeMap.put("width", value);
    }

    public void setAlign(String value) {
        this.attributeMap.put("align", value);
        this.headerAttributeMap.put("align", value);
    }

    public void setBackground(String value) {
        this.attributeMap.put("background", value);
    }

    public void setBgcolor(String value) {
        this.attributeMap.put("bgcolor", value);
    }

    public void setHeight(String value) {
        this.attributeMap.put("height", value);
    }

    public void setNowrap(String value) {
        this.attributeMap.put("nowrap", "nowrap");
    }

    public void setValign(String value) {
        this.attributeMap.put("valign", value);
    }

    public void setStyle(String value) {
        this.attributeMap.put("style", value);
    }

    public void setClass(String value) {
        this.attributeMap.put("class", new MultipleHtmlAttribute(value));
    }

    public void addClass(String value) {
        Object classAttributes = this.attributeMap.get("class");
        if (classAttributes == null) {
            this.attributeMap.put("class", new MultipleHtmlAttribute(value));
        } else {
            ((MultipleHtmlAttribute)classAttributes).addAttributeValue(value);
        }
    }

    public void setHeaderClass(String value) {
        this.headerAttributeMap.put("class", new MultipleHtmlAttribute(value));
    }

    public void setDecorator(String value) {
        this.decorator = value;
    }

    public void setSortProperty(String value) {
        this.sortProperty = value;
    }

    public boolean availableForMedia(MediaTypeEnum mediaType) {
        if (this.supportedMedia == null) {
            return true;
        }
        return this.supportedMedia.contains(mediaType);
    }

    public void setMedia(String media) {
        if (StringUtils.isBlank(media) || media.toLowerCase().indexOf("all") > -1) {
            this.supportedMedia = null;
            return;
        }
        this.supportedMedia = new ArrayList();
        String[] values = StringUtils.split(media);
        for (int i2 = 0; i2 < values.length; ++i2) {
            String value = values[i2];
            if (StringUtils.isBlank(value)) continue;
            MediaTypeEnum type = MediaTypeEnum.fromName(value.toLowerCase());
            if (type == null) {
                log.warn((Object)("Unrecognized value for attribute \"media\" value=\"" + value + "\""));
                continue;
            }
            this.supportedMedia.add(type);
        }
    }

    public int doEndTag() throws JspException {
        Cell cell;
        TableTag tableTag = (TableTag)ColumnTag.findAncestorWithClass((Tag)this, TableTag.class);
        MediaTypeEnum currentMediaType = (MediaTypeEnum)this.pageContext.findAttribute("mediaType");
        if (currentMediaType != null && !this.availableForMedia(currentMediaType)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("skipping column body, currentMediaType=" + currentMediaType));
            }
            return 0;
        }
        if (tableTag.isFirstIteration()) {
            this.addHeaderToTable(tableTag);
        }
        if (!tableTag.isIncludedRow()) {
            return super.doEndTag();
        }
        if (this.property == null) {
            Object cellValue;
            if (this.bodyContent != null) {
                String value = this.bodyContent.getString();
                if (value == null && this.nulls) {
                    value = "";
                }
                cellValue = value;
            } else {
                cellValue = Cell.EMPTY_CELL;
            }
            cell = new Cell(cellValue);
        } else {
            cell = Cell.EMPTY_CELL;
        }
        tableTag.addCell(cell);
        this.alreadySorted = false;
        return super.doEndTag();
    }

    private void addHeaderToTable(TableTag tableTag) throws DecoratorInstantiationException, ObjectLookupException {
        String evalTitle = this.title;
        if (evalTitle == null && (this.titleKey != null || this.property != null)) {
            evalTitle = tableTag.getProperties().geResourceProvider().getResource(this.titleKey, this.property, (Tag)tableTag, this.pageContext);
        }
        HeaderCell headerCell = new HeaderCell();
        headerCell.setHeaderAttributes((HtmlAttributeMap)this.headerAttributeMap.clone());
        headerCell.setHtmlAttributes((HtmlAttributeMap)this.attributeMap.clone());
        headerCell.setTitle(evalTitle);
        headerCell.setSortable(this.sortable);
        headerCell.setColumnDecorator(DecoratorFactory.loadColumnDecorator(this.decorator));
        headerCell.setBeanPropertyName(this.property);
        headerCell.setShowNulls(this.nulls);
        headerCell.setMaxLength(this.maxLength);
        headerCell.setMaxWords(this.maxWords);
        headerCell.setAutoLink(this.autolink);
        headerCell.setGroup(this.group);
        headerCell.setSortProperty(this.sortProperty);
        if (this.href != null) {
            Href colHref = StringUtils.isEmpty(this.href.getBaseUrl()) ? new Href(tableTag.getBaseHref()) : new Href(this.href);
            if (this.paramId != null) {
                if (this.paramName != null || this.paramScope != null) {
                    StringBuffer expression = new StringBuffer();
                    if (StringUtils.isNotBlank(this.paramScope)) {
                        expression.append(this.paramScope).append("Scope.");
                    }
                    if (this.paramId != null) {
                        expression.append(this.paramName);
                    } else {
                        expression.append(tableTag.getName());
                    }
                    if (StringUtils.isNotBlank(this.paramProperty)) {
                        expression.append('.').append(this.paramProperty);
                    }
                    Object paramValue = tableTag.evaluateExpression(expression.toString());
                    colHref.addParameter(this.paramId, paramValue);
                } else {
                    headerCell.setParamName(this.paramId);
                    headerCell.setParamProperty(this.paramProperty);
                }
            }
            headerCell.setHref(colHref);
        }
        tableTag.addColumn(headerCell);
        if (log.isDebugEnabled()) {
            log.debug((Object)("columnTag.addHeaderToTable() :: first iteration - adding header " + headerCell));
        }
    }

    public void release() {
        super.release();
        this.attributeMap.clear();
        this.autolink = false;
        this.decorator = null;
        this.group = -1;
        this.headerAttributeMap.clear();
        this.href = null;
        this.maxLength = 0;
        this.maxWords = 0;
        this.nulls = false;
        this.paramId = null;
        this.paramName = null;
        this.paramProperty = null;
        this.paramScope = null;
        this.property = null;
        this.sortable = false;
        this.supportedMedia = null;
        this.title = null;
        this.titleKey = null;
        this.sortProperty = null;
    }

    public int doStartTag() throws JspException {
        TableTag tableTag = (TableTag)ColumnTag.findAncestorWithClass((Tag)this, TableTag.class);
        if (tableTag == null) {
            throw new TagStructureException(((Object)((Object)this)).getClass(), "column", "table");
        }
        if (tableTag.isEmpty() || !tableTag.isIncludedRow()) {
            return 0;
        }
        MediaTypeEnum currentMediaType = (MediaTypeEnum)this.pageContext.findAttribute("mediaType");
        if (!this.availableForMedia(currentMediaType)) {
            return 0;
        }
        return super.doStartTag();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ShortToStringStyle.SHORT_STYLE).append("bodyContent", this.bodyContent).append("group", this.group).append("maxLength", this.maxLength).append("decorator", this.decorator).append("href", this.href).append("title", this.title).append("paramScope", this.paramScope).append("property", this.property).append("paramProperty", this.paramProperty).append("headerAttributeMap", this.headerAttributeMap).append("paramName", this.paramName).append("autolink", this.autolink).append("nulls", this.nulls).append("maxWords", this.maxWords).append("attributeMap", this.attributeMap).append("sortable", this.sortable).append("paramId", this.paramId).append("alreadySorted", this.alreadySorted).append("sortProperty", this.sortProperty).toString();
    }
}

