/*
 * Decompiled with CFR 0.152.
 */
package compiere.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.compiere.api.ModelValidator;
import org.compiere.framework.Info_Column;
import org.compiere.framework.ModelValidationEngine;
import org.compiere.framework.PO;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(MyValidator.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        this.m_AD_Client_ID = client.getAD_Client_ID();
        if (this.m_AD_Client_ID != 11) {
            return;
        }
        log.info(client.toString());
        engine.addModelChange("C_Order", (ModelValidator)this);
        engine.addDocValidate("C_Order", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        if (po.get_TableName().equals("C_Order") && type == 2) {
            MOrder order = (MOrder)po;
            log.info(po.toString());
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        if (timing == 9) {
            return null;
        }
        if (po.get_TableName().equals("C_Order")) {
            log.info(po.toString());
        }
        return null;
    }

    private String orderDiscount(MOrder order) {
        String DISCOUNT = "Discount";
        int C_Tax_ID = 0;
        BigDecimal totalLines = Env.ZERO;
        MOrderLine discountLine = null;
        MOrderLine[] lines = order.getLines();
        for (int i = 0; i < lines.length; ++i) {
            MOrderLine oLine = lines[i];
            String description = oLine.getDescription();
            if (description != null && description.equals(DISCOUNT)) {
                discountLine = oLine;
                continue;
            }
            totalLines = totalLines.add(oLine.getLineNetAmt());
            if (C_Tax_ID == 0) {
                C_Tax_ID = oLine.getC_Tax_ID();
                continue;
            }
            if (C_Tax_ID == oLine.getC_Tax_ID()) continue;
            return "Order has more then one Tax, cannot add discount";
        }
        if (discountLine == null) {
            discountLine = new MOrderLine(order);
            discountLine.setDescription(DISCOUNT);
            discountLine.setQty(Env.ONE);
            discountLine.setC_Tax_ID(C_Tax_ID);
            discountLine.setLine(9999);
        }
        BigDecimal discountPercent = new BigDecimal(3);
        BigDecimal discountAmt = totalLines.multiply(discountPercent);
        discountAmt = discountAmt.divide(Env.ONEHUNDRED, order.getPrecision(), 4);
        discountLine.setPrice(discountAmt.negate());
        if (!discountLine.save()) {
            return "Could not save discount line";
        }
        log.info(discountLine.toString());
        order.getLines(true, null);
        return null;
    }

    public boolean updateInfoColumns(ArrayList<Info_Column> columns, StringBuffer sqlFrom, StringBuffer sqlOrder) {
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MyValidator[Order@Gardenworld");
        sb.append("]");
        return sb.toString();
    }
}

