/*
 * Decompiled with CFR 0.152.
 */
package compiere.process;

import compiere.model.X_I_ImpFormat_Row;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.impexp.MImpFormat;
import org.compiere.impexp.MImpFormatRow;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class ImportImpFormat
extends SvrProcess {
    private int m_AD_Client_ID = 0;
    private int m_AD_Org_ID = 0;
    private boolean m_deleteOldImported = false;
    private String m_ImpFormat;
    private Timestamp m_DateValue = null;
    private Ctx m_ctx;
    private int impFormatID = 0;

    protected void prepare() {
        this.m_ctx = this.getCtx();
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (name.equals("AD_Client_ID")) {
                this.m_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("AD_Org_ID")) {
                this.m_AD_Org_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("DeleteOldImported")) {
                this.m_deleteOldImported = "Y".equals(para[i].getParameter());
                continue;
            }
            if (name.equals("ImpFormatName")) {
                this.m_ImpFormat = (String)para[i].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.m_DateValue == null) {
            this.m_DateValue = new Timestamp(System.currentTimeMillis());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String doIt() throws Exception {
        X_I_ImpFormat_Row imp;
        ResultSet rs;
        this.log.info("");
        StringBuffer sql = null;
        int errNo = 0;
        int no = 0;
        String clientCheck = " AND AD_Client_ID=" + this.m_AD_Client_ID;
        if (this.m_deleteOldImported) {
            sql = new StringBuffer("DELETE I_ImpFormat_Row WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            this.log.fine("Delete Old Impored =" + no);
        }
        sql = new StringBuffer("UPDATE I_ImpFormat_Row SET AD_Client_ID = COALESCE (AD_Client_ID,").append(this.m_AD_Client_ID).append("), AD_Org_ID = COALESCE (AD_Org_ID,").append(this.m_AD_Org_ID).append("),");
        sql.append(" IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = NULL, I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL").append(clientCheck);
        if (this.m_ImpFormat != null) {
            sql.append(" AND IMPFORMATNAME='" + this.m_ImpFormat + "'");
        }
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.info("Reset=" + no);
        sql = new StringBuffer("UPDATE I_ImpFormat_Row o SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Org, 'WHERE (AD_Org_ID IS NULL  OR EXISTS (SELECT * FROM AD_Org oo WHERE o.AD_Org_ID=oo.AD_Org_ID AND (oo.IsSummary='Y' OR oo.IsActive='N'))) AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        errNo += no;
        if (no != 0) {
            this.log.warning("Invalid Org=" + no);
        }
        sql = new StringBuffer("UPDATE I_ImpFormat_Row i SET i.AD_TABLE_ID=(  SELECT a.AD_TABLE_ID  FROM AD_TABLE a  WHERE a.TABLENAME=i.TableName ) WHERE (i.I_IsImported<>'Y' OR i.I_IsImported IS NULL)").append(clientCheck);
        if (this.m_ImpFormat != null) {
            sql.append(" AND IMPFORMATNAME='" + this.m_ImpFormat + "'");
        }
        if ((no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName())) != 0) {
            this.log.info("AD_Table_ID=" + no);
        }
        this.commit();
        sql = new StringBuffer("UPDATE I_ImpFormat_Row SET I_isImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Table Name, ' WHERE AD_TABLE_ID IS NULL AND (I_isImported<>'Y' OR I_isImported IS NULL)").append(clientCheck);
        if (this.m_ImpFormat != null) {
            sql.append(" AND IMPFORMATNAME='" + this.m_ImpFormat + "'");
        }
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        errNo += no;
        if (no != 0) {
            this.log.warning("Invalid Table Name=" + no);
        }
        sql = new StringBuffer("UPDATE I_ImpFormat_Row i SET i.AD_COLUMN_ID=(  SELECT a.AD_COLUMN_ID  FROM AD_COLUMN a  WHERE a.COLUMNNAME=i.COLUMNNAME  AND a.AD_TABLE_ID=i.AD_TABLE_ID ) WHERE (i.I_IsImported<>'Y' OR i.I_IsImported IS NULL) AND (i.AD_Column_ID IS NULL or i.AD_Column_ID =0)").append(clientCheck);
        if (this.m_ImpFormat != null) {
            sql.append(" AND i.IMPFORMATNAME='" + this.m_ImpFormat + "'");
        }
        if ((no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName())) != 0) {
            this.log.info("Set Column=" + no);
        }
        sql = new StringBuffer("UPDATE I_ImpFormat_Row SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Column,' WHERE AD_Column_ID IS NULL AND COLUMNNAME IS NOT NULL AND I_IsImported<>'E'  AND I_IsImported<>'Y'").append(clientCheck);
        if (this.m_ImpFormat != null) {
            sql.append(" AND IMPFORMATNAME='" + this.m_ImpFormat + "'");
        }
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        errNo += no;
        if (no != 0) {
            this.log.warning("Invalid Column=" + no);
        }
        this.commit();
        if (errNo != 0) {
            return "";
        }
        sql = new StringBuffer("SELECT * FROM I_ImpFormat_Row WHERE I_IsImported<>'Y' AND ROWNUM=1").append(clientCheck);
        if (this.m_ImpFormat != null) {
            sql.append(" AND IMPFORMATNAME='" + this.m_ImpFormat + "'");
        }
        CPreparedStatement pstmt = null;
        int noInsert = 0;
        int noInsertItem = 0;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                block32: {
                    imp = new X_I_ImpFormat_Row(this.m_ctx, rs, this.get_TrxName());
                    imp.setAD_ImpFormat_ID(MImpFormat.getAD_ImportFormat_ID((String)imp.getImpFormatName()));
                    MImpFormat impFormat = null;
                    if (imp.getAD_ImpFormat_ID() == 0) {
                        impFormat = new MImpFormat(this.m_ctx, imp.getAD_ImpFormat_ID(), this.get_TrxName());
                        impFormat.setClientOrg((PO)imp);
                        impFormat.setAD_Org_ID(imp.getAD_Org_ID());
                        impFormat.setName(imp.getImpFormatName());
                        impFormat.setDescription(imp.getDescription());
                        impFormat.setFormatType(imp.getFormatType());
                        impFormat.setAD_Table_ID(imp.getAD_Table_ID());
                        if (impFormat.save()) {
                            imp.setAD_ImpFormat_ID(impFormat.getAD_ImpFormat_ID());
                            this.log.finest("Insert ImpFormat - " + impFormat.getAD_ImpFormat_ID());
                            this.impFormatID = impFormat.getAD_ImpFormat_ID();
                            ++noInsert;
                            break block32;
                        } else {
                            sql = new StringBuffer("UPDATE I_ImpFormat_Row i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Cannot Insert ImpFormat,'").append(" WHERE AD_ImpFormat_ID=").append(imp.getAD_ImpFormat_ID());
                            DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                            continue;
                        }
                    }
                    impFormat = new MImpFormat(this.m_ctx, imp.getAD_ImpFormat_ID(), this.get_TrxName());
                    impFormat.setAD_Org_ID(imp.getAD_Org_ID());
                    impFormat.setName(imp.getImpFormatName());
                    impFormat.setDescription(imp.getDescription());
                    impFormat.setFormatType(imp.getFormatType());
                    impFormat.setAD_Table_ID(imp.getAD_Table_ID());
                    if (impFormat.save()) {
                        imp.setAD_ImpFormat_ID(impFormat.getAD_ImpFormat_ID());
                        imp.save();
                        this.impFormatID = impFormat.getAD_ImpFormat_ID();
                        ++noInsert;
                    } else {
                        sql = new StringBuffer("UPDATE I_ImpFormat_Row i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Cannot Update ImpFormat,'").append(" WHERE AD_ImpFormat_ID=").append(imp.getAD_ImpFormat_ID());
                        DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                        continue;
                    }
                }
                this.commit();
            }
            rs.close();
            pstmt.close();
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        sql = new StringBuffer("SELECT * FROM I_ImpFormat_Row WHERE I_IsImported<>'Y'").append(clientCheck);
        if (this.m_ImpFormat != null) {
            sql.append(" AND IMPFORMATNAME='" + this.m_ImpFormat + "'");
        }
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                block33: {
                    imp = new X_I_ImpFormat_Row(this.m_ctx, rs, this.get_TrxName());
                    MImpFormatRow impFormatRow = null;
                    if (imp.getAD_ImpFormat_Row_ID() == 0) {
                        imp.setAD_ImpFormat_ID(this.impFormatID);
                        impFormatRow = new MImpFormatRow(this.m_ctx, imp.getAD_ImpFormat_Row_ID(), this.get_TrxName());
                        impFormatRow.setClientOrg((PO)imp);
                        impFormatRow.setAD_Org_ID(imp.getAD_Org_ID());
                        impFormatRow.setAD_ImpFormat_ID(imp.getAD_ImpFormat_ID());
                        impFormatRow.setName(imp.getRowName());
                        impFormatRow.setStartNo(imp.getStartNo());
                        impFormatRow.setEndNo(imp.getEndNo());
                        impFormatRow.setDataType(imp.getDataType());
                        impFormatRow.setDataFormat(imp.getDataFormat());
                        impFormatRow.setDecimalPoint(imp.getDecimalPoint());
                        impFormatRow.setDivideBy100(imp.isDivideBy100());
                        impFormatRow.setConstantValue(imp.getConstantValue());
                        impFormatRow.setCallout(imp.getCallout());
                        impFormatRow.setScript(imp.getScript());
                        impFormatRow.setSeqNo(imp.getSeqNo());
                        if (imp.getAD_Column_ID() > 0) {
                            impFormatRow.setAD_Column_ID(imp.getAD_Column_ID());
                        }
                        if (impFormatRow.save()) {
                            imp.setAD_ImpFormat_ID(impFormatRow.getAD_ImpFormat_ID());
                            imp.setAD_ImpFormat_Row_ID(impFormatRow.getAD_ImpFormat_Row_ID());
                            imp.setI_IsImported(true);
                            imp.setProcessed(true);
                            imp.save();
                            this.log.finest("Insert ImpFormatItem - " + impFormatRow.getAD_ImpFormat_Row_ID());
                            ++noInsertItem;
                            break block33;
                        } else {
                            sql = new StringBuffer("UPDATE I_ImpFormat_Row i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Cannot Insert ImpFormatItem,'").append(" WHERE AD_ImpFormat_Row_ID=").append(imp.getAD_ImpFormat_Row_ID());
                            DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                            continue;
                        }
                    }
                    impFormatRow.setAD_Org_ID(imp.getAD_Org_ID());
                    impFormatRow.setName(imp.getRowName());
                    impFormatRow.setStartNo(imp.getStartNo());
                    impFormatRow.setEndNo(imp.getEndNo());
                    impFormatRow.setDataType(imp.getDataType());
                    impFormatRow.setDataFormat(imp.getDataFormat());
                    impFormatRow.setDecimalPoint(imp.getDecimalPoint());
                    impFormatRow.setDivideBy100(imp.isDivideBy100());
                    impFormatRow.setConstantValue(imp.getConstantValue());
                    impFormatRow.setCallout(imp.getCallout());
                    impFormatRow.setScript(imp.getScript());
                    impFormatRow.setSeqNo(imp.getSeqNo());
                    if (imp.getAD_Column_ID() > 0) {
                        impFormatRow.setAD_Column_ID(imp.getAD_Column_ID());
                    }
                    if (impFormatRow.save()) {
                        imp.setAD_ImpFormat_ID(impFormatRow.getAD_ImpFormat_ID());
                        imp.setAD_ImpFormat_Row_ID(impFormatRow.getAD_ImpFormat_Row_ID());
                        imp.setI_IsImported(true);
                        imp.setProcessed(true);
                        imp.save();
                        ++noInsertItem;
                    } else {
                        sql = new StringBuffer("UPDATE I_ImpFormat_Row i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Cannot Update ImpFormatItem,'").append(" WHERE AD_ImpFormat_Row_ID=").append(imp.getAD_ImpFormat_Row_ID());
                        DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                        continue;
                    }
                }
                this.commit();
            }
            rs.close();
            pstmt.close();
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        sql = new StringBuffer("UPDATE I_ImpFormat_Row SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsert), "@AD_ImpFormat_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noInsertItem), "@AD_ImpFormat_Row_ID@: @Inserted@");
        return "";
    }
}

