/*
 * Decompiled with CFR 0.152.
 */
package compiere.process;

import compiere.model.X_I_Postal;
import compiere.model.X_X_Postal;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ImportPostal
extends SvrProcess {
    private int p_AD_Client_ID = 0;
    private boolean p_DeleteOldImported = false;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("AD_Client_ID")) {
                this.p_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("DeleteOldImported")) {
                this.p_DeleteOldImported = "Y".equals(para[i].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        StringBuffer sql = null;
        int no = 0;
        String clientCheck = " AND AD_Client_ID=" + this.p_AD_Client_ID;
        if (this.p_DeleteOldImported) {
            sql = new StringBuffer("DELETE I_Postal WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            this.log.fine("Delete Old Impored =" + no);
        }
        sql = new StringBuffer("UPDATE I_Postal set X_ADDRESS_KANA = '', X_ADDRESS ='' where X_ADDRESS like '\u4ee5\u4e0b\u306b\u63b2\u8f09\u304c\u306a\u3044\u5834\u5408%'");
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set X_ADDRESS Blank=" + no);
        sql = new StringBuffer("UPDATE I_Postal i SET C_Region_ID=(SELECT MIN(C_Region_ID) FROM C_Region r  WHERE i.X_Region_Name=r.Name AND i.AD_Client_ID=r.AD_Client_ID) WHERE C_Region_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set C_Region_ID=" + no);
        String ts = DB.isPostgreSQL() ? "COALESCE(I_ErrorMsg,'')" : "I_ErrorMsg";
        sql = new StringBuffer("UPDATE I_Postal SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=No C_Region_ID, ' " + "WHERE C_Region_ID IS NULL" + " AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("No C_Region_ID=" + no);
        }
        sql = new StringBuffer("UPDATE I_Postal i SET C_Country_ID=(SELECT MIN(C_Country_ID) FROM C_Region r  WHERE i.X_Region_Name=r.Name AND i.AD_Client_ID=r.AD_Client_ID) WHERE C_Country_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set C_Country_ID=" + no);
        sql = new StringBuffer("UPDATE I_Postal SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=No C_Country_ID, ' " + "WHERE C_Country_ID IS NULL" + " AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("No C_Country_ID=" + no);
        }
        this.log.fine("Set Postal ID DocType=" + no);
        this.commit();
        int noInsert = 0;
        sql = new StringBuffer("SELECT i.I_POSTAL_ID, i.AD_CLIENT_ID, i.AD_ORG_ID, i.ISACTIVE, i.CREATED,  i.CREATEDBY, i.UPDATED, i.UPDATEDBY, i.C_COUNTRY_ID, i.C_REGION_ID, i.I_ERRORMSG,  i.I_ISIMPORTED, i.AREACODE, i.OLDZIP, i.POSTAL, p.X_POSTAL_ID,  i.X_REGION_NAME_KANA, i.X_CITY_NAME_KANA, i.X_ADDRESS_KANA, i.X_REGION_NAME,  i.X_CITY_NAME, i.X_ADDRESS, i.IS_DUPLICATE, i.IS_RECURSIVE, i.IS_INCLUDE_ADDRNO,  i.IS_MULTI_ZIP, i.IS_UPDATED, i.UPDATE_REASON, i.PROCESSED, i.PROCESSING  FROM I_Postal i LEFT OUTER JOIN X_Postal p  ON (p.Postal=i.Postal AND p.AD_Client_ID=i.AD_Client_ID) WHERE i.I_IsImported='N' AND i.IsActive='Y' ");
        sql.append(" AND i.AD_Client_ID=" + this.p_AD_Client_ID);
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_I_Postal imp = new X_I_Postal(this.getCtx(), rs, this.get_TrxName());
                X_X_Postal postal = null;
                postal = imp.getX_Postal_ID() != 0 ? new X_X_Postal(this.getCtx(), imp.getX_Postal_ID(), this.get_TrxName()) : new X_X_Postal(this.getCtx(), 0, this.get_TrxName());
                postal.setC_Country_ID(imp.getC_Country_ID());
                postal.setC_Region_ID(imp.getC_Region_ID());
                postal.setAreaCode(imp.getAreaCode());
                postal.setOldzip(imp.getOldzip());
                postal.setPostal(imp.getPostal());
                postal.setX_Region_Name_Kana(imp.getX_Region_Name_Kana());
                postal.setX_City_Name_Kana(imp.getX_City_Name_Kana());
                postal.setX_Address_Kana(imp.getX_Address_Kana());
                postal.setX_Region_Name(imp.getX_Region_Name());
                postal.setX_City_Name(imp.getX_City_Name());
                postal.setX_Address(imp.getX_Address());
                postal.setIs_Duplicate("1".equals(imp.getIs_Duplicate()));
                postal.setIs_Recursive("1".equals(imp.getIs_Recursive()));
                postal.setIs_Include_Addrno("1".equals(imp.getIs_Include_Addrno()));
                postal.setIs_Multi_Zip("1".equals(imp.getIs_Multi_Zip()));
                postal.setIs_Updated("1".equals(imp.getIs_Updated()));
                postal.setUpdate_Reason(imp.getUpdate_Reason());
                if (!postal.save()) {
                    sql = new StringBuffer("UPDATE I_Postal SET I_IsImported='N', Updated=SysDate WHERE I_Postal_ID=" + imp.getI_Postal_ID());
                    no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                    this.log.warning("get Error on saving Postal=" + imp.getPostal());
                } else {
                    imp.setI_IsImported(true);
                    imp.setProcessed(true);
                }
                imp.save();
                ++noInsert;
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        this.addLog(0, null, new BigDecimal(noInsert), "@OK@");
        return "";
    }
}

