/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/

package org.compiere.model;

import java.sql.*;

import org.compiere.util.*;

/**
 * @author Jorg Janke
 *
 */
public class MReference extends X_AD_Reference
{
	/**
	 * 	Get Reference from Cache
	 *	@param ctx context
	 *	@param AD_Reference_ID id
	 *	@return MReference
	 */
	public static MReference get (Ctx ctx, int AD_Reference_ID)
	{
		Integer key = new Integer(AD_Reference_ID);
		MReference retValue = s_cache.get(key);
		if (retValue == null)
			return new MReference (ctx, AD_Reference_ID, null);
		if (retValue.get_ID () != 0)
			s_cache.put (key, retValue);
		return retValue;
	}	//	get
	
	/**	Cache						*/
	private static CCache<Integer,MReference> s_cache = new CCache<Integer,MReference>("AD_Reference", 20);

	
	/**
	 * @param ctx
	 * @param AD_Reference_ID
	 * @param trxName
	 */
	public MReference(Ctx ctx, int AD_Reference_ID, String trxName)
	{
		super(ctx, AD_Reference_ID, trxName);
	}

	/**
	 * @param ctx
	 * @param rs
	 * @param trxName
	 */
	public MReference(Ctx ctx, ResultSet rs, String trxName)
	{
		super(ctx, rs, trxName);
	}

	/**
	 * 	String Representation
	 * 	@return info
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer("MReference[")
			.append(get_ID()).append("-").append(getName()).append("]");
		return sb.toString();
	}	//	toString

}
