/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

/** Generated Model - DO NOT CHANGE */
import java.sql.*;
import java.math.*;
import org.compiere.framework.*;
import org.compiere.util.*;
/** Generated Model for AD_Client
 *  @author Jorg Janke (generated) 
 *  @version Release 3.0.0 - $Id: X_AD_Client.java,v 1.1.4.1 2009/03/29 07:41:03 jrmt Exp $ */
public class X_AD_Client extends PO
{
/** Standard Constructor
@param ctx context
@param AD_Client_ID id
@param trxName transaction
*/
public X_AD_Client (Ctx ctx, int AD_Client_ID, String trxName)
{
super (ctx, AD_Client_ID, trxName);
/** if (AD_Client_ID == 0)
{
setAutoArchive (null);	// N
setIsCostImmediate (false);	// N
setIsMultiLingualDocument (false);
setIsPostImmediate (false);	// N
setIsServerEMail (false);
setIsSmtpAuthorization (false);	// N
setIsUseBetaFunctions (true);	// Y
setMMPolicy (null);	// F
setName (null);
setValue (null);
}
 */
}
/** Load Constructor 
@param ctx context
@param rs result set 
@param trxName transaction
*/
public X_AD_Client (Ctx ctx, ResultSet rs, String trxName)
{
super (ctx, rs, trxName);
}
/** Serial Version No */
static final long serialVersionUID = 27453102008789L;
/** Last Updated Timestamp 2007-02-09 08:18:12.0 */
public static final long updatedMS = 1170976692000L;
/** AD_Table_ID=112 */
public static final int Table_ID=112;

/** TableName=AD_Client */
public static final String Table_Name="AD_Client";

protected static KeyNamePair Model = new KeyNamePair(112,"AD_Client");

protected BigDecimal accessLevel = new BigDecimal(6);
/** AccessLevel
@return 6 - System - Client 
*/
protected int get_AccessLevel()
{
return accessLevel.intValue();
}
/** Load Meta Data
@param ctx context
@return PO Info
*/
protected POInfo initPO (Ctx ctx)
{
POInfo poi = POInfo.getPOInfo (ctx, Table_ID);
return poi;
}
/** Info
@return info
*/
public String toString()
{
StringBuffer sb = new StringBuffer ("X_AD_Client[").append(get_ID()).append("]");
return sb.toString();
}

/** AD_Language AD_Reference_ID=327 */
public static final int AD_LANGUAGE_AD_Reference_ID=327;
/** Set Language.
@param AD_Language Language for this entity */
public void setAD_Language (String AD_Language)
{
if (AD_Language != null && AD_Language.length() > 5)
{
log.warning("Length > 5 - truncated");
AD_Language = AD_Language.substring(0,5);
}
set_Value ("AD_Language", AD_Language);
}
/** Get Language.
@return Language for this entity */
public String getAD_Language() 
{
return (String)get_Value("AD_Language");
}

/** AutoArchive AD_Reference_ID=334 */
public static final int AUTOARCHIVE_AD_Reference_ID=334;
/** All (Reports, Documents) = 1 */
public static final String AUTOARCHIVE_AllReportsDocuments = "1";
/** Documents = 2 */
public static final String AUTOARCHIVE_Documents = "2";
/** External Documents = 3 */
public static final String AUTOARCHIVE_ExternalDocuments = "3";
/** None = N */
public static final String AUTOARCHIVE_None = "N";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isAutoArchiveValid (String test)
{
return test.equals("1") || test.equals("2") || test.equals("3") || test.equals("N");
}
/** Set Auto Archive.
@param AutoArchive Enable and level of automatic Archive of documents */
public void setAutoArchive (String AutoArchive)
{
if (AutoArchive == null) throw new IllegalArgumentException ("AutoArchive is mandatory");
if (!isAutoArchiveValid(AutoArchive))
throw new IllegalArgumentException ("AutoArchive Invalid value - " + AutoArchive + " - Reference_ID=334 - 1 - 2 - 3 - N");
if (AutoArchive.length() > 1)
{
log.warning("Length > 1 - truncated");
AutoArchive = AutoArchive.substring(0,1);
}
set_Value ("AutoArchive", AutoArchive);
}
/** Get Auto Archive.
@return Enable and level of automatic Archive of documents */
public String getAutoArchive() 
{
return (String)get_Value("AutoArchive");
}
/** Set Description.
@param Description Optional short description of the record */
public void setDescription (String Description)
{
if (Description != null && Description.length() > 255)
{
log.warning("Length > 255 - truncated");
Description = Description.substring(0,255);
}
set_Value ("Description", Description);
}
/** Get Description.
@return Optional short description of the record */
public String getDescription() 
{
return (String)get_Value("Description");
}
/** Set Document Directory.
@param DocumentDir Directory for documents from the application server */
public void setDocumentDir (String DocumentDir)
{
if (DocumentDir != null && DocumentDir.length() > 60)
{
log.warning("Length > 60 - truncated");
DocumentDir = DocumentDir.substring(0,60);
}
set_Value ("DocumentDir", DocumentDir);
}
/** Get Document Directory.
@return Directory for documents from the application server */
public String getDocumentDir() 
{
return (String)get_Value("DocumentDir");
}
/** Set EMail Test.
@param EMailTest Test EMail */
public void setEMailTest (String EMailTest)
{
if (EMailTest != null && EMailTest.length() > 1)
{
log.warning("Length > 1 - truncated");
EMailTest = EMailTest.substring(0,1);
}
set_Value ("EMailTest", EMailTest);
}
/** Get EMail Test.
@return Test EMail */
public String getEMailTest() 
{
return (String)get_Value("EMailTest");
}
/** Set Cost Immediately.
@param IsCostImmediate Update Costs immediately for testing */
public void setIsCostImmediate (boolean IsCostImmediate)
{
set_Value ("IsCostImmediate", new Boolean(IsCostImmediate));
}
/** Get Cost Immediately.
@return Update Costs immediately for testing */
public boolean isCostImmediate() 
{
Object oo = get_Value("IsCostImmediate");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Multi Lingual Documents.
@param IsMultiLingualDocument Documents are Multi Lingual */
public void setIsMultiLingualDocument (boolean IsMultiLingualDocument)
{
set_Value ("IsMultiLingualDocument", new Boolean(IsMultiLingualDocument));
}
/** Get Multi Lingual Documents.
@return Documents are Multi Lingual */
public boolean isMultiLingualDocument() 
{
Object oo = get_Value("IsMultiLingualDocument");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Post Immediately.
@param IsPostImmediate Post the accounting immediately for testing */
public void setIsPostImmediate (boolean IsPostImmediate)
{
set_Value ("IsPostImmediate", new Boolean(IsPostImmediate));
}
/** Get Post Immediately.
@return Post the accounting immediately for testing */
public boolean isPostImmediate() 
{
Object oo = get_Value("IsPostImmediate");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Server EMail.
@param IsServerEMail Send EMail from Server */
public void setIsServerEMail (boolean IsServerEMail)
{
set_Value ("IsServerEMail", new Boolean(IsServerEMail));
}
/** Get Server EMail.
@return Send EMail from Server */
public boolean isServerEMail() 
{
Object oo = get_Value("IsServerEMail");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set SMTP Authentication.
@param IsSmtpAuthorization Your mail server requires Authentication */
public void setIsSmtpAuthorization (boolean IsSmtpAuthorization)
{
set_Value ("IsSmtpAuthorization", new Boolean(IsSmtpAuthorization));
}
/** Get SMTP Authentication.
@return Your mail server requires Authentication */
public boolean isSmtpAuthorization() 
{
Object oo = get_Value("IsSmtpAuthorization");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set SMTP TLS.
@param IsSmtpTLS Use TLS for SMTP communication */
public void setIsSmtpTLS (boolean IsSmtpTLS)
{
set_Value ("IsSmtpTLS", new Boolean(IsSmtpTLS));
}
/** Get SMTP TLS.
@return Use TLS for SMTP communication */
public boolean isSmtpTLS() 
{
Object oo = get_Value("IsSmtpTLS");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Use Beta Functions.
@param IsUseBetaFunctions Enable the use of Beta Functionality */
public void setIsUseBetaFunctions (boolean IsUseBetaFunctions)
{
set_Value ("IsUseBetaFunctions", new Boolean(IsUseBetaFunctions));
}
/** Get Use Beta Functions.
@return Enable the use of Beta Functionality */
public boolean isUseBetaFunctions() 
{
Object oo = get_Value("IsUseBetaFunctions");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set LDAP Query.
@param LDAPQuery Query to authenticate users for that client with LDAP */
public void setLDAPQuery (String LDAPQuery)
{
if (LDAPQuery != null && LDAPQuery.length() > 255)
{
log.warning("Length > 255 - truncated");
LDAPQuery = LDAPQuery.substring(0,255);
}
set_Value ("LDAPQuery", LDAPQuery);
}
/** Get LDAP Query.
@return Query to authenticate users for that client with LDAP */
public String getLDAPQuery() 
{
return (String)get_Value("LDAPQuery");
}

/** MMPolicy AD_Reference_ID=335 */
public static final int MMPOLICY_AD_Reference_ID=335;
/** FiFo = F */
public static final String MMPOLICY_FiFo = "F";
/** LiFo = L */
public static final String MMPOLICY_LiFo = "L";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isMMPolicyValid (String test)
{
return test.equals("F") || test.equals("L");
}
/** Set Material Policy.
@param MMPolicy Material Movement Policy */
public void setMMPolicy (String MMPolicy)
{
if (MMPolicy == null) throw new IllegalArgumentException ("MMPolicy is mandatory");
if (!isMMPolicyValid(MMPolicy))
throw new IllegalArgumentException ("MMPolicy Invalid value - " + MMPolicy + " - Reference_ID=335 - F - L");
if (MMPolicy.length() > 1)
{
log.warning("Length > 1 - truncated");
MMPolicy = MMPolicy.substring(0,1);
}
set_Value ("MMPolicy", MMPolicy);
}
/** Get Material Policy.
@return Material Movement Policy */
public String getMMPolicy() 
{
return (String)get_Value("MMPolicy");
}
/** Set Model Validation Classes.
@param ModelValidationClasses List of data model validation classes separated by ;
 */
public void setModelValidationClasses (String ModelValidationClasses)
{
if (ModelValidationClasses != null && ModelValidationClasses.length() > 255)
{
log.warning("Length > 255 - truncated");
ModelValidationClasses = ModelValidationClasses.substring(0,255);
}
set_Value ("ModelValidationClasses", ModelValidationClasses);
}
/** Get Model Validation Classes.
@return List of data model validation classes separated by ;
 */
public String getModelValidationClasses() 
{
return (String)get_Value("ModelValidationClasses");
}
/** Set Name.
@param Name Alphanumeric identifier of the entity */
public void setName (String Name)
{
if (Name == null) throw new IllegalArgumentException ("Name is mandatory.");
if (Name.length() > 60)
{
log.warning("Length > 60 - truncated");
Name = Name.substring(0,60);
}
set_Value ("Name", Name);
}
/** Get Name.
@return Alphanumeric identifier of the entity */
public String getName() 
{
return (String)get_Value("Name");
}
/** Get Record ID/ColumnName
@return ID/ColumnName pair */
public KeyNamePair getKeyNamePair() 
{
return new KeyNamePair(get_ID(), getName());
}
/** Set Request EMail.
@param RequestEMail EMail address to send automated mails from or receive mails for automated processing (fully qualified) */
public void setRequestEMail (String RequestEMail)
{
if (RequestEMail != null && RequestEMail.length() > 60)
{
log.warning("Length > 60 - truncated");
RequestEMail = RequestEMail.substring(0,60);
}
set_Value ("RequestEMail", RequestEMail);
}
/** Get Request EMail.
@return EMail address to send automated mails from or receive mails for automated processing (fully qualified) */
public String getRequestEMail() 
{
return (String)get_Value("RequestEMail");
}
/** Set Request Folder.
@param RequestFolder EMail folder to process incoming emails;
 if empty INBOX is used */
public void setRequestFolder (String RequestFolder)
{
if (RequestFolder != null && RequestFolder.length() > 20)
{
log.warning("Length > 20 - truncated");
RequestFolder = RequestFolder.substring(0,20);
}
set_Value ("RequestFolder", RequestFolder);
}
/** Get Request Folder.
@return EMail folder to process incoming emails;
 if empty INBOX is used */
public String getRequestFolder() 
{
return (String)get_Value("RequestFolder");
}
/** Set Request User.
@param RequestUser User Name (ID) of the email owner */
public void setRequestUser (String RequestUser)
{
if (RequestUser != null && RequestUser.length() > 60)
{
log.warning("Length > 60 - truncated");
RequestUser = RequestUser.substring(0,60);
}
set_Value ("RequestUser", RequestUser);
}
/** Get Request User.
@return User Name (ID) of the email owner */
public String getRequestUser() 
{
return (String)get_Value("RequestUser");
}
/** Set Request User Password.
@param RequestUserPW Password of the user name (ID) for mail processing */
public void setRequestUserPW (String RequestUserPW)
{
if (RequestUserPW != null && RequestUserPW.length() > 20)
{
log.warning("Length > 20 - truncated");
RequestUserPW = RequestUserPW.substring(0,20);
}
set_Value ("RequestUserPW", RequestUserPW);
}
/** Get Request User Password.
@return Password of the user name (ID) for mail processing */
public String getRequestUserPW() 
{
return (String)get_Value("RequestUserPW");
}
/** Set Mail Host.
@param SmtpHost Hostname of Mail Server for SMTP and IMAP */
public void setSmtpHost (String SmtpHost)
{
if (SmtpHost != null && SmtpHost.length() > 60)
{
log.warning("Length > 60 - truncated");
SmtpHost = SmtpHost.substring(0,60);
}
set_Value ("SmtpHost", SmtpHost);
}
/** Get Mail Host.
@return Hostname of Mail Server for SMTP and IMAP */
public String getSmtpHost() 
{
return (String)get_Value("SmtpHost");
}
/** Set SMTP Port.
@param SmtpPort Mail service port */
public void setSmtpPort (int SmtpPort)
{
set_Value ("SmtpPort", new Integer(SmtpPort));
}
/** Get SMTP Port.
@return Mail service port */
public int getSmtpPort() 
{
Integer ii = (Integer)get_Value("SmtpPort");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Search Key.
@param Value Search key for the record in the format required - must be unique */
public void setValue (String Value)
{
if (Value == null) throw new IllegalArgumentException ("Value is mandatory.");
if (Value.length() > 40)
{
log.warning("Length > 40 - truncated");
Value = Value.substring(0,40);
}
set_Value ("Value", Value);
}
/** Get Search Key.
@return Search key for the record in the format required - must be unique */
public String getValue() 
{
return (String)get_Value("Value");
}
}
