/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

/** Generated Model - DO NOT CHANGE */
import java.sql.*;
import java.math.*;
import org.compiere.framework.*;
import org.compiere.util.*;
/** Generated Model for AD_Column
 *  @author Jorg Janke (generated) 
 *  @version Release 3.0.0 - $Id: X_AD_Column.java,v 1.1.4.1 2009/03/29 07:41:18 jrmt Exp $ */
public class X_AD_Column extends PO
{
/** Standard Constructor
@param ctx context
@param AD_Column_ID id
@param trxName transaction
*/
public X_AD_Column (Ctx ctx, int AD_Column_ID, String trxName)
{
super (ctx, AD_Column_ID, trxName);
/** if (AD_Column_ID == 0)
{
setAD_Column_ID (0);
setAD_Element_ID (0);
setAD_Reference_ID (0);
setAD_Table_ID (0);
setColumnName (null);
setEntityType (null);	// U
setIsAlwaysUpdateable (false);	// N
setIsEncrypted (null);	// N
setIsIdentifier (false);
setIsKey (false);
setIsMandatory (false);
setIsMandatoryUI (false);
setIsParent (false);
setIsSelectionColumn (false);
setIsTranslated (false);
setIsUpdateable (true);	// Y
setName (null);
setVersion (Env.ZERO);
}
 */
}
/** Load Constructor 
@param ctx context
@param rs result set 
@param trxName transaction
*/
public X_AD_Column (Ctx ctx, ResultSet rs, String trxName)
{
super (ctx, rs, trxName);
}
/** Serial Version No */
static final long serialVersionUID = 27476146275789L;
/** Last Updated Timestamp 2007-11-03 01:29:19.0 */
public static final long updatedMS = 1194020959000L;
/** AD_Table_ID=101 */
public static final int Table_ID=101;

/** TableName=AD_Column */
public static final String Table_Name="AD_Column";

protected static KeyNamePair Model = new KeyNamePair(101,"AD_Column");

protected BigDecimal accessLevel = new BigDecimal(4);
/** AccessLevel
@return 4 - System 
*/
protected int get_AccessLevel()
{
return accessLevel.intValue();
}
/** Load Meta Data
@param ctx context
@return PO Info
*/
protected POInfo initPO (Ctx ctx)
{
POInfo poi = POInfo.getPOInfo (ctx, Table_ID);
return poi;
}
/** Info
@return info
*/
public String toString()
{
StringBuffer sb = new StringBuffer ("X_AD_Column[").append(get_ID()).append("]");
return sb.toString();
}
/** Set Column.
@param AD_Column_ID Column in the table */
public void setAD_Column_ID (int AD_Column_ID)
{
if (AD_Column_ID < 1) throw new IllegalArgumentException ("AD_Column_ID is mandatory.");
set_ValueNoCheck ("AD_Column_ID", new Integer(AD_Column_ID));
}
/** Get Column.
@return Column in the table */
public int getAD_Column_ID() 
{
Integer ii = (Integer)get_Value("AD_Column_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set System Element.
@param AD_Element_ID System Element enables the central maintenance of column description and help. */
public void setAD_Element_ID (int AD_Element_ID)
{
if (AD_Element_ID < 1) throw new IllegalArgumentException ("AD_Element_ID is mandatory.");
set_Value ("AD_Element_ID", new Integer(AD_Element_ID));
}
/** Get System Element.
@return System Element enables the central maintenance of column description and help. */
public int getAD_Element_ID() 
{
Integer ii = (Integer)get_Value("AD_Element_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Process.
@param AD_Process_ID Process or Report */
public void setAD_Process_ID (int AD_Process_ID)
{
if (AD_Process_ID <= 0) set_Value ("AD_Process_ID", null);
else
set_Value ("AD_Process_ID", new Integer(AD_Process_ID));
}
/** Get Process.
@return Process or Report */
public int getAD_Process_ID() 
{
Integer ii = (Integer)get_Value("AD_Process_ID");
if (ii == null) return 0;
return ii.intValue();
}

/** AD_Reference_ID AD_Reference_ID=1 */
public static final int AD_REFERENCE_ID_AD_Reference_ID=1;
/** Set Reference.
@param AD_Reference_ID System Reference and Validation */
public void setAD_Reference_ID (int AD_Reference_ID)
{
if (AD_Reference_ID < 1) throw new IllegalArgumentException ("AD_Reference_ID is mandatory.");
set_Value ("AD_Reference_ID", new Integer(AD_Reference_ID));
}
/** Get Reference.
@return System Reference and Validation */
public int getAD_Reference_ID() 
{
Integer ii = (Integer)get_Value("AD_Reference_ID");
if (ii == null) return 0;
return ii.intValue();
}

/** AD_Reference_Value_ID AD_Reference_ID=4 */
public static final int AD_REFERENCE_VALUE_ID_AD_Reference_ID=4;
/** Set Reference Key.
@param AD_Reference_Value_ID Required to specify, if data type is Table or List */
public void setAD_Reference_Value_ID (int AD_Reference_Value_ID)
{
if (AD_Reference_Value_ID <= 0) set_Value ("AD_Reference_Value_ID", null);
else
set_Value ("AD_Reference_Value_ID", new Integer(AD_Reference_Value_ID));
}
/** Get Reference Key.
@return Required to specify, if data type is Table or List */
public int getAD_Reference_Value_ID() 
{
Integer ii = (Integer)get_Value("AD_Reference_Value_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Table.
@param AD_Table_ID Database Table information */
public void setAD_Table_ID (int AD_Table_ID)
{
if (AD_Table_ID < 1) throw new IllegalArgumentException ("AD_Table_ID is mandatory.");
set_ValueNoCheck ("AD_Table_ID", new Integer(AD_Table_ID));
}
/** Get Table.
@return Database Table information */
public int getAD_Table_ID() 
{
Integer ii = (Integer)get_Value("AD_Table_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Dynamic Validation.
@param AD_Val_Rule_ID Dynamic Validation Rule */
public void setAD_Val_Rule_ID (int AD_Val_Rule_ID)
{
if (AD_Val_Rule_ID <= 0) set_Value ("AD_Val_Rule_ID", null);
else
set_Value ("AD_Val_Rule_ID", new Integer(AD_Val_Rule_ID));
}
/** Get Dynamic Validation.
@return Dynamic Validation Rule */
public int getAD_Val_Rule_ID() 
{
Integer ii = (Integer)get_Value("AD_Val_Rule_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Callout Code.
@param Callout External Callout Code - Fully qualified class names and method - separated by semicolons */
public void setCallout (String Callout)
{
if (Callout != null && Callout.length() > 255)
{
log.warning("Length > 255 - truncated");
Callout = Callout.substring(0,255);
}
set_Value ("Callout", Callout);
}
/** Get Callout Code.
@return External Callout Code - Fully qualified class names and method - separated by semicolons */
public String getCallout() 
{
return (String)get_Value("Callout");
}
/** Set DB Column Name.
@param ColumnName Name of the column in the database */
public void setColumnName (String ColumnName)
{
if (ColumnName == null) throw new IllegalArgumentException ("ColumnName is mandatory.");
if (ColumnName.length() > 40)
{
log.warning("Length > 40 - truncated");
ColumnName = ColumnName.substring(0,40);
}
set_Value ("ColumnName", ColumnName);
}
/** Get DB Column Name.
@return Name of the column in the database */
public String getColumnName() 
{
return (String)get_Value("ColumnName");
}
/** Get Record ID/ColumnName
@return ID/ColumnName pair */
public KeyNamePair getKeyNamePair() 
{
return new KeyNamePair(get_ID(), getColumnName());
}
/** Set Column SQL.
@param ColumnSQL Virtual Column (r/o) */
public void setColumnSQL (String ColumnSQL)
{
if (ColumnSQL != null && ColumnSQL.length() > 2000)
{
log.warning("Length > 2000 - truncated");
ColumnSQL = ColumnSQL.substring(0,2000);
}
set_Value ("ColumnSQL", ColumnSQL);
}
/** Get Column SQL.
@return Virtual Column (r/o) */
public String getColumnSQL() 
{
return (String)get_Value("ColumnSQL");
}
/** Set Constraint Name.
@param ConstraintName Constraint Name */
public void setConstraintName (String ConstraintName)
{
throw new IllegalArgumentException ("ConstraintName is virtual column");
}
/** Get Constraint Name.
@return Constraint Name */
public String getConstraintName() 
{
return (String)get_Value("ConstraintName");
}

/** ConstraintType AD_Reference_ID=411 */
public static final int CONSTRAINTTYPE_AD_Reference_ID=411;
/** Cascade = C */
public static final String CONSTRAINTTYPE_Cascade = "C";
/** Null = N */
public static final String CONSTRAINTTYPE_Null = "N";
/** Restrict = R */
public static final String CONSTRAINTTYPE_Restrict = "R";
/** Do NOT Create = X */
public static final String CONSTRAINTTYPE_DoNOTCreate = "X";
/** Cascade Trigger = c */
public static final String CONSTRAINTTYPE_CascadeTrigger = "c";
/** Null Trigger = n */
public static final String CONSTRAINTTYPE_NullTrigger = "n";
/** Ristrict Trigger = r */
public static final String CONSTRAINTTYPE_RistrictTrigger = "r";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isConstraintTypeValid (String test)
{
return test == null || test.equals("C") || test.equals("N") || test.equals("R") || test.equals("X") || test.equals("c") || test.equals("n") || test.equals("r");
}
/** Set Constraint Type.
@param ConstraintType Constraint Type */
public void setConstraintType (String ConstraintType)
{
if (!isConstraintTypeValid(ConstraintType))
throw new IllegalArgumentException ("ConstraintType Invalid value - " + ConstraintType + " - Reference_ID=411 - C - N - R - X - c - n - r");
if (ConstraintType != null && ConstraintType.length() > 1)
{
log.warning("Length > 1 - truncated");
ConstraintType = ConstraintType.substring(0,1);
}
set_Value ("ConstraintType", ConstraintType);
}
/** Get Constraint Type.
@return Constraint Type */
public String getConstraintType() 
{
return (String)get_Value("ConstraintType");
}
/** Set Default Logic.
@param DefaultValue Default value hierarchy, separated by ;
 */
public void setDefaultValue (String DefaultValue)
{
if (DefaultValue != null && DefaultValue.length() > 2000)
{
log.warning("Length > 2000 - truncated");
DefaultValue = DefaultValue.substring(0,2000);
}
set_Value ("DefaultValue", DefaultValue);
}
/** Get Default Logic.
@return Default value hierarchy, separated by ;
 */
public String getDefaultValue() 
{
return (String)get_Value("DefaultValue");
}
/** Set Description.
@param Description Optional short description of the record */
public void setDescription (String Description)
{
if (Description != null && Description.length() > 255)
{
log.warning("Length > 255 - truncated");
Description = Description.substring(0,255);
}
set_Value ("Description", Description);
}
/** Get Description.
@return Optional short description of the record */
public String getDescription() 
{
return (String)get_Value("Description");
}

/** EntityType AD_Reference_ID=389 */
public static final int ENTITYTYPE_AD_Reference_ID=389;
/** Set Entity Type.
@param EntityType Dictionary Entity Type;
 Determines ownership and synchronization */
public void setEntityType (String EntityType)
{
if (EntityType.length() > 4)
{
log.warning("Length > 4 - truncated");
EntityType = EntityType.substring(0,4);
}
set_Value ("EntityType", EntityType);
}
/** Get Entity Type.
@return Dictionary Entity Type;
 Determines ownership and synchronization */
public String getEntityType() 
{
return (String)get_Value("EntityType");
}
/** Set Length.
@param FieldLength Length of the column in the database */
public void setFieldLength (int FieldLength)
{
set_Value ("FieldLength", new Integer(FieldLength));
}
/** Get Length.
@return Length of the column in the database */
public int getFieldLength() 
{
Integer ii = (Integer)get_Value("FieldLength");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Comment.
@param Help Comment, Help or Hint */
public void setHelp (String Help)
{
if (Help != null && Help.length() > 2000)
{
log.warning("Length > 2000 - truncated");
Help = Help.substring(0,2000);
}
set_Value ("Help", Help);
}
/** Get Comment.
@return Comment, Help or Hint */
public String getHelp() 
{
return (String)get_Value("Help");
}
/** Set Always Updatable.
@param IsAlwaysUpdateable The column is always updatable, even if the record is not active or processed */
public void setIsAlwaysUpdateable (boolean IsAlwaysUpdateable)
{
set_Value ("IsAlwaysUpdateable", new Boolean(IsAlwaysUpdateable));
}
/** Get Always Updatable.
@return The column is always updatable, even if the record is not active or processed */
public boolean isAlwaysUpdateable() 
{
Object oo = get_Value("IsAlwaysUpdateable");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Callout.
@param IsCallout This column has implemented a Callout */
public void setIsCallout (boolean IsCallout)
{
set_Value ("IsCallout", new Boolean(IsCallout));
}
/** Get Callout.
@return This column has implemented a Callout */
public boolean isCallout() 
{
Object oo = get_Value("IsCallout");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}

/** IsEncrypted AD_Reference_ID=354 */
public static final int ISENCRYPTED_AD_Reference_ID=354;
/** Not Encrypted = N */
public static final String ISENCRYPTED_NotEncrypted = "N";
/** Encrypted = Y */
public static final String ISENCRYPTED_Encrypted = "Y";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isIsEncryptedValid (String test)
{
return test.equals("N") || test.equals("Y");
}
/** Set Encrypted.
@param IsEncrypted Display or Storage is encrypted */
public void setIsEncrypted (String IsEncrypted)
{
if (IsEncrypted == null) throw new IllegalArgumentException ("IsEncrypted is mandatory");
if (!isIsEncryptedValid(IsEncrypted))
throw new IllegalArgumentException ("IsEncrypted Invalid value - " + IsEncrypted + " - Reference_ID=354 - N - Y");
if (IsEncrypted.length() > 1)
{
log.warning("Length > 1 - truncated");
IsEncrypted = IsEncrypted.substring(0,1);
}
set_Value ("IsEncrypted", IsEncrypted);
}
/** Get Encrypted.
@return Display or Storage is encrypted */
public String getIsEncrypted() 
{
return (String)get_Value("IsEncrypted");
}
/** Set Identifier.
@param IsIdentifier This column is part of the record identifier */
public void setIsIdentifier (boolean IsIdentifier)
{
set_Value ("IsIdentifier", new Boolean(IsIdentifier));
}
/** Get Identifier.
@return This column is part of the record identifier */
public boolean isIdentifier() 
{
Object oo = get_Value("IsIdentifier");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Key column.
@param IsKey This column is the key in this table */
public void setIsKey (boolean IsKey)
{
set_Value ("IsKey", new Boolean(IsKey));
}
/** Get Key column.
@return This column is the key in this table */
public boolean isKey() 
{
Object oo = get_Value("IsKey");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Mandatory.
@param IsMandatory Data is required in this column */
public void setIsMandatory (boolean IsMandatory)
{
set_Value ("IsMandatory", new Boolean(IsMandatory));
}
/** Get Mandatory.
@return Data is required in this column */
public boolean isMandatory() 
{
Object oo = get_Value("IsMandatory");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Mandatory UI.
@param IsMandatoryUI Data entry is required for data entry in the field */
public void setIsMandatoryUI (boolean IsMandatoryUI)
{
set_Value ("IsMandatoryUI", new Boolean(IsMandatoryUI));
}
/** Get Mandatory UI.
@return Data entry is required for data entry in the field */
public boolean isMandatoryUI() 
{
Object oo = get_Value("IsMandatoryUI");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Parent link column.
@param IsParent This column is a link to the parent table (e.g. header from lines) - incl. Association key columns */
public void setIsParent (boolean IsParent)
{
set_Value ("IsParent", new Boolean(IsParent));
}
/** Get Parent link column.
@return This column is a link to the parent table (e.g. header from lines) - incl. Association key columns */
public boolean isParent() 
{
Object oo = get_Value("IsParent");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Recursive FK.
@param IsRecursiveFK Recursive Foreign key */
public void setIsRecursiveFK (boolean IsRecursiveFK)
{
set_Value ("IsRecursiveFK", new Boolean(IsRecursiveFK));
}
/** Get Recursive FK.
@return Recursive Foreign key */
public boolean isRecursiveFK() 
{
Object oo = get_Value("IsRecursiveFK");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Selection Column.
@param IsSelectionColumn Is this column used for finding rows in windows */
public void setIsSelectionColumn (boolean IsSelectionColumn)
{
set_Value ("IsSelectionColumn", new Boolean(IsSelectionColumn));
}
/** Get Selection Column.
@return Is this column used for finding rows in windows */
public boolean isSelectionColumn() 
{
Object oo = get_Value("IsSelectionColumn");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Summary Column.
@param IsSummaryColumn Summary Info Column */
public void setIsSummaryColumn (boolean IsSummaryColumn)
{
set_Value ("IsSummaryColumn", new Boolean(IsSummaryColumn));
}
/** Get Summary Column.
@return Summary Info Column */
public boolean isSummaryColumn() 
{
Object oo = get_Value("IsSummaryColumn");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Synchronize Database.
@param IsSyncDatabase Change database table definition when changing dictionary definition */
public void setIsSyncDatabase (String IsSyncDatabase)
{
if (IsSyncDatabase != null && IsSyncDatabase.length() > 1)
{
log.warning("Length > 1 - truncated");
IsSyncDatabase = IsSyncDatabase.substring(0,1);
}
set_Value ("IsSyncDatabase", IsSyncDatabase);
}
/** Get Synchronize Database.
@return Change database table definition when changing dictionary definition */
public String getIsSyncDatabase() 
{
return (String)get_Value("IsSyncDatabase");
}
/** Set Translated.
@param IsTranslated This column is translated */
public void setIsTranslated (boolean IsTranslated)
{
set_Value ("IsTranslated", new Boolean(IsTranslated));
}
/** Get Translated.
@return This column is translated */
public boolean isTranslated() 
{
Object oo = get_Value("IsTranslated");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Updateable.
@param IsUpdateable Determines, if the field can be updated */
public void setIsUpdateable (boolean IsUpdateable)
{
set_Value ("IsUpdateable", new Boolean(IsUpdateable));
}
/** Get Updateable.
@return Determines, if the field can be updated */
public boolean isUpdateable() 
{
Object oo = get_Value("IsUpdateable");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Mandatory Logic.
@param MandatoryLogic Logic detremining when a field is required to be entered */
public void setMandatoryLogic (String MandatoryLogic)
{
if (MandatoryLogic != null && MandatoryLogic.length() > 2000)
{
log.warning("Length > 2000 - truncated");
MandatoryLogic = MandatoryLogic.substring(0,2000);
}
set_Value ("MandatoryLogic", MandatoryLogic);
}
/** Get Mandatory Logic.
@return Logic detremining when a field is required to be entered */
public String getMandatoryLogic() 
{
return (String)get_Value("MandatoryLogic");
}
/** Set Name.
@param Name Alphanumeric identifier of the entity */
public void setName (String Name)
{
if (Name == null) throw new IllegalArgumentException ("Name is mandatory.");
if (Name.length() > 60)
{
log.warning("Length > 60 - truncated");
Name = Name.substring(0,60);
}
set_Value ("Name", Name);
}
/** Get Name.
@return Alphanumeric identifier of the entity */
public String getName() 
{
return (String)get_Value("Name");
}
/** Set Read Only Logic.
@param ReadOnlyLogic Logic to determine if field is read only (applies only when field is read-write) */
public void setReadOnlyLogic (String ReadOnlyLogic)
{
if (ReadOnlyLogic != null && ReadOnlyLogic.length() > 2000)
{
log.warning("Length > 2000 - truncated");
ReadOnlyLogic = ReadOnlyLogic.substring(0,2000);
}
set_Value ("ReadOnlyLogic", ReadOnlyLogic);
}
/** Get Read Only Logic.
@return Logic to determine if field is read only (applies only when field is read-write) */
public String getReadOnlyLogic() 
{
return (String)get_Value("ReadOnlyLogic");
}
/** Set Selection Sequence.
@param SelectionSeqNo Sequence in Selection */
public void setSelectionSeqNo (int SelectionSeqNo)
{
set_Value ("SelectionSeqNo", new Integer(SelectionSeqNo));
}
/** Get Selection Sequence.
@return Sequence in Selection */
public int getSelectionSeqNo() 
{
Integer ii = (Integer)get_Value("SelectionSeqNo");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Sequence.
@param SeqNo Method of ordering elements;
 lowest number comes first */
public void setSeqNo (int SeqNo)
{
set_Value ("SeqNo", new Integer(SeqNo));
}
/** Get Sequence.
@return Method of ordering elements;
 lowest number comes first */
public int getSeqNo() 
{
Integer ii = (Integer)get_Value("SeqNo");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Summary Sequence.
@param SummarySeqNo Sequence in Summary */
public void setSummarySeqNo (int SummarySeqNo)
{
set_Value ("SummarySeqNo", new Integer(SummarySeqNo));
}
/** Get Summary Sequence.
@return Sequence in Summary */
public int getSummarySeqNo() 
{
Integer ii = (Integer)get_Value("SummarySeqNo");
if (ii == null) return 0;
return ii.intValue();
}
/** Set TableUID.
@param TableUID TableUID */
public void setTableUID (int TableUID)
{
set_Value ("TableUID", new Integer(TableUID));
}
/** Get TableUID.
@return TableUID */
public int getTableUID() 
{
Integer ii = (Integer)get_Value("TableUID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Value Format.
@param VFormat Format of the value;
 Can contain fixed format elements, Variables: "_lLoOaAcCa09" */
public void setVFormat (String VFormat)
{
if (VFormat != null && VFormat.length() > 60)
{
log.warning("Length > 60 - truncated");
VFormat = VFormat.substring(0,60);
}
set_Value ("VFormat", VFormat);
}
/** Get Value Format.
@return Format of the value;
 Can contain fixed format elements, Variables: "_lLoOaAcCa09" */
public String getVFormat() 
{
return (String)get_Value("VFormat");
}
/** Set Max. Value.
@param ValueMax Maximum Value for a field */
public void setValueMax (String ValueMax)
{
if (ValueMax != null && ValueMax.length() > 20)
{
log.warning("Length > 20 - truncated");
ValueMax = ValueMax.substring(0,20);
}
set_Value ("ValueMax", ValueMax);
}
/** Get Max. Value.
@return Maximum Value for a field */
public String getValueMax() 
{
return (String)get_Value("ValueMax");
}
/** Set Min. Value.
@param ValueMin Minimum Value for a field */
public void setValueMin (String ValueMin)
{
if (ValueMin != null && ValueMin.length() > 20)
{
log.warning("Length > 20 - truncated");
ValueMin = ValueMin.substring(0,20);
}
set_Value ("ValueMin", ValueMin);
}
/** Get Min. Value.
@return Minimum Value for a field */
public String getValueMin() 
{
return (String)get_Value("ValueMin");
}
/** Set Version.
@param Version Version of the table definition */
public void setVersion (BigDecimal Version)
{
if (Version == null) throw new IllegalArgumentException ("Version is mandatory.");
set_Value ("Version", Version);
}
/** Get Version.
@return Version of the table definition */
public BigDecimal getVersion() 
{
BigDecimal bd = (BigDecimal)get_Value("Version");
if (bd == null) return Env.ZERO;
return bd;
}
}
