/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

/** Generated Model - DO NOT CHANGE */
import java.sql.*;
import java.math.*;
import org.compiere.framework.*;
import org.compiere.util.*;
/** Generated Model for AD_Tree
 *  @author Jorg Janke (generated) 
 *  @version Release 3.0.0 - $Id: X_AD_Tree.java,v 1.1.4.1 2009/03/29 07:41:07 jrmt Exp $ */
public class X_AD_Tree extends PO
{
/** Standard Constructor
@param ctx context
@param AD_Tree_ID id
@param trxName transaction
*/
public X_AD_Tree (Ctx ctx, int AD_Tree_ID, String trxName)
{
super (ctx, AD_Tree_ID, trxName);
/** if (AD_Tree_ID == 0)
{
setAD_Table_ID (0);
setAD_Tree_ID (0);
setIsAllNodes (false);
setIsDefault (false);	// N
setName (null);
setTreeType (null);
}
 */
}
/** Load Constructor 
@param ctx context
@param rs result set 
@param trxName transaction
*/
public X_AD_Tree (Ctx ctx, ResultSet rs, String trxName)
{
super (ctx, rs, trxName);
}
/** Serial Version No */
static final long serialVersionUID = 27449653650789L;
/** Last Updated Timestamp 2006-12-31 10:25:34.0 */
public static final long updatedMS = 1167528334000L;
/** AD_Table_ID=288 */
public static final int Table_ID=288;

/** TableName=AD_Tree */
public static final String Table_Name="AD_Tree";

protected static KeyNamePair Model = new KeyNamePair(288,"AD_Tree");

protected BigDecimal accessLevel = new BigDecimal(6);
/** AccessLevel
@return 6 - System - Client 
*/
protected int get_AccessLevel()
{
return accessLevel.intValue();
}
/** Load Meta Data
@param ctx context
@return PO Info
*/
protected POInfo initPO (Ctx ctx)
{
POInfo poi = POInfo.getPOInfo (ctx, Table_ID);
return poi;
}
/** Info
@return info
*/
public String toString()
{
StringBuffer sb = new StringBuffer ("X_AD_Tree[").append(get_ID()).append("]");
return sb.toString();
}
/** Set Table.
@param AD_Table_ID Database Table information */
public void setAD_Table_ID (int AD_Table_ID)
{
if (AD_Table_ID < 1) throw new IllegalArgumentException ("AD_Table_ID is mandatory.");
set_ValueNoCheck ("AD_Table_ID", new Integer(AD_Table_ID));
}
/** Get Table.
@return Database Table information */
public int getAD_Table_ID() 
{
Integer ii = (Integer)get_Value("AD_Table_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Tree.
@param AD_Tree_ID Identifies a Tree */
public void setAD_Tree_ID (int AD_Tree_ID)
{
if (AD_Tree_ID < 1) throw new IllegalArgumentException ("AD_Tree_ID is mandatory.");
set_ValueNoCheck ("AD_Tree_ID", new Integer(AD_Tree_ID));
}
/** Get Tree.
@return Identifies a Tree */
public int getAD_Tree_ID() 
{
Integer ii = (Integer)get_Value("AD_Tree_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Description.
@param Description Optional short description of the record */
public void setDescription (String Description)
{
if (Description != null && Description.length() > 255)
{
log.warning("Length > 255 - truncated");
Description = Description.substring(0,255);
}
set_Value ("Description", Description);
}
/** Get Description.
@return Optional short description of the record */
public String getDescription() 
{
return (String)get_Value("Description");
}
/** Set All Nodes.
@param IsAllNodes All Nodes are included (Complete Tree) */
public void setIsAllNodes (boolean IsAllNodes)
{
set_Value ("IsAllNodes", new Boolean(IsAllNodes));
}
/** Get All Nodes.
@return All Nodes are included (Complete Tree) */
public boolean isAllNodes() 
{
Object oo = get_Value("IsAllNodes");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Default.
@param IsDefault Default value */
public void setIsDefault (boolean IsDefault)
{
set_Value ("IsDefault", new Boolean(IsDefault));
}
/** Get Default.
@return Default value */
public boolean isDefault() 
{
Object oo = get_Value("IsDefault");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Name.
@param Name Alphanumeric identifier of the entity */
public void setName (String Name)
{
if (Name == null) throw new IllegalArgumentException ("Name is mandatory.");
if (Name.length() > 60)
{
log.warning("Length > 60 - truncated");
Name = Name.substring(0,60);
}
set_Value ("Name", Name);
}
/** Get Name.
@return Alphanumeric identifier of the entity */
public String getName() 
{
return (String)get_Value("Name");
}
/** Get Record ID/ColumnName
@return ID/ColumnName pair */
public KeyNamePair getKeyNamePair() 
{
return new KeyNamePair(get_ID(), getName());
}
/** Set Process Now.
@param Processing Process Now */
public void setProcessing (boolean Processing)
{
set_Value ("Processing", new Boolean(Processing));
}
/** Get Process Now.
@return Process Now */
public boolean isProcessing() 
{
Object oo = get_Value("Processing");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}

/** TreeType AD_Reference_ID=120 */
public static final int TREETYPE_AD_Reference_ID=120;
/** Activity = AY */
public static final String TREETYPE_Activity = "AY";
/** BoM = BB */
public static final String TREETYPE_BoM = "BB";
/** BPartner = BP */
public static final String TREETYPE_BPartner = "BP";
/** CM Container = CC */
public static final String TREETYPE_CMContainer = "CC";
/** CM Media = CM */
public static final String TREETYPE_CMMedia = "CM";
/** CM Container Stage = CS */
public static final String TREETYPE_CMContainerStage = "CS";
/** CM Template = CT */
public static final String TREETYPE_CMTemplate = "CT";
/** Element Value = EV */
public static final String TREETYPE_ElementValue = "EV";
/** Campaign = MC */
public static final String TREETYPE_Campaign = "MC";
/** Menu = MM */
public static final String TREETYPE_Menu = "MM";
/** Organization = OO */
public static final String TREETYPE_Organization = "OO";
/** Product Category = PC */
public static final String TREETYPE_ProductCategory = "PC";
/** Project = PJ */
public static final String TREETYPE_Project = "PJ";
/** Product = PR */
public static final String TREETYPE_Product = "PR";
/** Sales Region = SR */
public static final String TREETYPE_SalesRegion = "SR";
/** User 1 = U1 */
public static final String TREETYPE_User1 = "U1";
/** User 2 = U2 */
public static final String TREETYPE_User2 = "U2";
/** User 3 = U3 */
public static final String TREETYPE_User3 = "U3";
/** User 4 = U4 */
public static final String TREETYPE_User4 = "U4";
/** Other = XX */
public static final String TREETYPE_Other = "XX";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isTreeTypeValid (String test)
{
return test.equals("AY") || test.equals("BB") || test.equals("BP") || test.equals("CC") || test.equals("CM") || test.equals("CS") || test.equals("CT") || test.equals("EV") || test.equals("MC") || test.equals("MM") || test.equals("OO") || test.equals("PC") || test.equals("PJ") || test.equals("PR") || test.equals("SR") || test.equals("U1") || test.equals("U2") || test.equals("U3") || test.equals("U4") || test.equals("XX");
}
/** Set Type | Area.
@param TreeType Element this tree is built on (i.e Product, Business Partner) */
public void setTreeType (String TreeType)
{
if (TreeType == null) throw new IllegalArgumentException ("TreeType is mandatory");
if (!isTreeTypeValid(TreeType))
throw new IllegalArgumentException ("TreeType Invalid value - " + TreeType + " - Reference_ID=120 - AY - BB - BP - CC - CM - CS - CT - EV - MC - MM - OO - PC - PJ - PR - SR - U1 - U2 - U3 - U4 - XX");
if (TreeType.length() > 2)
{
log.warning("Length > 2 - truncated");
TreeType = TreeType.substring(0,2);
}
set_ValueNoCheck ("TreeType", TreeType);
}
/** Get Type | Area.
@return Element this tree is built on (i.e Product, Business Partner) */
public String getTreeType() 
{
return (String)get_Value("TreeType");
}
}
