/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.process;

import org.compiere.model.*;
import org.compiere.util.*;

/**
 * 	Create Request from Lead
 *	
 *  @author Jorg Janke
 *  @version $Id: LeadRequest.java,v 1.1 2008/07/29 16:01:04 jrmt Exp $
 */
public class LeadRequest extends SvrProcess
{
	/** Request Type		*/
	private int p_R_RequestType_ID = 0;
	/** Lead				*/
	private int p_C_Lead_ID = 0;

	/**
	 * 	Prepare
	 */
	protected void prepare()
	{
		p_C_Lead_ID = getRecord_ID();
	}	//	prepare

	/**
	 * 	Process
	 *	@return summary
	 *	@throws Exception
	 */
	protected String doIt()
	    throws Exception
	{
		log.info("C_Lead_ID=" + p_C_Lead_ID);
		if (p_C_Lead_ID == 0)
			throw new CompiereUserException("@C_Lead_ID@ ID=0");
		MLead lead = new MLead (getCtx(), p_C_Lead_ID, get_TrxName());
		if (lead.get_ID() != p_C_Lead_ID)
			throw new CompiereUserException("@NotFound@: @C_Lead_ID@ ID=" + p_C_Lead_ID);
		//
		String retValue = lead.createRequest();
		if (retValue != null)
			throw new CompiereSystemException(retValue);
		lead.save();
		MRequest request = lead.getRequest();
		//
		return "@R_Request_ID@ " + request.getDocumentNo();
	}	//	doIt

}	//	LeadRequest
