/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.common;

import java.io.*;
import java.util.*;

import org.compiere.vos.*;

import com.google.gwt.user.client.rpc.*;

/** @author dzhao
 * A common interface for passing back error, warning and success messages from server side
 * AsyncCommand will first intercept the message and display warning/error messages in a modal dialog box
 */
public class Response implements Serializable
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	public static class Message implements Serializable
	{
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;
		private int				type;
		private String			message;
		/**
		 * Explicit commands for the client to execute
		 */

		public static final int	SUCCESS	= 0;
		public static final int	ERROR	= 1;
		public static final int	WARNING	= 2;

		public Message()
		{
		}

		public Message(int type, String message)
		{
			this.type = type;
			this.message = message;
		}

		public String getMessage()
		{
			return message;
		}

		public int getType()
		{
			return type;
		}

		public String toString()
		{
			if (type == Message.SUCCESS)
				return "Success: " + message;
			if (type == Message.ERROR)
				return "Error: " + message;
			if (type == Message.WARNING)
				return "Warning: " + message;
			return "NO MESSAGE";
		}
		
		public String toDisplay()
		{
			return message;
			/*if (type == Message.SUCCESS)
				return "<font color=\"black\">" + message+"</font>";
			if (type == Message.ERROR)
				return "<font color=\"red\">" + message+"</font>";
			if (type == Message.WARNING)
				return "<font color=\"yellow\">" + message+"</font>";
			return "NO MESSAGE";
			*/
		}

	}	//	Message

	/**
	 * usually there are only one message
	 * 
	 * @gwt.typeArgs <org.compiere.common.Response.Message>
	 */
	protected ArrayList	messages	= new ArrayList(1);
	protected boolean	hasError	= false;
	protected boolean	hasWarning	= false;
	/**
	 * usually there are only one message
	 * 
	 * @gwt.typeArgs <java.lang.String, java.lang.String>
	 */
	protected HashMap	params		= null;

	public String[]     commands = null;
	
	//if replaceWindowNO is not -1, we will attempt to replace window no identified with replaceWindowNO with the new windowVO supplied
	public int targetWinCmd = -1;
	//reload targetWin with new windowVO
	public static int RELOAD = 1;

	/**
	 * Populate this to completely replace the WindowVO of the currently open window
	 */
	public WindowVO     newWindowVO = null;

	protected void addParam(String var, String v)
	{
		if (params == null)
			params = new HashMap();
		params.put(var, v);
	}

	public String getParam(String var)
	{
		if (params == null)
			return null;
		return (String) params.get(var);
	}

	public int getProcessID()
	{
		if (getParam("START_PROCESS_ID") == null)
			return -1;
		return Integer.parseInt((String) getParam("START_PROCESS_ID"));
	}

	public void setProcessID(int processID)
	{
		addParam("START_PROCESS_ID", Integer.toString(processID));
	}

	/**
	 * 	Add Clear Text message
	 *	@param type constants like ERROR, WARNING, SUCCESS 
	 *	@param message clear text message
	 */
	private void addMessage(int type, String message)
	{
		if (type == Message.ERROR)
			hasError = true;
		if (type == Message.WARNING)
			hasWarning = true;
		messages.add(new Message(type, message));
	}	//	addMessage

	/**
	 * 	Add clear text error message
	 *	@param message clear text message
	 */
	public void addError(String message)
	{
		addMessage(Message.ERROR, message);
	}

	/**
	 * 	Add clear text warning message
	 *	@param message clear text message
	 */
	public void addWarning(String message)
	{
		addMessage(Message.WARNING, message);
	}

	/**
	 * 	Add clear text success message
	 *	@param message clear text message
	 */
	public void addSuccess(String message)
	{
		addMessage(Message.SUCCESS, message);
	}

	/**
	 * usually there are only one message
	 * @gwt.typeArgs <org.compiere.common.Response.Message>
	 */

	public ArrayList getMessages()
	{
		return messages;
	}

	public boolean hasError()
	{
		return hasError;
	}

	public boolean hasWarning()
	{
		return hasWarning;
	}

	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < messages.size(); i++)
		{
			Message m = (Message) messages.get(i);
			if (i > 0)
				sb.append(",");
			sb.append(m.toString());
		}
		return sb.toString();
	}
	
	public String toDisplay() {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < messages.size(); i++)
		{
			Message m = (Message) messages.get(i);
			if (i > 0)
				sb.append("<br>");
			sb.append(m.toDisplay());
		}
		return sb.toString();
	}

	public void setParams(HashMap params) {
		this.params = params;
	}
}	//	Response
