/**
 * 
 */
package org.compiere.vos;

import java.io.*;
import java.util.*;

/**
 * @author gwu
 *
 */
public class WindowCtx implements Serializable
{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * @gwt.typeArgs < java.lang.String, java.lang.String >
	 */
	private HashMap m_strMap;
	
	private HashMap m_objMap;
	
	
	public WindowCtx()
	{
		m_strMap = new HashMap();		
		m_objMap = new HashMap();
	}
	
	/**
	 * 
	 */
	public WindowCtx( HashMap strMap, HashMap objMap )
	{
		m_strMap = strMap;
		m_objMap = objMap;
	}
	
	
	public String getStringContext( String name )
	{
		return (String) m_strMap.get( name );
	}
	
	public Object getObjectContext( String name )
	{
		return m_objMap.get( name );
	}

	
	
	
	public String get( String name )
	{
		return getStringContext( name );
	}
	
	public int getAsInt( String name )
	{
		int value = 0;
		try
		{
			value = Integer.parseInt( get( name ) );
		}
		catch (Exception e) 
		{
		}
		return value;
	}

	public boolean getAsBoolean( String name )
	{
		return "Y".equals( get( name ) );
	}
	
	public void put( String name, String value )
	{
		m_strMap.put( name, value );
	}
	
	public void putObject( String name, Object value )
	{
		m_objMap.put( name, value );
	}

	public HashMap getStringMap()
	{
		return m_strMap;
	}

	
	
}
