package com.ampiere.dto;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * A generic item class, basically representing a name-value pair.
 *
 * @author Bato
 * @version $Revision: 1.1 $ $Date: 2008/09/30 12:26:39 $
 */
public class Item implements Serializable{

  private static final long serialVersionUID = 8707410779388385205L;

  private String name;
  private String value;
  private boolean asData;

  /**
   * Constructor for Item.
   */
  public Item() {
    super();
  }

  /**
   * Constructor for Item.
   *
   * @param name
   * @param value
   */
  public Item(String name, String value, boolean asData) {
    super();
    this.name = name;
    this.value = value;
    this.asData = asData;
  }

  /**
   * @return Returns the name.
   */
  public String getName() {
    return this.name;
  }

  /**
   * @param name The name to set.
   */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * @return Returns the value.
   */
  public String getValue() {
    return this.value;
  }

  /**
   * @param value The value to set.
   */
  public void setValue(String value) {
    this.value = value;
  }

  /**
   * @return Returns the asCData.
   */
  public boolean isAsCData() {
    return this.asData;
  }

  /**
   * @param asData The asData to set.
   */
  public void setAsData(boolean asData) {
    this.asData = asData;
  }

  /**
   * @see java.lang.Object#toString()
   */
  public String toString() {
    return new ToStringBuilder(this).append("name", name).append("value", value).append(
        "asData", asData).toString();
  }

}