/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.search;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;

import org.compiere.util.Ctx;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

import com.ampiere.web.struts.search.InfoPostalForm;

/**
 *	Search Postal and return selection
 *
 * 	@author 	Jorg Janke
 * 	@version 	$Id: InfoPostal.java,v 1.1 2008/09/30 12:26:10 clmg Exp $
 */
public class InfoPostal extends Info
{
	private Info_Column[] s_postalLayout = null;

	/**
	 *	Standard Constructor
	 *  @param frame frame
	 *  @param modal modal
	 *  @param WindowNo WindowNo
	 *  @param  value   Query value Name or Value if contains numbers
	 *  @param isSOTrx  if false, query vendors only
	 *  @param multiSelection multiple selection
	 *  @param whereClause where clause
	 */
	public InfoPostal(int windowNo, int C_Country_ID,
		String value, boolean multiSelection, String whereClause, Ctx ctx)
	{
		super(windowNo, "X_Postal", "Postal_ID", multiSelection, whereClause, ctx);

		log.info(value);
		
		title = Msg.getMsg(ctx, "InfoPostal");

		/**  Array of Column Info    */
		s_postalLayout = new Info_Column[8];
		int i = 0;
		s_postalLayout[i++] = new Info_Column(" ", "X_Postal.X_Postal_ID", IDColumn.class);
		s_postalLayout[i++] = new Info_Column(Msg.translate(ctx, "Postal"), "X_Postal.Postal", String.class);
		s_postalLayout[i++] = new Info_Column(Msg.translate(ctx, "Country"), "c.Name AS Country", KeyNamePair.class, "c.C_Country_ID");
		s_postalLayout[i++] = new Info_Column(Msg.translate(ctx, "Region"), "r.Name AS Region", KeyNamePair.class, "r.C_Region_ID");
		s_postalLayout[i++] = new Info_Column(Msg.translate(ctx, "Address1"), "X_Postal.X_Address", String.class);
		s_postalLayout[i++] = new Info_Column(Msg.translate(ctx, "Region_Kana"), "X_Postal.X_Region_Name_Kana", String.class);
		s_postalLayout[i++] = new Info_Column(Msg.translate(ctx, "City_Kana"), "X_Postal.X_City_Name_Kana", String.class);
		s_postalLayout[i++] = new Info_Column(Msg.translate(ctx, "Address_Kana"), "X_Postal.X_Address_Kana", String.class);

		m_keyColumnIndex = 0;

		m_C_Country_ID = C_Country_ID;

		//
		statInit();
		initInfo (value, whereClause);

		p_loadedOK = true;
	}	//	InfoPostal

	private int m_C_Country_ID = -1;

	/** From Clause             */
	private static String s_postalFROM = "X_Postal"
		+ " LEFT OUTER JOIN C_Country c ON (X_Postal.C_Country_ID=c.C_Country_ID AND c.IsActive='Y')"
		+ " LEFT OUTER JOIN C_Region r ON (X_Postal.C_Region_ID=r.C_Region_ID AND r.IsActive='Y')";
	
	//
	private String fieldValue = "";
	private String fieldRegion = "";
	private String fieldCity = "";
	private String fieldAddress = "";

	/**
	 *	Static Setup - add fields to parameterPanel
	 */
	private void statInit()
	{
	}	//	statInit

	/**
	 *	Dynamic Init
	 *  @param value value
	 *  @param whereClause where clause
	 */
	private void initInfo(String value, String whereClause)
	{

		//	Create Grid
		StringBuffer where = new StringBuffer();
		where.append("X_Postal.IsActive='Y' AND C_Country_ID="+m_C_Country_ID);
		if (whereClause != null && whereClause.length() > 0)
			where.append(" AND ").append(whereClause);
		//
		prepareTable(s_postalLayout, s_postalFROM,
			where.toString(),
			"X_Postal.Postal");

		//  Set Value
		if (value == null)
			value = "%";
		if (!value.endsWith("%"))
			value += "%";

		//	Put query string in Name if not numeric
		if (value.equals("%"))
			fieldValue = value;
		//	No Numbers entered
		else if ((value.indexOf("0")+value.indexOf("1")+value.indexOf("2")+value.indexOf("3")+value.indexOf("4") +value.indexOf("5")
			+value.indexOf("6")+value.indexOf("7")+value.indexOf("8")+value.indexOf("9")) == -10)
		{
			if (value.startsWith("%"))
				fieldValue = value;
			else
				fieldValue = ("%" + value);
		}
		//	Number entered
		else
			fieldValue = value;
	}	//	initInfo

	/*************************************************************************/

	/**
	 *	Construct SQL Where Clause and define parameters.
	 *  (setParameters needs to set parameters)
	 *  Includes first AND
	 *  @return WHERE clause
	 */
	public String getSQLWhere()
	{
		ArrayList<String> list = new ArrayList<String>();
		//	=> Value
		String value = fieldValue;
		if (!(value.equals("") || value.equals("%")))
			list.add ("X_Postal.Postal LIKE ?");
		
		//	=> Region
		String region = fieldRegion;
		if (!(region.equals("") || region.equals("%")))
			list.add ("X_Postal.X_Region_Name LIKE ?");
		
		//	=> City
		String city = fieldCity;
		if (!(city.equals("") || city.equals("%")))
			list.add ("X_Postal.X_City_Name LIKE ?");
		
		//	=> Address
		String address = fieldAddress;
		if (!(address.equals("") || address.equals("%")))
			list.add ("X_Postal.X_Address LIKE ?");
		
		StringBuffer sql = new StringBuffer();
		int size = list.size();
		//	Just one
		if (size == 1)
			sql.append(" AND ").append(list.get(0));
		else if (size > 1)
		{
			sql.append(" AND ");
			for (int i = 0; i < size; i++)
			{
				if (i > 0)
					sql.append(" AND ");
				sql.append(list.get(i));
			}
		}

		return sql.toString();
	}	//	getSQLWhere

	/**
	 *  Set Parameters for Query.
	 *  (as defined in getSQLWhere)
	 *  @param pstmt pstmt
	 *  @param forCount for counting records
	 *  @throws SQLException
	 */
	public void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException
	{
		int index = 1;
		//	=> Value
		String value = fieldValue;
		if (!(value.equals("") || value.equals("%")))
		{
			if (!value.endsWith("%"))
				value += "%";
			pstmt.setString(index++, value);
			log.fine("Value: " + value);
		}
		
		//	=> Region
		String region = fieldRegion;
		if (!(region.equals("") || region.equals("%")))
		{
			if (!region.endsWith("%"))
				region += "%";
			pstmt.setString(index++, region);
			log.fine("Region: " + region);
		}
		//	=> City
		String city = fieldCity;
		if (!(city.equals("") || city.equals("%")))
		{
			if (!city.endsWith("%"))
				city += "%";
			pstmt.setString(index++, city);
			log.fine("City: " + city);
		}
		//	=> Address
		String address = fieldAddress;
		if (!(address.equals("") || address.equals("%")))
		{
			if (!address.endsWith("%"))
				address += "%";
			pstmt.setString(index++, address);
			log.fine("Address: " + address);
		}
	}   //  setParameters

	/**
	 * Set query parameters
	 */
	public void setQueryParas(InfoPostalForm searchInfoForm) {
		fieldValue = (searchInfoForm.getValue() == null ? "" : searchInfoForm.getValue());
		fieldCity = (searchInfoForm.getCity() == null ? "" : searchInfoForm.getCity());
		fieldRegion = (searchInfoForm.getRegion() == null ? "" : searchInfoForm.getRegion());
	    fieldAddress = (searchInfoForm.getAddress() == null ? "" : searchInfoForm.getAddress());
	}	//	setQueryParas
}	//	InfoBPartner
