package com.ampiere.util.ajax;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * To make xml text for multi-task callout.
 * @author bato
 * @version $Revision: 1.1 $ $Date: 2008/09/30 12:26:47 $
 */
public class AjaxXmlMultiItemsBuider {
	private String encoding = "UTF-8";
	private List<AjaxXmlItemBuilder> multiItems 
			= new ArrayList<AjaxXmlItemBuilder>();

	/**
	 * @return Returns the encoding.
	 */
	public String getEncoding() {
		return encoding;
	}

	/**
	 * @param encoding The encoding to set.
	 */
	public void setEncoding(String encoding) {
		this.encoding = encoding;
	}
	
	public AjaxXmlMultiItemsBuider addTarget(AjaxXmlItemBuilder itemsBlock) {
		multiItems.add(itemsBlock);
		return this;
	}
	
	@Override
	public String toString() {
		StringBuffer xml = new StringBuffer().append("<?xml version=\"1.0\"");
		if (encoding != null) {
			xml.append(" encoding=\"");
			xml.append(encoding);
			xml.append("\"");
		}
		xml.append(" ?>");

		xml.append("<ajax-response>");
		xml.append("<response>");
		for (Iterator iter = multiItems.iterator(); iter.hasNext();) {
			AjaxXmlItemBuilder items = (AjaxXmlItemBuilder) iter.next();
			xml.append(items.toStringItems(true));
		}
		xml.append("</response>");
		xml.append("</ajax-response>");

		return xml.toString();
	}

}
