/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.web.servlet;

import java.io.IOException;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.compiere.util.WebEnv;
import org.compiere.util.WebUtil;


/**
 *  Application Start Page
 *  <pre>
 *  Creates a Frame with
 *  - Command   - cmd.html  (invisible)
 *  - Menu      - menu.html
 *  - Window    = window.html
 *  </pre>
 *  framesetOuter
 *  +- WCmd
 *  +- framesetMenuWindow
 *     +- WMenu
 *     +- framesetWindow
 *        +- WPopUp  -- deleted in ampiere --
 *        +- WWindow
 *  see webapps/compiere/index.html
 *  @author Jorg Janke
 *  @version $Id: WStart.java,v 1.1 2008/09/30 12:25:55 clmg Exp $
 */
public class WStart extends HttpServlet
{
	private static final long serialVersionUID = 1169090782332634306L;

	/**
	 *  Set UI directory to Servlet init param
	 */
	public void init(ServletConfig config) throws ServletException
	{
		super.init(config);
		if (!WebEnv.initWeb(config))
			throw new ServletException("WStart.init");
	}   //  init

	/**
	 * Process the HTTP Get request
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response) 
		throws ServletException, IOException
	{
		WebUtil.createLoginPage (request, response, this, null, null);
	}   //  doGet


	/**
	 *  Process the HTTP Post request
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response) 
		throws ServletException, IOException
	{
		doGet (request, response);
	}   //  doPost

}   //  WStart
