/**
 * 
 */
package com.ampiere.web.struts.search;

import java.util.Properties;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;
import org.compiere.util.Ctx;
import org.compiere.util.Msg;

import com.ampiere.web.struts.common.PopupBaseForm;


/**
 * @author Shinjirito
 *
 */
public class InfoBPartnerForm extends PopupBaseForm {
	private static final long serialVersionUID = 4548544954962757545L;

	private String contact;
	private String contactLabel;
	private String phone;
	private String phoneLabel;
	private String name;
	private String nameLabel;
	private String email;
	private String emailLabel;
	private String postal;
	private String postalLabel;
	private String checkAND;
	private boolean checkANDStatus;
	private String checkANDInfo;
	private String checkCustomer;
	private boolean checkCustomerStatus;

	public String getContact() {
		return contact;
	}
	public void setContact(String contact) {
		this.contact = contact;
	}
	public String getEmail() {
		return email;
	}
	public void setEmail(String email) {
		this.email = email;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getPhone() {
		return phone;
	}
	public void setPhone(String phone) {
		this.phone = phone;
	}
	public String getPostal() {
		return postal;
	}
	public void setPostal(String postal) {
		this.postal = postal;
	}
	public String getContactLabel() {
		return contactLabel;
	}
	public void setContactLabel(String contactLabel) {
		this.contactLabel = contactLabel;
	}
	public String getEmailLabel() {
		return emailLabel;
	}
	public void setEmailLabel(String emailLabel) {
		this.emailLabel = emailLabel;
	}
	public String getNameLabel() {
		return nameLabel;
	}
	public void setNameLabel(String nameLabel) {
		this.nameLabel = nameLabel;
	}
	public String getPhoneLabel() {
		return phoneLabel;
	}
	public void setPhoneLabel(String phoneLabel) {
		this.phoneLabel = phoneLabel;
	}
	public String getPostalLabel() {
		return postalLabel;
	}
	public void setPostalLabel(String postalLabel) {
		this.postalLabel = postalLabel;
	}
	public String getCheckAND() {
		return checkAND;
	}
	public void setCheckAND(String checkAND) {
		this.checkAND = checkAND;
	}
	public boolean isCheckANDStatus() {
		return checkANDStatus;
	}
	public void setCheckANDStatus(boolean checkANDStatus) {
		this.checkANDStatus = checkANDStatus;
	}
	public String getCheckANDInfo() {
		return checkANDInfo;
	}
	public void setCheckANDInfo(String checkANDInfo) {
		this.checkANDInfo = checkANDInfo;
	}
	public String getCheckCustomer() {
		return checkCustomer;
	}
	public void setCheckCustomer(String checkCustomer) {
		this.checkCustomer = checkCustomer;
	}
	public boolean isCheckCustomerStatus() {
		return checkCustomerStatus;
	}
	public void setCheckCustomerStatus(boolean checkCustomerStatus) {
		this.checkCustomerStatus = checkCustomerStatus;
	}

	/**
	 * Reset all properties to their default values.
	 *
	 * @param mapping The mapping used to select this instance
	 * @param request The servlet request we are processing
	 */
	public void reset(ActionMapping mapping, HttpServletRequest request) {
		/**
    	 * This will set LoginUserId From Session  
    	 */
    	super.reset(mapping, request);		

    	/**
    	 * Reset all properties to their default values.
    	 */
    	this.checkANDStatus = false;
    	this.checkCustomerStatus = false;
	}

	/**
	 *	Static Setup - set field value
	 */
	public void statInit(Ctx ctx, boolean isSOTrx, boolean checkANDStatus, boolean checkCustomerStatus) {
		super.statInit(ctx);
		setTitle(Msg.translate(ctx, "InfoBPartner"));

		setValueLabel(Msg.translate(ctx, "Value"));
		setNameLabel(Msg.translate(ctx, "Name"));
		setContactLabel(Msg.translate(ctx, "Contact"));
		setEmailLabel(Msg.translate(ctx, "EMail"));
		setPostalLabel(Msg.translate(ctx, "Postal"));
		setPhoneLabel(Msg.translate(ctx, "Phone"));
		setCheckAND(Msg.translate(ctx, "SearchAND"));
		setCheckANDInfo(Msg.translate(ctx, "SearchANDInfo"));
		setCheckANDStatus(checkANDStatus);

		if (isSOTrx) {
			setCheckCustomer(Msg.translate(ctx, "OnlyCustomers"));
		} else {
			setCheckCustomer(Msg.translate(ctx, "OnlyVendors"));
		}
		setCheckCustomerStatus(checkCustomerStatus);
	}

	/**
	 *	Dynamic Init
	 *  @param bpName BPartner name
	 *  @param whereClause where clause
	 */
	public void initInfo(String bpName)
	{
		//  Set Value
		if (bpName == null)
			bpName = "%";
		if (!bpName.endsWith("%"))
			bpName += "%";
		setValue("");
		setName("");

		//	Put query string in Name if not numeric
		if (bpName.equals("%"))
			setName(bpName);
		//	No Numbers entered
		else if ((bpName.indexOf("0")+bpName.indexOf("1")+bpName.indexOf("2")+bpName.indexOf("3")+bpName.indexOf("4") +bpName.indexOf("5")
			+bpName.indexOf("6")+bpName.indexOf("7")+bpName.indexOf("8")+bpName.indexOf("9")) == -10)
		{
			if (bpName.startsWith("%"))
				setName(bpName);
			else
				setName("%" + bpName);
		}
		//	Number entered
		else {
			setValue(bpName);
		}
	}	//	initInfo
}
