/**
 * 
 */
package com.ampiere.web.struts.search;

import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.framework.Lookup;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.WebSessionCtx;

import com.ampiere.search.InfoBPartner;
import com.ampiere.util.AmpiereUtil;

/**
 * @author Shinjirito
 *
 */
public class InfoBPartnerSearchAction extends InfoBaseAction {
	/**	Logger			*/
	protected CLogger	log = CLogger.getCLogger(getClass());

	/**
	 * 
	 */
	public ActionForward doExecute(ActionMapping mapping, ActionForm baseForm, HttpServletRequest request, HttpServletResponse response, ActionErrors errors, boolean mochaFlag) throws Exception {
		super.doExecute(mapping, baseForm, request, response, errors, mochaFlag);

		WebSessionCtx wsc = WebSessionCtx.get(request);
		HttpSession session = request.getSession();
		InfoBPartnerForm searchInfoFormBPartner = (InfoBPartnerForm)baseForm;
		session.setAttribute("searchResultBPartner", null);
		if (searchInfoFormBPartner != null) {
			int windowNo = searchInfoFormBPartner.getWindowNo();
			int AD_Column_ID = searchInfoFormBPartner.getColumn_ID();
			String columnName = searchInfoFormBPartner.getColumnName();

			// Create column lookup 
			Lookup lookup = createLookup(wsc.ctx, windowNo, AD_Column_ID, columnName);

			// Get where clause
			String whereClause = getWhereClause(wsc.ctx, lookup, columnName);

//			boolean isSOTrx = (Env.getContext(wsc.ctx, windowNo, "IsSOTrx").equals("N") ? false : true);
			boolean isSOTrx = (wsc.ctx.getContext(windowNo, "IsSOTrx").equals("N") ? false : true);
		    InfoBPartner info = new InfoBPartner(windowNo, "", isSOTrx, false, whereClause, wsc.ctx);
		    info.setQueryParas(searchInfoFormBPartner);

		    // Check record number
		    int rowCount = info.testCount(wsc.ctx);
		    rowCount = AmpiereUtil.setLargeRecordMsg(wsc.ctx, searchInfoFormBPartner, rowCount);

		    ArrayList result = info.executeQuery(wsc.ctx, rowCount, lookup);

	    	// Set search result
	    	session.setAttribute("searchResultBPartner", result);
		}

		request.setAttribute("doQuery", "0");
		return mapping.findForward("success");
	}
}
