/**
 * 
 */
package com.ampiere.web.struts.search;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.framework.Lookup;
import org.compiere.util.CLogger;
import org.compiere.util.Msg;
import org.compiere.util.WebSessionCtx;

import com.ampiere.search.Info;
import com.ampiere.util.AmpiereUtil;


/**
 * @author Shinjirito
 *
 */
public class InfoLookupAction extends InfoBaseAction {
	/**	Logger			*/
	protected CLogger	log = CLogger.getCLogger(this.getClass());

	/* (non-Javadoc)
	 * @see com.jware.base.web.struts.jWareBaseAction#doExecute(org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, org.apache.struts.action.ActionErrors, boolean)
	 */
	public ActionForward doExecute(ActionMapping mapping, ActionForm baseForm,
			HttpServletRequest request, HttpServletResponse response,
			ActionErrors errors, boolean mochaFlag) throws Exception {
		super.doExecute(mapping, baseForm, request, response, errors, mochaFlag);

		String doQurey = "0";
		HttpSession session = request.getSession();
		InfoLookupForm searchInfoForm = (InfoLookupForm)baseForm;
		if (searchInfoForm != null) {
		  	WebSessionCtx wsc = WebSessionCtx.get(request);
			int windowNo = searchInfoForm.getWindowNo();
			int AD_Column_ID = searchInfoForm.getColumn_ID();
			String name = searchInfoForm.getName();
			String columnName = searchInfoForm.getColumnName();
			String lookupID = AmpiereUtil.getFixedColumnName(columnName);
			String forward = lookupID.toLowerCase();
			session.setAttribute("searchResult" + lookupID, null);

			if (name != null && name.length() > 0) {
				doQurey = "1";
			}

			// Create column lookup 
			Lookup lookup = createLookup(wsc.ctx, windowNo, AD_Column_ID, columnName);

			// sets table name & key column
			getDirectAccessSQL(wsc.ctx, "*", columnName, lookup);

			Info info = Info.create(windowNo, m_tableName, m_keyColumnName, name, false, getWhereClause(wsc.ctx, lookup, columnName), wsc.ctx);
			session.setAttribute("infoLookup" + lookupID, info);

			searchInfoForm.statInit(wsc.ctx);
			if (info != null) {
				searchInfoForm.setTitle(info.getTitle());
			}
			searchInfoForm.setDateInfos(wsc.language.getLocale(), wsc.dateFormat.toPattern(), Msg.translate(wsc.ctx, "InvalidDate"));
			searchInfoForm.setLookupID(lookupID);

			// Set search info form
			session.setAttribute("searchInfoForm" + lookupID, searchInfoForm);

			request.setAttribute("doQuery", doQurey);
		    return mapping.findForward(forward);
		}

		request.setAttribute("doQuery", doQurey);
	    return mapping.findForward("general");
	}
}
