package com.jware.apps.login;

import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.util.MessageResources;

import com.jware.base.web.struts.jWareBaseConstants;
import com.jware.base.web.struts.jWareLogonUserPermission;
import com.jware.util.crypt.PasswordUtils;

/**
 * Implementation of <strong>Action</strong> that validates a registration form.
 *
 * @author David Wintefeldt
*/
public final class LogonAction extends Action implements jWareBaseConstants{

    /**
     * Commons Logging instance.
    */
    private Log log = LogFactory.getLog(this.getClass().getName());

    /**
     * Process the specified HTTP request, and create the corresponding HTTP
     * response (or forward to another web component that will create it).
     * Return an <code>ActionForward</code> instance describing where and how
     * control should be forwarded, or <code>null</code> if the response has
     * already been completed.
     *
     * @param mapping The ActionMapping used to select this instance
     * @param actionForm The optional ActionForm bean for this request (if any)
     * @param request The HTTP request we are processing
     * @param response The HTTP response we are creating
     *
     * @exception Exception if an input/output error or servlet exception occurs
     */
    public ActionForward execute(ActionMapping mapping,
                 ActionForm form,
                 HttpServletRequest request,
                 HttpServletResponse response)
    throws Exception {

		// Extract attributes we will need
		HttpSession session = request.getSession();
		Locale locale = getLocale(request);

		MessageResources messages = getResources(request);
		LogonForm info = (LogonForm)form;
	
		String action = request.getParameter("action");

		// Was this transaction cancelled?
		if (isCancelled(request)) {
		    if (log.isInfoEnabled()) {
		       log.info(" " + mapping.getAttribute() + " - Registration transaction was cancelled");
		    }

		    removeFormBean(mapping, request);

		    return (mapping.findForward("logon"));
		}
		
		String username = info.getUsername();
		String password = info.getPassword();
		
		if( log.isDebugEnabled() ){
			log.debug(" USERNAME= " + username );
			log.debug(" PASSWORD= " + password );
		}
		
		String encPwd = PasswordUtils.encryptPassword( password ); 
				
		List userlists = null;
		jWareLogonUserPermission userpermission = new jWareLogonUserPermission();
		
		session.setAttribute(JWARE_LOGIN_INFO, userpermission);
		
		return mapping.findForward("success");
		
    }

    /**
     * Convenience method for removing the obsolete form bean.
     *
     * @param mapping The ActionMapping used to select this instance
     * @param request The HTTP request we are processing
    */
    protected void removeFormBean(ActionMapping mapping, HttpServletRequest request) {
       // Remove the obsolete form bean
       if (mapping.getAttribute() != null) {
           if ("request".equals(mapping.getScope())) {
               request.removeAttribute(mapping.getAttribute());
           } else {
              HttpSession session = request.getSession();
              session.removeAttribute(mapping.getAttribute());
           }
       }
    }
    
	protected void setActionMessages(ActionErrors errors, String key ) {
		
		setActionMessages(errors, key, null);
		
	}
	
	protected void setActionMessages(ActionErrors errors, String key, Object[] args ) {

		ActionMessage message = null;

		if (args != null && args.length > 0) {
			message = new ActionMessage(key, args );
		} else {
			message = new ActionMessage( key );
		}

		if( message != null ){
			errors.add(ActionErrors.GLOBAL_MESSAGE, message);
		}

	}

}

