/*
 * Copyright James House (c) 2001-2004
 * 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met: 1.
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer. 2. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 */
package com.jware.apps.scheduler.jobs;

import java.util.Date;

import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;


/**
 * <p>
 * A dumb implementation of an InterruptableJob, for unittesting purposes.
 * </p>
 * 
 * @author <a href="mailto:bonhamcm@thirdeyeconsulting.com">Chris Bonham</a>
 * @author James House
 */
public class DumbInterruptableJob implements InterruptableJob {
    
    private boolean interrupted = false;

    /*
     * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     * 
     * Constructors.
     * 
     * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     */

    public DumbInterruptableJob() {
    }

    /*
     * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     * 
     * Interface.
     * 
     * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     */

    /**
     * <p>
     * Called by the <code>{@link org.quartz.Scheduler}</code> when a <code>{@link org.quartz.Trigger}</code>
     * fires that is associated with the <code>Job</code>.
     * </p>
     * 
     * @throws JobExecutionException
     *           if there is an exception while executing the job.
     */
    public void execute(JobExecutionContext context)
            throws JobExecutionException {

        System.err.println("--->" + context.getJobDetail().getFullName()
                + " executing.[" + new Date() + "]");

        try {
            
            // main job loop... see the JavaDOC for InterruptableJob for discussion...
            
            // do some work... in this example we are 'simulating' work by sleeping... :)
            try {
                Thread.sleep(1000L);
            } catch (Exception ignore) {
                ignore.printStackTrace();
            }
            
            // periodically check if we've been interrupted...
            if(interrupted) {
                System.err.println("--- " + context.getJobDetail().getFullName() + "  -- Interrupted... bailing out!");
                
                return; // could also choose to throw a JobExecutionException 
                         // if that made for sense based on the particular  
                         // job's responsibilities/behaviors
            }

            // do some further work... 
            try {
                Thread.sleep(1000L);
            } catch (Exception ignore) {
                ignore.printStackTrace();
            }
            
            // periodically check if we've been interrupted...
            if(interrupted) {
                System.err.println("--- " + context.getJobDetail().getFullName() + "  -- Interrupted... bailing out!");
                
                return; // could also choose to throw a JobExecutionException 
                         // if that made for sense based on the particular  
                         // job's responsibilities/behaviors
            }
            
            // do even more fun work... 
            try {
                Thread.sleep(1000L);
            } catch (Exception ignore) {
                ignore.printStackTrace();
            }
            

            // finish up the job...
            try {
                Thread.sleep(1000L);
            } catch (Exception ignore) {
                ignore.printStackTrace();
            }

            // periodically check if we've been interrupted...
            if(interrupted) {
                System.err.println("--- " + context.getJobDetail().getFullName() + "  -- Interrupted... bailing out!");
                
                return; // could also choose to throw a JobExecutionException 
                         // if that made for sense based on the particular  
                         // job's responsibilities/behaviors
            }
            
            
        }
        finally {
            System.err.println("--- " + context.getJobDetail().getFullName()
                    + " complete.[" + new Date() + "]");
        }
    }
    
    /**
     * <p>
     * Called by the <code>{@link Scheduler}</code> when a user
     * interrupts the <code>Job</code>.
     * </p>
     * 
     * @return void (nothing) if job interrupt is successful.
     * @throws JobExecutionException
     *           if there is an exception while interrupting the job.
     */
    public void interrupt() throws UnableToInterruptJobException {
        System.err.println("---" + "  -- INTERRUPTING --");
        this.interrupted = true;
    }

}