/*
 *  Copyright James House (c) 2001-2004
 *
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 *
 * This product uses and includes within its distribution, 
 * software developed by the Apache Software Foundation 
 *     (http://www.apache.org/)
 *
 */
package com.jware.apps.scheduler.web.struts.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerListener;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

import java.util.List;

/**
  *  FIXME: Document class no.ezone.quartz.web.action.EditJobListenersAction
  *
  * @since Feb 3, 2003
  * @version $Revision: 1.1 $
 * @author Erick Romson
 * @author Rene Eigenheer
  */

public class EditTriggerListenersAction extends EditListenersAction{

	/** The field's value is $Id: EditTriggerListenersAction.java,v 1.1 2008/09/30 12:26:28 clmg Exp $ */
	public static final String CVS_INFO="$Id: EditTriggerListenersAction.java,v 1.1 2008/09/30 12:26:28 clmg Exp $";

	private static transient final Log logger = LogFactory.getLog( EditTriggerListenersAction.class );

    /**
     *
     * @param listenerToDelete
     * @param scheduler
     * @throws ServletException
     */
    void removeListener(String listenerToDelete, Scheduler scheduler)throws ServletException
    {
        TriggerListener triggerListener=null;
        try
        {
            List globalListeners=scheduler.getGlobalTriggerListeners();
            for (int j = 0; j < globalListeners.size(); j++)
            {
                TriggerListener gJl = (TriggerListener) globalListeners.get(j);
                if (gJl.getName().equals(listenerToDelete))
                {
                    triggerListener=gJl;
                }
            }

            logger.info("Deleting listener "+listenerToDelete+" class: "+triggerListener.getClass().getName());
            scheduler.removeGlobalTriggerListener(triggerListener);
        }
        catch (SchedulerException e)
        {
            throw new ServletException(e);
        }
    }

    /**
     *
     * @param newListenerClass
     * @param scheduler
     * @throws ServletException
     */
    void addListener(String newListenerClass, Scheduler scheduler) throws ServletException
    {
        TriggerListener listener=null;
        try
        {
            listener=(TriggerListener)Class.forName(newListenerClass).newInstance();
        }
        catch (InstantiationException e)
        {
            throw new ServletException("Must have an empty constructor",e);
        }
        catch (IllegalAccessException e)
        {
            throw new ServletException("Must have a public cosntructor",e);
        }
        catch (ClassNotFoundException e)
        {
            throw new ServletException("The class "+newListenerClass+" is not found",e);
        }

        try
        {
            logger.info("Adding listener "+listener.getName()+" class: "+listener.getClass().getName());
            scheduler.addGlobalTriggerListener(listener);
        }
        catch (SchedulerException e)
        {
            throw new ServletException(e);
        }
    }

    /**
     * 
     * @param scheduler
     * @param triggerListenerNames
     * @param triggerListenerClasses
     * @throws ServletException
     */
    void addAllListenerNamesAndClasses(Scheduler scheduler, List triggerListenerNames, List triggerListenerClasses) throws ServletException
    {
        List triggerListeners=null;
        try
        {
            triggerListeners=scheduler.getGlobalTriggerListeners();
        }
        catch (SchedulerException e)
        {
            throw new ServletException(e);
        }

        if (triggerListeners!=null)
        {
            for (int i = 0; i < triggerListeners.size(); i++)
            {
                TriggerListener triggerListener = (TriggerListener) triggerListeners.get(i);
                triggerListenerClasses.add(triggerListener.getClass().getName());
                triggerListenerNames.add(triggerListener.getName());
            }
        }
    }

    /**
     *
     */
    void setRequest(HttpServletRequest request)
    {
        request.setAttribute("returnPath","editTriggerListeners.do");
    }

}

/*
* CVS log:
* $Log: EditTriggerListenersAction.java,v $
* Revision 1.1  2008/09/30 12:26:28  clmg
* web version
*
* Revision 1.1  2006/09/25 14:20:45  hans
* Compiere Japan First Upload 20060925 Hans
*
* Revision 1.1  2006/09/25 13:15:18  hans
* Compiere Japan First Upload 20060925 Hans
*
* Revision 1.1  2006/03/08 12:15:46  jrmt
* Jirimuto added in 2006/03/08
*
* Revision 1.1  2006/03/07 16:43:05  jrmt
* Jirimuto added in 2006/03/08
*
* Revision 1.1  2006/03/07 13:57:47  jrmt
* Jirimuto added in 2006/03/07
*
* Revision 1.1  2005/10/06 18:58:03  jrmt
* 200501006 created by jirimuto
*
* Revision 1.1  2005/07/28 11:25:30  jrmt
* 20050728 added by jirimuto
*
* Revision 1.1  2005/04/17 10:40:18  jrmt
* 20050417 modified by jirimuto
*
* Revision 1.1  2005/04/13 05:43:52  jrmt
* 20050413 added by jirimuto
*
* Revision 1.1  2004/10/24 05:28:33  jrmt
* jrmt added 20041024
*
* Revision 1.2  2004/01/13 19:44:34  jhouse
* update copyright date to new year (2004)
*
* Revision 1.1  2003/10/03 18:15:28  sutter2k
* intial move of web app src
*
* Revision 1.2  2003/05/21 02:29:15  jhouse
* Preparing "head" for 1.2.0 work.
*
* Revision 1.1  2003/02/05 00:54:37  erik
* first draft
*
*/

