/*
 * Created on 2004/08/16
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.jware.base.web.struts;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import com.jware.base.*;
import com.jware.base.error.JwareApplicationException;

/**
 * @author jrmt
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class HistoryBackAction extends Action implements IMochaConstants {

	private static final Log log = LogFactory.getLog(BaseAction.class);

	/* (non-Javadoc)
	 * @see jp.co.foronefirst.mocha.web.struts.BaseAction#doExecute(org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, org.apache.struts.action.ActionErrors)
	 */
	public ActionForward execute(ActionMapping mapping, 
				ActionForm form,
				HttpServletRequest request,
				HttpServletResponse response)
				throws Exception {
		
		//遷移�?
		ActionForward forward = null;

		String prevUri = null;
		Cookie[] cookies = request.getCookies();
		if( cookies != null ){
			for( int i=0; i<cookies.length; i++ ){
				Cookie cookie = cookies[i];
				if( "PREVURI".equalsIgnoreCase( cookie.getName() ) ){
					prevUri = cookie.getValue();
					if( log.isDebugEnabled() ){
						log.debug("Action PREVURI = " + prevUri );
					}
				}
			}
		}
		 
		HttpSession session = request.getSession(); 
		LinkedList historyList = (LinkedList)session.getAttribute(ACCESS_HISTORY);
		AccessHistory accessHistory = null;
		if( log.isDebugEnabled() ){
			log.debug("history List Size = " + historyList.size());
		}
		
		if( historyList != null && historyList.size() > 1 ){
			
			ActionForward newForward = mapping.findForward( FORWARD_SUCCESS );
			
			if( historyList.size() > 1 ){

				int currentPoint = 0;
				if( prevUri != null && prevUri.trim().length() > 0 ){
					while( currentPoint < historyList.size() ){
						AccessHistory tempHistory = (AccessHistory)historyList.get(currentPoint);
						if( prevUri.indexOf( tempHistory.getForward().getPath()) >= 0 ) {
							break;
						}
						currentPoint++;
					}
					if( currentPoint >= historyList.size() ){
						currentPoint = 0;
					}
				}
				
				historyList.remove( currentPoint );
				accessHistory = (AccessHistory)historyList.get(currentPoint);
			} 
			
			if( log.isDebugEnabled() ){
				log.debug("accessHistory URL = " + accessHistory.getUri());
			}

			forward = accessHistory.getForward();

			if( log.isDebugEnabled() ){
				log.debug("history set forward path = " + forward.getPath() );
			}
			
			form = accessHistory.getForm();

			List requestNameList = accessHistory.getRequestNames();
			Map requestMap = accessHistory.getRequestMap();
			for( int i=0; i<requestNameList.size(); i++ ){
				String requestName = (String)requestNameList.get(i);
				request.setAttribute(requestName, requestMap.get(requestName));
			}

			List sessionNameList = accessHistory.getSessionNames();
			Map sessionMap = accessHistory.getSessionMap();
			for( int i=0; i<sessionNameList.size(); i++ ){
				String sessionName = (String)sessionNameList.get(i);
				session.setAttribute(sessionName, sessionMap.get(sessionName));
			}

			List parameterNameList = accessHistory.getParameterNames();
			Map parameterMap = accessHistory.getParameterMap();
			if( log.isDebugEnabled() ){
				log.debug("1. Parameter Map Size = " + parameterMap.size() );
			}
				
			JwareHttpServletRequestWrapper requestWrapper = new JwareHttpServletRequestWrapper(request);
			requestWrapper.setRequestURI( accessHistory.getUri() );
			
			for( int i=0; i<parameterNameList.size(); i++ ){
				String parameterName = (String)parameterNameList.get(i);
				if( log.isDebugEnabled() ){
					log.debug(" Parameter Name = " + parameterName );
				}
				String[] parameterValues = (String[])parameterMap.get(parameterName);
				for(int j=0; j<parameterValues.length; j++){
					log.debug("parameterValues["+j+"] = " + parameterValues[j]);
				}
				requestWrapper.setParameterValues( parameterName, parameterValues );				
			}
				
			request = (HttpServletRequest)requestWrapper;

		} else {
			
			forward = mapping.findForward( FORWARD_SUCCESS );
				
		}
			
		return forward;
	}

}
