package com.jware.base.web.struts;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import com.jware.base.error.JwareApplicationException;
import com.jware.util.ResourceUtility;

/**
 * @author jrmt
 * 
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public abstract class jWareBaseAction extends BaseAction implements jWareBaseConstants {

    final public ActionForward doExecute(ActionMapping mapping, ActionForm baseForm,
            HttpServletRequest request, HttpServletResponse response, ActionErrors errors)
            throws JwareApplicationException {

        //	Begin login check and permission check
        HttpSession session = request.getSession();

		StringBuffer requestURL = request.getRequestURL();

		if( requestURL != null && !"https".equalsIgnoreCase( requestURL.substring( 0, 5) ) ){

			try{
				
	        	ResourceUtility resourceUtility = new ResourceUtility();
	        	String httpsEnabled = resourceUtility.getResources().getString("httpsForwardEnable");
	        	if( "true".equalsIgnoreCase(httpsEnabled) ){

	        		String httpsport = resourceUtility.getResources().getString("httpsPort");
	            	StringBuffer httpsurl = new StringBuffer();
	            	httpsurl.append( "https://");
	            	httpsurl.append( request.getServerName());
	            	int port = request.getServerPort();
	            	if( port != 80){
	            		httpsurl.append( ":"+httpsport );
	            	}
	            	httpsurl.append( request.getRequestURI() );
	            	request.setAttribute( HTTPS_FORWARD_URL, httpsurl.toString() );
	            	
	        		return (mapping.findForward(FORWARD_HTTPS));

	        	}
	        	
	        } catch( Exception e ){
	        	;
	        }
		}
        jWareLogonUserPermission userPermission = (jWareLogonUserPermission) session
                .getAttribute(JWARE_LOGIN_INFO);

        if (userPermission == null)
            return (mapping.findForward(FORWARD_LOGON));

        if (!userPermission.checkActionPermission(mapping.getPath())) {
            return (mapping.findForward(FORWARD_CHECK_PERMISSION_FAIL));
        }

        //	End login check and permission check

        ActionForward forward = null;
        try {
            forward = doExecute(mapping, baseForm, request, response, errors, true);
        } catch (JwareApplicationException e) {
            throw e;
        } catch (Exception e) {
            throw (new JwareApplicationException("E900001", e));
        }
        return forward;
    }

    abstract public ActionForward doExecute(ActionMapping mapping, ActionForm baseForm,
            HttpServletRequest request, HttpServletResponse response, ActionErrors errors,
            boolean mochaFlag) throws Exception;

}