package com.jware.base.web.struts;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;


import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.Resources;
import org.apache.struts.validator.ValidatorForm;

import com.jware.base.JwareValidator;
import com.jware.base.error.JwareApplicationException;

/**
 * @author jrmt
 */
public class jWareBaseForm extends ValidatorForm implements Serializable {

	/** ログイン情報セッション変数名 */
	public static final String JWARE_LOGIN_INFO			= "jWareLoginInfo";

	private String primaryKeyEditable = "true";
	
	private boolean newFlg = true;
	
	/**
	 * ログオンユーザー情報を保持するプロパーティ 
	 */
	private int logonUserId;

	/**
	 * 
	 */
	public jWareBaseForm() {
		super();
	}

	/**
	 * Reset all properties to their default values.
	 *
	 * @param mapping The mapping used to select this instance
	 * @param request The servlet request we are processing
	 */
	public void reset(ActionMapping mapping, HttpServletRequest request) {

        HttpSession session = request.getSession();

        jWareLogonUserPermission userPermission = (jWareLogonUserPermission) session
                .getAttribute(JWARE_LOGIN_INFO);
        
	}
	
	/**
	 * @return Returns the primaryKeyEditable.
	 */
	public String getPrimaryKeyEditable() {
		return primaryKeyEditable;
	}
	/**
	 * @param primaryKeyEditable The primaryKeyEditable to set.
	 */
	public void setPrimaryKeyEditable(String primaryKeyEditable) {
		this.primaryKeyEditable = primaryKeyEditable;
	}
	
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request)
    {
        ActionErrors errors = super.validate( mapping, request );
        
        return validate(mapping, request, errors);
        
    }
	
	/**
	 * バリデートチェック
	 */
    public ActionErrors validate( ActionMapping actionMapping,HttpServletRequest request, ActionErrors errors ) {
    	
    	JwareValidator validator = new JwareValidator(Resources.getMessageResources(request));
    	
        return errors;
    }


	public void copyPropertiesFrom( Object orig ) throws JwareApplicationException {

		try{
	
			if (orig == null) {
				throw new IllegalArgumentException("Method copyPropertiesFrom : No origin bean specified");
			}
	
			if (orig instanceof DynaBean) {
				DynaProperty origDescriptors[] =
					((DynaBean) orig).getDynaClass().getDynaProperties();
				for (int i = 0; i < origDescriptors.length; i++) {
					String name = origDescriptors[i].getName();
					if (PropertyUtils.isWriteable(this, name)) {
						Object value = ((DynaBean) orig).get(name);
						PropertyUtils.setSimpleProperty(this, name, value);
					}
				}
				
			} else if (orig instanceof Map) {
				
				Iterator names = ((Map) orig).keySet().iterator();
				while (names.hasNext()) {
					String name = (String) names.next();
					if (PropertyUtils.isWriteable(this, name)) {
						Object value = ((Map) orig).get(name);
						PropertyUtils.setSimpleProperty(this, name, value);
					}
				}
				
			} else {
				
				PropertyDescriptor origDescriptors[] =
					PropertyUtils.getPropertyDescriptors(orig);
				for (int i = 0; i < origDescriptors.length; i++) {
					String name = origDescriptors[i].getName();
					if (PropertyUtils.isReadable(orig, name)) {
						if (PropertyUtils.isWriteable(this, name)) {
							Object value = PropertyUtils.getSimpleProperty(orig, name);
							PropertyUtils.setSimpleProperty(this, name, value);
						}
					}
				}
				
			}

		} catch ( Exception e ){

			throw new JwareApplicationException("E999999", e);

		}

	}

	public void copyPropertiesTo( Object dest ) throws JwareApplicationException {

		try {
				
			if (dest == null) {
				throw new IllegalArgumentException("Method copyPropertiesTo : No dest bean specified");
			}
	
			PropertyDescriptor origDescriptors[] =
				PropertyUtils.getPropertyDescriptors(this);
			for (int i = 0; i < origDescriptors.length; i++) {
				String name = origDescriptors[i].getName();
				if (PropertyUtils.isReadable(this, name)) {
					if (dest instanceof DynaBean) {
						if (PropertyUtils.isWriteable(dest, name)) {
							Object value = PropertyUtils.getSimpleProperty(this, name);
							((DynaBean) dest).set(name, value);
						}
					} else /* if (dest is a standard JavaBean) */ {
						if (PropertyUtils.isWriteable(dest, name)) {
							Object value = PropertyUtils.getSimpleProperty(this, name);
							PropertyUtils.setSimpleProperty(dest, name, value);
						}
					}
				}
			}

		} catch ( Exception e ) {

			throw new JwareApplicationException("E999999", e);

		}
		
	}
    
	/**
	 * @return Returns the newFlg.
	 */
	public boolean isNewFlg() {
		return newFlg;
	}
	/**
	 * @param newFlg The newFlg to set.
	 */
	public void setNewFlg(boolean newFlg) {
		this.newFlg = newFlg;
	}
	
	/**
	 * @return Returns the logonUserId.
	 */
	public int getLogonUserId() {
		return logonUserId;
	}
	/**
	 * @param logonUserId The logonUserId to set.
	 */
	public void setLogonUserId(int logonUserId) {
		this.logonUserId = logonUserId;
	}
}
