package com.jware.common.charts;

import java.awt.*;

import org.jCharts.chartData.*;
import org.jCharts.properties.*;
import org.jCharts.axisChart.*;
import org.jCharts.test.TestDataGenerator;
import org.jCharts.types.ChartType;

public class AxisCharts extends BaseChart {

	public static final int width= 500;
	public static final int height= 300;


	/*****************************************************************************************
	*
	*
	******************************************************************************************/
	private AxisChart getChart( AxisProperties axisProperties ) throws ChartDataException
	{
		String[] xAxisLabels= { "1998", "1999", "2000", "2001", "2002", "2003", "2004" };
		String xAxisTitle= "Years";
		String yAxisTitle= "Problems";
		String title= "Micro$oft at Work";
		DataSeries dataSeries = new DataSeries( xAxisLabels, xAxisTitle, yAxisTitle, title );

		dataSeries.addIAxisPlotDataSet( AxisCharts.createAxisChartDataSet( ChartType.AREA, new AreaChartProperties(), 200, 5000 ) );

		ChartProperties chartProperties= new ChartProperties();
		LegendProperties legendProperties= new LegendProperties();

		AxisChart axisChart= new AxisChart( dataSeries, chartProperties, axisProperties, legendProperties, AxisCharts.width, AxisCharts.height );

		return axisChart;
	}


	/*****************************************************************************************
	* Tests a 'real' data set and usage.
	*
	* @throws ChartDataException
	******************************************************************************************/
	public void run() throws ChartDataException, PropertyException
	{
		this.rounding();
		this.userDefinedScale();

		this.numberOfItemsOnYAxis();
		this.gridLines();

		this.dollarSigns();
		this.commas();

		this.axisBackgroundPaint();
		this.axisTitles();

		this.zeroLine();
		this.scaleFont();

		this.tickMarks();

		this.verticalXAxisLabels();
	}





	/*****************************************************************************************/
	private void rounding() throws ChartDataException
	{
		AxisProperties axisProperties= new AxisProperties();
		axisProperties.setYAxisRoundValuesToNearest( -2 );

		super.exportImage( this.getChart( axisProperties ), "axisRounding" );
	}




	/*****************************************************************************************/
	private void userDefinedScale() throws ChartDataException, PropertyException
	{
		AxisProperties axisProperties= new AxisProperties( -2000, 850 );
		axisProperties.setYAxisRoundValuesToNearest( 0 );
		super.exportImage( this.getChart( axisProperties ), "userDefinedScale" );
	}



	/*****************************************************************************************/
	private void numberOfItemsOnYAxis() throws ChartDataException
	{
		AxisProperties axisProperties= new AxisProperties();
		axisProperties.setYAxisNumItems( 8 );

		super.exportImage( this.getChart( axisProperties ), "numberOfItemsOnYAxis" );
	}



	/*****************************************************************************************/
	private void gridLines() throws ChartDataException
	{
		AxisProperties axisProperties= new AxisProperties();
		axisProperties.setGridLineColor( AxisProperties.X_AXIS, Color.red );
		axisProperties.setShowGridLine( AxisProperties.Y_AXIS, AxisProperties.GRID_LINES_NONE );
		axisProperties.setShowGridLine( AxisProperties.X_AXIS, AxisProperties.GRID_LINES_ONLY_WITH_LABELS );

		double[][] data= { { 3444d, 1506.3d, 2777d, 2550.345d, 659.667d, 950.6644d, 4500.3453d, 1200.67583d, 3000.4354d, 1268.0001d, 2444.432d, 5003d } };
		String[] xAxisLabels= { "January", "Febuary", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" };
		String[] legendLabels= { "New Bugs in Windows Per Month" };
		Paint[] paints= { Color.blue };
		String xAxisTitle= "Months";
		String yAxisTitle= "Bugs";
		String title= "Micro$oft At Work";

		DataSeries dataSeries= new DataSeries( xAxisLabels, xAxisTitle, yAxisTitle, title );
		AxisChartDataSet axisChartDataSet= new AxisChartDataSet( data, legendLabels, paints, ChartType.AREA, new AreaChartProperties() );

		dataSeries.addIAxisPlotDataSet( axisChartDataSet );

		AxisChart axisChart= new AxisChart( dataSeries, new ChartProperties(), axisProperties, new LegendProperties(), width, height );
		super.exportImage( axisChart, "gridLines" );
	}




	/*****************************************************************************************/
	private void dollarSigns() throws ChartDataException
	{
		AxisProperties axisProperties= new AxisProperties();
		axisProperties.setYAxisUseDollarSigns( true );
		super.exportImage( this.getChart( axisProperties ), "dollarSigns" );
	}

	/*****************************************************************************************/
	private void commas() throws ChartDataException
	{
		AxisProperties axisProperties= new AxisProperties();
		axisProperties.setYAxisUseCommas( false );
		super.exportImage( this.getChart( axisProperties ), "commas" );
	}



	/*****************************************************************************************/
	private void axisBackgroundPaint() throws ChartDataException
	{
		AxisProperties axisProperties= new AxisProperties();
		axisProperties.setBackgroundPaint( Color.yellow );
		super.exportImage( this.getChart( axisProperties ), "axisBackground" );
	}


	/*****************************************************************************************/
	private void axisTitles() throws ChartDataException
	{
		double[][] data= { { 3444d, 1506.3d, 2777d, 2550.345d, 659.667d, 950.6644d, 4500.3453d, 1200.67583d, 3000.4354d, 1268.0001d, 2444.432d, 5003d } };
		String[] xAxisLabels= { "January", "Febuary", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" };
		String[] legendLabels= { "New Bugs in Windows Per Month" };
		Paint[] paints= { Color.blue };
		String xAxisTitle= "Months";
		String yAxisTitle= "Bugs";
		String title= "Micro$oft At Work";
		AxisChartDataSet axisChartDataSet= new AxisChartDataSet( data, legendLabels, paints, ChartType.AREA, new AreaChartProperties() );


		DataSeries dataSeries= new DataSeries( xAxisLabels, null, yAxisTitle, title );
		dataSeries.addIAxisPlotDataSet( axisChartDataSet );

		AxisChart axisChart= new AxisChart( dataSeries, new ChartProperties(), new AxisProperties(), new LegendProperties(), width, height );
		super.exportImage( axisChart, "axisTitles" );



		AxisProperties axisProperties= new AxisProperties();
		axisProperties.setAxisTitleFont( new Font( "Arial Narrow", Font.BOLD, 14 ) );
		axisProperties.setAxisTitleColor( Color.blue );

		axisChart= new AxisChart( dataSeries, new ChartProperties(), axisProperties, new LegendProperties(), width, height );
		super.exportImage( axisChart, "axisTitleFont" );
	}


	/*****************************************************************************************/
	private void zeroLine() throws ChartDataException, PropertyException
	{
		AxisProperties axisProperties= new AxisProperties( -2000, 1200 );
		axisProperties.setShowZeroLine( false );
		super.exportImage( this.getChart( axisProperties ), "noZeroLine" );

		axisProperties.setShowZeroLine( true );
		axisProperties.setZeroLinePaint( Color.red );
		axisProperties.setZeroLineStroke( new BasicStroke( 1f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND, 5f, new float[]{ 5f, 5f, 10f, 5f}, 4f ) );
		super.exportImage( this.getChart( axisProperties ), "zeroLinePaintStroke" );
	}



	/*****************************************************************************************/
	private void scaleFont() throws ChartDataException
	{
		AxisProperties axisProperties= new AxisProperties();
		axisProperties.setScaleFont( new Font( "Georgia Negreta cursiva", Font.PLAIN, 13 ) );
		axisProperties.setScaleFontColor( Color.blue );
		super.exportImage( this.getChart( axisProperties ), "scaleFont" );
	}


	/*****************************************************************************************/
	private void verticalXAxisLabels() throws ChartDataException
	{
		AxisProperties axisProperties= new AxisProperties();
		axisProperties.setXAxisVerticalScaleFlag( true );
		super.exportImage( this.getChart( axisProperties ), "verticalXAxisLabels" );
	}


	/*****************************************************************************************/
	private void tickMarks() throws ChartDataException
	{
		AxisProperties axisProperties= new AxisProperties();
		axisProperties.setShowTicks( AxisProperties.X_AXIS, AxisProperties.TICKS_ONLY_WITH_LABELS );

		super.exportImage( this.getChart( axisProperties ), "ticksWithLabels" );


		axisProperties= new AxisProperties();
		axisProperties.setShowTicks( AxisProperties.X_AXIS, AxisProperties.TICKS_NONE );
		super.exportImage( this.getChart( axisProperties ), "noTicks" );


		axisProperties= new AxisProperties();
		axisProperties.setTickColor( AxisProperties.X_AXIS, Color.blue );
		axisProperties.setTickColor( AxisProperties.Y_AXIS, Color.green );
		super.exportImage( this.getChart( axisProperties ), "tickColors" );


		axisProperties= new AxisProperties();
		axisProperties.setTickStroke( AxisProperties.X_AXIS, new BasicStroke( 2.0f ) );
		super.exportImage( this.getChart( axisProperties ), "tickStroke" );
	}




	/*****************************************************************************************************
   *
	*
	*****************************************************************************************************/
	public static final DataSeries createDataSeries()
	{
		String[] xAxisLabels= { "1998", "1999", "2000", "2001", "2002", "2003", "2004" };
		String xAxisTitle= "Years";
		String yAxisTitle= "Problems";
		String title= null;

		return new DataSeries( xAxisLabels, xAxisTitle, yAxisTitle, "Micro$oft At Work" );
	}

	/*****************************************************************************************
	*
	*
	* @param minValue
	* @param maxValue
	* @return AxisChartDataSet
	******************************************************************************************/
	public static final AxisChartDataSet createAxisChartDataSet(  ChartType chartType,
		ChartTypeProperties chartTypeProperties,
        	int minValue,
		int maxValue ) throws ChartDataException
	{
		double[][] data= TestDataGenerator.getRandomNumbers( 3, 7, minValue, maxValue );
		String[] legendLabels= { "Bugs", "Security Holes", "Backdoors" };
		Paint[] paints= TestDataGenerator.getRandomPaints( 3 );

		return new AxisChartDataSet( data, legendLabels, paints, chartType, chartTypeProperties );
	}

}