package com.jware.common.charts;

import java.awt.*;

import org.jCharts.chartData.*;
import org.jCharts.properties.*;
import org.jCharts.axisChart.*;
import org.jCharts.types.ChartType;
import org.jCharts.test.TestDataGenerator;


public class BarCharts extends AxisCharts {

  String xAxisTitle= "Years";
  String yAxisTitle= "Problems";
  String title= "Micro$oft at Work";
  String[] xAxisLabels= { "1998", "1999", "2000", "2001", "2002", "2003", "2004" };
  String[] legendLabels= { "Bugs", "Security Holes", "Backdoors" };

  double[][] data = null;
  public BarCharts()
  {
    data = TestDataGenerator.getRandomNumbers( 3, 7, 0, 5000 );
  }


//double[][] data= TestDataGenerator.getRandomNumbers( 1, 7, -5000, 6000 );
//  String[] lelegendLabels= { "Bugs" };

   public void set_xAxisTitle ( String xAxisTitle ) {
     this.xAxisTitle = xAxisTitle;
   }
   public String get_xAxisTitle () {
     return xAxisTitle;
   }

   public void set_yAxisTitle ( String yAxisTitle ) {
     this.yAxisTitle = yAxisTitle;
   }
   public String get_yAxisTitle () {
     return yAxisTitle;
   }

   public void set_Title ( String Title ) {
     this.title = Title;
   }
   public String get_Title () {
     return title;
   }

   public void set_xAxisLabels ( String[] xAxisLabels ) {
     this.xAxisLabels = xAxisLabels;
   }
   public String[] get_xAxisLabels () {
     return xAxisLabels;
   }

   public void set_legendLabels ( String[] legendLabels ) {
     this.legendLabels = legendLabels;
   }
   public String[] get_legendLabels () {
     return legendLabels;
   }

   public void set_Data ( double[][] data ) {
     this.data = data;
   }
   public double[][] get_Data () {
     return data;
   }


	/*****************************************************************************************
	*
	*
	******************************************************************************************/
	private AxisChart getBarChart( BarChartProperties barChartProperties ) throws ChartDataException
	{

		DataSeries dataSeries = new DataSeries( xAxisLabels, xAxisTitle, yAxisTitle, title );

		Paint[] paints= TestDataGenerator.getRandomPaints( legendLabels.length );

		AxisChartDataSet axisChartDataSet= new AxisChartDataSet( data, legendLabels, paints, ChartType.BAR, barChartProperties );

        dataSeries.addIAxisPlotDataSet(axisChartDataSet);

		ChartProperties chartProperties= new ChartProperties();
        AxisProperties axisProperties = new AxisProperties();

        double maxvalue = 0;
        double minvalue = 0;
        for ( int i=0; i<data[0].length; i++ )
        {
            if ( data[0][i] > maxvalue )
              maxvalue = data[0][i];

            if ( data[0][i] < minvalue )
              minvalue = data[0][i];
        }
        if ( minvalue < 0 )
          maxvalue = maxvalue - minvalue;
        int poweroftem = 0;
        if ( maxvalue < 10 )
          poweroftem = 0;
        else if ( maxvalue < 100 )
          poweroftem = 1;
        else if ( maxvalue < 1000 )
          poweroftem = 2;
        else if ( maxvalue < 10000 )
          poweroftem = 3;
        else if ( maxvalue < 100000 )
          poweroftem = 4;
        else if ( maxvalue < 1000000 )
          poweroftem = 5;
        else if ( maxvalue < 10000000 )
          poweroftem = 6;
        else if ( maxvalue < 100000000 )
          poweroftem = 7;
        else
          poweroftem = 8;

        axisProperties.setYAxisRoundValuesToNearest( poweroftem );

		LegendProperties legendProperties= new LegendProperties();

		AxisChart axisChart= new AxisChart( dataSeries, chartProperties, axisProperties, legendProperties, AxisCharts.width, AxisCharts.height );

		return axisChart;
	}


	/*****************************************************************************************
	*
	*
	******************************************************************************************/
	private AxisChart getMultiBarCharts( ChartType chartType, BarChartProperties barChartProperties ) throws ChartDataException
	{
		DataSeries dataSeries = new DataSeries( xAxisLabels, xAxisTitle, yAxisTitle, title );

		Paint[] paints= TestDataGenerator.getRandomPaints( legendLabels.length );

		AxisChartDataSet axisChartDataSet= new AxisChartDataSet( data, legendLabels, paints, chartType, barChartProperties );

                dataSeries.addIAxisPlotDataSet(axisChartDataSet);

		ChartProperties chartProperties= new ChartProperties();
		AxisProperties axisProperties= new AxisProperties();
		
        double maxvalue = 0;
        double minvalue = 0;
        for ( int i=0; i<data.length; i++ )
        {
			for ( int j=0; j<data[0].length; j++ )
			{
			    if ( data[i][j] > maxvalue )
			      maxvalue = data[i][j];

			    if ( data[i][j] < minvalue )
			      minvalue = data[i][j];
			}
        }
        if ( minvalue < 0 )
          maxvalue = maxvalue - minvalue;
        int poweroftem = 0;
        if ( maxvalue < 10 )
          poweroftem = 0;
        else if ( maxvalue < 100 )
          poweroftem = 1;
        else if ( maxvalue < 1000 )
          poweroftem = 2;
        else if ( maxvalue < 10000 )
          poweroftem = 3;
        else if ( maxvalue < 100000 )
          poweroftem = 4;
        else if ( maxvalue < 1000000 )
          poweroftem = 5;
        else if ( maxvalue < 10000000 )
          poweroftem = 6;
        else if ( maxvalue < 100000000 )
          poweroftem = 7;
        else
          poweroftem = 8;

        axisProperties.setYAxisRoundValuesToNearest( poweroftem );
		
		LegendProperties legendProperties= new LegendProperties();

		AxisChart axisChart= new AxisChart( dataSeries, chartProperties, axisProperties, legendProperties, AxisCharts.width, AxisCharts.height );

		return axisChart;
	}



	/******************************************************************************************/
	public void barChart( String filename ) throws ChartDataException
	{
		BarChartProperties barChartProperties= new BarChartProperties();
		AxisChart axisChart= this.getBarChart( barChartProperties );

		super.exportImage( axisChart, filename );
	}


	/**********************************************************************************************/
	public void stackedBars( String filename ) throws ChartDataException
	{
		StackedBarChartProperties stackedBarChartProperties= new StackedBarChartProperties();
		AxisChart axisChart= this.getMultiBarCharts( ChartType.BAR_STACKED, stackedBarChartProperties );

		super.exportImage( axisChart, filename );
	}


	/**********************************************************************************************/
	public void clusteredBars( String filename) throws ChartDataException
	{
		ClusteredBarChartProperties clusteredBarChartProperties= new ClusteredBarChartProperties();
		AxisChart axisChart= this.getMultiBarCharts( ChartType.BAR_CLUSTERED, clusteredBarChartProperties );

		super.exportImage( axisChart, filename );
	}



	/******************************************************************************************/
	public void barWidths( String filename ) throws ChartDataException
	{
		BarChartProperties barChartProperties= new BarChartProperties();
		barChartProperties.setWidthPercentage( 1f );

		AxisChart axisChart= this.getBarChart( barChartProperties );

		super.exportImage( axisChart, filename );
	}

	/******************************************************************************************/
	public void barOutlines( String filename ) throws ChartDataException
	{
		BarChartProperties barChartProperties= new BarChartProperties();
		barChartProperties.setShowOutlinesFlag( true );
		barChartProperties.setOutlinePaint( Color.red );
		barChartProperties.setOutlineStroke( new BasicStroke( 2.0f ) );

		AxisChart axisChart= this.getBarChart( barChartProperties );

		super.exportImage( axisChart, filename );
	}


}
