package com.jware.common.charts;

import java.awt.*;

import org.jCharts.chartData.*;
import org.jCharts.properties.*;
import org.jCharts.nonAxisChart.*;
import org.jCharts.test.TestDataGenerator;

public class PieCharts extends AxisCharts {

  String xAxisTitle= "Years";
  String yAxisTitle= "Problems";
  String title= "Micro$oft at Work";
  String[] xAxisLabels= { "1998", "1999", "2000", "2001", "2002", "2003", "2004" };
  String[] legendLabels= { "Bugs", "Security Holes", "Backdoors" };
  String[] labels= { "BMW", "Honda", "Lexus", "Audi", "Acura" };

  double[][] data = null;
  public PieCharts()
  {
    data = TestDataGenerator.getRandomNumbers( 3, 7, 0, 5000 );
  }

//double[][] data= TestDataGenerator.getRandomNumbers( 1, 7, -5000, 6000 );
//  String[] lelegendLabels= { "Bugs" };

		public void set_xAxisTitle ( String xAxisTitle ) {
		  this.xAxisTitle = xAxisTitle;
		}
		public String get_xAxisTitle () {
		  return xAxisTitle;
		}

		public void set_yAxisTitle ( String yAxisTitle ) {
		  this.yAxisTitle = yAxisTitle;
		}
		public String get_yAxisTitle () {
		  return yAxisTitle;
		}

		public void set_Title ( String Title ) {
		  this.title = Title;
		}
		public String get_Title () {
		  return title;
		}

		public void set_xAxisLabels ( String[] xAxisLabels ) {
		  this.xAxisLabels = xAxisLabels;
		}
		public String[] get_xAxisLabels () {
		  return xAxisLabels;
		}

		public void set_legendLabels ( String[] legendLabels ) {
		  this.legendLabels = legendLabels;
		}
		public String[] get_legendLabels () {
		  return legendLabels;
		}

		public void set_Data ( double[][] data ) {
		  this.data = data;
		}
		public double[][] get_Data () {
		  return data;
		}

		public void set_labels ( String[] labels ) {
		  this.labels = labels;
		}
		public String[] get_labels () {
		  return labels;
		}


	/******************************************************************************************/
	public void pieCharts( String filename ) throws ChartDataException
	{

		PieChart2DProperties properties = new PieChart2DProperties();
		
		LegendProperties legendProperties = new LegendProperties();
		legendProperties.setNumColumns( 1 );
		legendProperties.setPlacement( LegendProperties.RIGHT );
		
		ChartProperties chartProperties = new ChartProperties();

		Paint[] paints= TestDataGenerator.getRandomPaints( labels.length );
		
		PieChartDataSet pieChartDataSet = new PieChartDataSet( title, data[0], labels, paints, properties );

		PieChart2D pieChart2D= new PieChart2D( pieChartDataSet, legendProperties, chartProperties, width, height );

		super.exportImage( pieChart2D, filename );
		
	}

}
