package com.jware.util;

import java.util.ResourceBundle;

/**
 * @author jrmt
 * 
 */
public class ResourceUtility {

	private ResourceBundle resources = null;

	public final static String DEFAULT_RESOURCE = "java.resources.UtilResource";
	
	public ResourceUtility(){
		
		resources = ResourceBundle.getBundle( DEFAULT_RESOURCE );

	}
	public ResourceUtility( String resourceFile ){
		
		resources = ResourceBundle.getBundle( resourceFile );

	}

	/**
	 * @return Returns the resources.
	 */
	public ResourceBundle getResources() {
		return resources;
	}
	/**
	 * @param resources The resources to set.
	 */
	public void setResources(ResourceBundle resources) {
		this.resources = resources;
	}
	
	public String getResourceString( String key ) {
		
		String result = null;
		try {
			result = resources.getString( key );
		} catch ( Exception e ) {
			result = null;
		}

		return result;
	}
}
