package com.jware.util.mail;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author jrmt
 */
public class MailSenderThread extends Thread {
	
	private final Log log = LogFactory.getLog( this.getClass() );

	private BaseMailSender mailSender = null;

	/**
	 * 
	 */
	public MailSenderThread() {
		super();
	}

	/**
	 * 
	 */
	public MailSenderThread( BaseMailSender mailSender ) {
		super();
		this.mailSender = mailSender;
	}

	/**
	 * @param target
	 */
	public MailSenderThread(Runnable target) {
		super(target);
	}

	/**
	 * @param group
	 * @param target
	 */
	public MailSenderThread(ThreadGroup group, Runnable target) {
		super(group, target);
	}

	/**
	 * @param name
	 */
	public MailSenderThread(String name) {
		super(name);
	}

	/**
	 * @param group
	 * @param name
	 */
	public MailSenderThread(ThreadGroup group, String name) {
		super(group, name);
	}

	/**
	 * @param target
	 * @param name
	 */
	public MailSenderThread(Runnable target, String name) {
		super(target, name);
	}

	/**
	 * @param group
	 * @param target
	 * @param name
	 */
	public MailSenderThread(ThreadGroup group, Runnable target, String name) {
		super(group, target, name);
	}

	/**
	 * @param group
	 * @param target
	 * @param name
	 * @param stackSize
	 */
	public MailSenderThread(ThreadGroup group, Runnable target,
			String name, long stackSize) {
		super(group, target, name, stackSize);
	}
	
    public void run()
    {
        try
        {
        	if( mailSender != null ) {
        		int result = 0;
        		do {
        			result = mailSender.execute();
        			if( result > 0 ){
        				Thread.sleep( result );
        			}
        		} while( result > 0 );
        	}
        }
        catch(Exception exception)
        {
            exception.printStackTrace();
        }
    }
    
    public static boolean isTheThreadRunning( String name ) {
        
    	//  Find the root thread group
    	ThreadGroup root = Thread.currentThread().getThreadGroup().getParent();
	    while (root.getParent() != null) {
	        root = root.getParent();
	    }
	    
	    // Visit each thread group
	    return isTheThreadRunning(root, 0, name);
    	    
    }
        
    // This method recursively visits all thread groups under `group'.
    public static boolean isTheThreadRunning(ThreadGroup group, int level, String name) {

        boolean result = false;
        
        // Get threads in `group'
        int numThreads = group.activeCount();
        Thread[] threads = new Thread[numThreads*2];
        numThreads = group.enumerate(threads, false);
    
        // Enumerate each thread in `group'
        for (int i=0; i<numThreads; i++) {
            // Get thread
            Thread thread = threads[i];
            if( name.equals( thread.getName() ) ){
                result = true;
            }
        }
        
        if( !result ) {
	        // Get thread subgroups of `group'
	        int numGroups = group.activeGroupCount();
	        ThreadGroup[] groups = new ThreadGroup[numGroups*2];
	        numGroups = group.enumerate(groups, false);
	    
	        // Recursively visit each subgroup
	        for (int i=0; i<numGroups; i++) {
	            result = isTheThreadRunning(groups[i], level+1, name);
	            if( result ){
	                break;
	            }
	        }
        }
        return result;
   }
    
	/**
	 * @return Returns the mailSender.
	 */
	public BaseMailSender getMailSender() {
		return mailSender;
	}
	/**
	 * @param mailSender The mailSender to set.
	 */
	public void setMailSender(BaseMailSender mailSender) {
		this.mailSender = mailSender;
	}
	
}
