/**
 * Copyright 2005 Darren L. Spurgeon
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ajaxtags.demo.servlet;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.ajaxtags.demo.CarService;
import org.ajaxtags.helpers.AjaxXmlBuilder;
import org.ajaxtags.servlets.BaseAjaxServlet;

/**
 * An example servlet that responds to an ajax:select tag action. This servlet would be referenced
 * by the baseUrl attribute of the JSP tag.
 * 
 * @author Darren L. Spurgeon
 * @version $Revision: 1.1 $ $Date: 2008/09/30 12:26:45 $
 */
public class DropdownServlet extends BaseAjaxServlet {

  /**
   * @see org.ajaxtags.demo.servlet.BaseAjaxServlet#getXmlContent(javax.servlet.http.HttpServletRequest,
   *      javax.servlet.http.HttpServletResponse)
   */
  public String getXmlContent(HttpServletRequest request, HttpServletResponse response)
      throws Exception {
    String make = request.getParameter("make");

    // Get maker from your service bean
    CarService service = new CarService();
    List list = service.getModelsByMake(make);

    return new AjaxXmlBuilder().addItems(list, "model", "make").toString();
  }

}
