<%--
 * Copyright 2005 Darren L. Spurgeon
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
--%>
<%@ page language="java" contentType="text/html; charset=ISO-8859-1" pageEncoding="ISO-8859-1"%>

<jsp:include page="header.jsp" flush="true" />

<h1>Demos</h1>

<div style="width: 650px; font-size: 90%">
  <p>
    The AJAX Tag Library is a set of JSP tags that simplify the use of Asynchronous JavaScript and
    XML (AJAX) technology in JavaServer Pages.
  </p>
  <p>
    The following examples should give a basic overview of how the current set of AJAX JSP tags can
    be used in near real-world scenarios. You can not only run each example, but you can view the
    JSP and backend servlet source code.
  </p>
</div>

<div>

<table cellpadding="6" cellspacing="0" border="0" id="homepageTable">
  <thead>
    <tr valign="top">
      <th width="200">Tag Name</th>
      <th width="200">Run</th>
      <th width="200">Jsp Source</th>
      <th width="200">Java Source</th>
    </tr>
  </thead>
  <tbody>
    <tr valign="top" class="description">
      <td colspan="2" style="font-size: 70%; padding-bottom: 5px;">&nbsp;</td>
      <td align="center" style="font-size: 70%; padding-bottom: 5px;">
        <a href="${contextPath}/ampiere/ajax/txt/jsp/header.jsp.txt">header.jsp</a> |
        <a href="${contextPath}/ampiere/ajax/txt/jsp/footer.jsp.txt">footer.jsp</a>
      </td>
      <td align="center" style="font-size: 70%; padding-bottom: 5px;">
        <a href="${contextPath}/ampiere/ajax/src/org/ajaxtags/demo/servlet/BaseAjaxServlet.java">BaseAjaxServlet.java</a>
      </td>
    </tr>
    <tr valign="top">
      <td>Auto-Complete</td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/autocomplete.jsp">Run</a></td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/txt/jsp/autocomplete.jsp.txt">Jsp</a></td>
      <td align="center"><a
        href="${contextPath}/ampiere/ajax/src/org/ajaxtags/demo/servlet/AutocompleteServlet.java">Java</a></td>
    </tr>
    <tr valign="top" class="description">
      <td colspan="4">Retrieves a list of values that matches the string entered in a text form
      field as the user types.</td>
    </tr>
    <tr valign="top">
      <td>Callout</td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/callout.jsp">Run</a></td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/txt/jsp/callout.jsp.txt">Jsp</a></td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/src/org/ajaxtags/demo/servlet/CalloutServlet.java">Java</a></td>
    </tr>
    <tr valign="top" class="description">
      <td colspan="4">Displays a callout or popup balloon, anchored to an HTML element with an
      onclick event.</td>
    </tr>
    <tr valign="top">
      <td>Form Update</td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/formupdate.jsp">Run</a></td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/txt/jsp/formupdate.jsp.txt">Jsp</a></td>
      <td align="center"><a
        href="${contextPath}/ampiere/ajax/src/org/ajaxtags/demo/servlet/FormUpdateServlet.java">Java</a></td>
    </tr>
    <tr valign="top" class="description">
      <td colspan="4">Updates one or more form field values based on response to text entered in
      another field.</td>
    </tr>
    <tr valign="top">
      <td>HtmlContent</td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/htmlcontent.jsp">Run</a></td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/txt/jsp/htmlcontent.jsp.txt">Jsp</a></td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/src/org/ajaxtags/demo/servlet/HtmlContentServlet.java">Java</a></td>
    </tr>
    <tr valign="top" class="description">
      <td colspan="4">Fills a content area (e.g., DIV tag) with the HTML from another source</td>
    </tr>
    <tr valign="top">
      <td>Portlet</td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/portlet.jsp">Run</a></td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/txt/jsp/portlet.jsp.txt">Jsp</a></td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/src/org/ajaxtags/demo/servlet/PortletServlet.java">Java</a></td>
    </tr>
    <tr valign="top" class="description">
      <td colspan="4">
        Mimics a portlet (in the <a href="http:/www.jcp.org/en/jsr/detail?id=168">JSR-168</a>
        sense) by allowing you to define a portion of the page that pulls content from another
        location using Ajax with or without a periodic refresh.
      </td>
    </tr>
    <tr valign="top">
      <td>Select/Dropdown</td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/dropdown.jsp">Run</a></td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/txt/jsp/dropdown.jsp.txt">Jsp</a></td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/src/org/ajaxtags/demo/servlet/DropdownServlet.java">Java</a></td>
    </tr>
    <tr valign="top" class="description">
      <td colspan="4">Based on a selection within a dropdown field, a second select field will be
      populated.</td>
    </tr>
    <tr valign="top">
      <td>Tab Panel</td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/tabpanel.jsp">Run</a></td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/txt/jsp/tabpanel.jsp.txt">Jsp</a></td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/src/org/ajaxtags/demo/servlet/HtmlContentServlet.java">Java</a></td>
    </tr>
    <tr valign="top" class="description">
      <td colspan="4">Provides a tabbed page view of content from different resources</td>
    </tr>
    <tr valign="top">
      <td>Toggle</td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/toggle.jsp">Run</a></td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/txt/jsp/toggle.jsp.txt">Jsp</a></td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/src/org/ajaxtags/demo/servlet/ToggleServlet.java">Java</a></td>
    </tr>
    <tr valign="top" class="description">
      <td colspan="4">Switches a hidden form field between true and false and at the same time
      switches an image between two sources.</td>
    </tr>
    <tr valign="top">
      <td>Area and Anchor</td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/pagearea.jsp">Run</a></td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/txt/jsp/pagearea.jsp.txt">Jsp</a></td>
      <td align="center">N/A</td>
    </tr>
    <tr valign="top" class="description">
      <td colspan="4">Shows how to AJAX-enable any area of your page</td>
    </tr>
    <tr valign="top">
      <td>Ajax DisplayTag</td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/displaytag.jsp">Run</a></td>
      <td align="center"><a href="${contextPath}/ampiere/ajax/txt/jsp/displaytag.jsp.txt">Jsp</a></td>
      <td align="center">N/A</td>
    </tr>
    <tr valign="top" class="description">
      <td colspan="4">Shows how to AJAX-enable DisplayTag</td>
    </tr>
  </tbody>
</table>

</div>

<jsp:include page="footer.jsp" flush="true" />
