<%-- 
 * Copyright 2005 Darren L. Spurgeon
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
--%>
<%@ page language="java" contentType="text/html; charset=ISO-8859-1" pageEncoding="ISO-8859-1"%>
<%@ taglib uri="http://ajaxtags.org/tags/ajax" prefix="ajax" %>

<jsp:include page="header.jsp" flush="true" />

<h1>Toggle Tag Demo</h1>
<div style="margin-top: 0px; padding-top: 0px; font-size: 70%">
  <a href="${contextPath}/ajax/txt/jsp/toggle.jsp.txt">JSP source</a>
  | <a href="${contextPath}/ajax/src/org/ajaxtags/demo/servlet/ToggleServlet.java">Java source</a>
</div>

<div style="font-size: 90%; width: 650px;">
  <p>
    The <code>ajax:toggle</code> tag is the perfect way to implement a rating system or single
    on/off switch.  In addition to the visual, you can also elect to store the value in a hidden
    form field.
  </p>
  <p>
    This tag is fairly simple and could be powerful all at the same time.  We envision one could use
    this in a variety of cases such as checking/unchecking recordsets.
  </p>
</div>

<script type="text/javascript">
 /*
  * USER DEFINED FUNCTIONS
  */

function initProgress() {
}

function resetProgress(request) {
}

function reportError() {
}
</script>

<div>
  <h3>Toggle Using Stars</h3>
  <form id="toggleForm" action=".">
    <input type="hidden" id="raterField" />
  </form>

  <h4>AJAX Rating System <span style="font:normal 8pt Verdana;">[${toggleRating}]</span></h4>
  <ajax:toggle
    baseUrl="${pageContext.request.contextPath}/toggle.view"
    source="rater1"
    ratings="One,Two,Three,Four,Five"
    defaultRating="${toggleRating}"
    containerClass="star-rating"
    messageClass="star-rating-message"
    selectedClass="selected"
    selectedOverClass="selectedover"
    selectedLessClass="selectedless"
    overClass="over"
    onOff="false"
    state="raterField"
    preFunction="initProgress"
    postFunction="resetProgress"
    errorFunction="reportError"
    />

  <br style="clear:both;display:block"/><br/>
  <h4>On/Off Toggle <span style="font:normal 8pt Verdana;">[${toggleRatingOnOff}]</span></h4>
  <ajax:toggle
    baseUrl="${pageContext.request.contextPath}/toggle.view"
    source="rater2"
    ratings="On,Off"
    defaultRating="${toggleRatingOnOff}"
    containerClass="star-rating"
    selectedClass="selected"
    selectedOverClass="selectedover"
    selectedLessClass="selectedless"
    overClass="over"
    onOff="true"
    state="raterField"
    preFunction="initProgress"
    postFunction="resetProgress"
    errorFunction="reportError"
    />

    <br style="clear:both;display:block"/><br/>
</div>

<jsp:include page="footer.jsp" flush="true" />
