CREATE TABLE COMPIERE.X_POSTCODE ( 
	X_POSTCODE_ID					NUMBER(10)		NOT NULL,
	AD_CLIENT_ID					NUMBER(10)		NOT NULL,
	AD_ORG_ID						NUMBER(10)		NOT NULL,
	ISACTIVE						CHAR(1)			DEFAULT 'Y' 	NOT NULL,
	CREATED							DATE			DEFAULT SYSDATE 	NOT NULL,
	CREATEDBY						NUMBER(10)		NOT NULL,
	UPDATED							DATE			DEFAULT SYSDATE 	NOT NULL,
	UPDATEDBY						NUMBER(10)		NOT NULL,
	C_COUNTRY_ID					NUMBER(10),
	C_REGION_ID						NUMBER(10), 
	AREACODE						VARCHAR2(10),
	OLDZIP							VARCHAR2(10)	NOT NULL,
	POSTAL							VARCHAR2(10)	NOT NULL,
	X_REGION_NAME_KANA				VARCHAR2(120),
	X_CITY_NAME_KANA				VARCHAR2(120),
	X_ADDRESS_KANA					VARCHAR2(120),
	X_REGION_NAME					VARCHAR2(120),
	X_CITY_NAME						VARCHAR2(120),
	X_ADDRESS						VARCHAR2(120),
	IS_DUPLICATE					CHAR(1)			DEFAULT '0' 	NOT NULL,
	IS_RECURSIVE					CHAR(1)			DEFAULT '0' 	NOT NULL,
	IS_INCLUDE_ADDRNO  				CHAR(1)			DEFAULT '0' 	NOT NULL,
	IS_MULTI_ZIP					CHAR(1)			DEFAULT '0' 	NOT NULL,
	IS_UPDATED						CHAR(1)			DEFAULT '0' 	NOT NULL,
	UPDATE_REASON					CHAR(1)			DEFAULT '0' 	NOT NULL,
	CONSTRAINT XCOUNTRY_XPOSTCODE FOREIGN KEY(C_COUNTRY_ID) REFERENCES COMPIERE.C_COUNTRY (C_COUNTRY_ID) , 
	CONSTRAINT XPREGION_XPOSTCODE FOREIGN KEY(C_REGION_ID) REFERENCES COMPIERE.C_REGION (C_REGION_ID) , 
	CONSTRAINT X_POSTCODECLIENT FOREIGN KEY(AD_CLIENT_ID) REFERENCES COMPIERE.AD_CLIENT (AD_CLIENT_ID) , 
	CONSTRAINT X_POSTCODEORG FOREIGN KEY(AD_ORG_ID) REFERENCES COMPIERE.AD_ORG (AD_ORG_ID) , 
	CONSTRAINT X_POSTCODE_KEY PRIMARY KEY(X_POSTCODE_ID), 
	CHECK(IsActive in ('Y','N')) 
)
/
