CREATE OR REPLACE VIEW M_MOVEMENTLINEMA_V
	(AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, 
	UPDATEDBY, AD_LANGUAGE, M_MOVEMENT_ID, M_MOVEMENTLINE_ID, 
	LINE, M_PRODUCT_ID, M_ATTRIBUTESETINSTANCE_ID, 
	MOVEMENTQTY, M_LOCATOR_ID, M_LOCATORTO_ID) 
AS 
SELECT m.AD_Client_ID AS AD_Client_ID, m.AD_Org_ID AS AD_Org_ID, m.IsActive AS IsActive,
    m.Created AS Created, m.CreatedBy AS CreatedBy, m.Updated AS Updated, m.UpdatedBy AS UpdatedBy,
    CAST('en_US' AS VARCHAR(5)) AS AD_Language,
    l.M_Movement_ID AS M_Movement_ID, m.M_MovementLine_ID AS M_MovementLine_ID, l.Line AS Line, 
    l.M_Product_ID AS M_Product_ID,
    m.M_AttributeSetInstance_ID AS M_AttributeSetInstance_ID, m.MovementQty AS MovementQty,
    l.M_Locator_ID AS M_Locator_ID, l.M_LocatorTo_ID AS M_LocatorTo_ID 
FROM  M_MovementLineMA m INNER JOIN M_MovementLine l ON (m.M_MovementLine_ID=l.M_MovementLine_ID)  
UNION 
SELECT AD_Client_ID AS AD_Client_ID, AD_Org_ID AS AD_Org_ID, IsActive AS IsActive,
    Created AS Created, CreatedBy AS CreatedBy, Updated AS Updated, UpdatedBy AS UpdatedBy,
    CAST('en_US' AS VARCHAR(5)) AS AD_Language,
    M_Movement_ID AS M_Movement_ID, M_MovementLine_ID AS M_MovementLine_ID, Line AS Line, M_Product_ID AS M_Product_ID,
    M_AttributeSetInstance_ID AS M_AttributeSetInstance_ID, MovementQty AS MovementQty,
    M_Locator_ID AS M_Locator_ID, M_LocatorTo_ID AS M_LocatorTo_ID 
FROM  M_MovementLine 
/
