/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package compiere.process;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;

import compiere.model.X_I_Postal;
import compiere.model.X_X_Postal;

import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

/**
 *	Import Postal Code fom I_Postal
 *
 * 	@author 	jrmt 2006-2007
 * 	@version 	$Id: ImportPostal.java,v 1.1.2.1 2009/03/30 11:56:33 jrmt Exp $
 */
public class ImportPostal extends SvrProcess
{
	/**	Client to be imported to		*/
	private int				p_AD_Client_ID = 0;
	/**	Delete old Imported				*/
	private boolean			p_DeleteOldImported = false;

	/**
	 *  Prepare - e.g., get Parameters.
	 */
	protected void prepare()
	{
		ProcessInfoParameter[] para = getParameter();
		for (int i = 0; i < para.length; i++)
		{
			String name = para[i].getParameterName();
			if (para[i].getParameter() == null)
				;
			else if (name.equals("AD_Client_ID"))
				p_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
			else if (name.equals("DeleteOldImported"))
				p_DeleteOldImported = "Y".equals(para[i].getParameter());
			else
				log.log(Level.SEVERE, "Unknown Parameter: " + name);
		}
	}	//	prepare


	/**
	 *  Perrform process.
	 *  @return Message
	 *  @throws Exception
	 */
	protected String doIt() throws java.lang.Exception
	{
		//
		StringBuffer sql = null;
		int no = 0;
		String clientCheck = " AND AD_Client_ID=" + p_AD_Client_ID;

		//	Delete Old Imported
		if (p_DeleteOldImported)
		{
			sql = new StringBuffer ("DELETE I_Postal "
				  + "WHERE I_IsImported='Y'").append (clientCheck);
			no = DB.executeUpdate (sql.toString (), get_TrxName());
			log.fine("Delete Old Impored =" + no);
		}

		sql = new StringBuffer ("UPDATE I_Postal"
				+" set X_ADDRESS_KANA = '', X_ADDRESS ='' where X_ADDRESS like '以下に掲載がない場合%'");
		no = DB.executeUpdate (sql.toString (), get_TrxName());
		log.fine("Set X_ADDRESS Blank=" + no);

		//	Region Default
		sql = new StringBuffer ("UPDATE I_Postal i "	//	Default Region
			  + "SET C_Region_ID=(SELECT MIN(C_Region_ID) FROM C_Region r "
			  + " WHERE i.X_Region_Name=r.Name AND i.AD_Client_ID=r.AD_Client_ID) "
			  + "WHERE C_Region_ID IS NULL AND I_IsImported<>'Y'").append (clientCheck);
		no = DB.executeUpdate(sql.toString(), get_TrxName());
		log.fine("Set C_Region_ID=" + no);
		
		String ts = DB.isPostgreSQL() ? 
				"COALESCE(I_ErrorMsg,'')"
				: "I_ErrorMsg";  //java bug, it could not be used directly
		sql = new StringBuffer ("UPDATE I_Postal "	// No DocType
				  + "SET I_IsImported='E', I_ErrorMsg="+ts +"||'ERR=No C_Region_ID, ' "
				  + "WHERE C_Region_ID IS NULL"
				  + " AND I_IsImported<>'Y'").append (clientCheck);
		no = DB.executeUpdate(sql.toString(), get_TrxName());
		if (no != 0)
			log.warning ("No C_Region_ID=" + no);
		
		//	Region Default
		sql = new StringBuffer ("UPDATE I_Postal i "	//	Default Region
			  + "SET C_Country_ID=(SELECT MIN(C_Country_ID) FROM C_Region r "
			  + " WHERE i.X_Region_Name=r.Name AND i.AD_Client_ID=r.AD_Client_ID) "
			  + "WHERE C_Country_ID IS NULL AND I_IsImported<>'Y'").append (clientCheck);
		no = DB.executeUpdate(sql.toString(), get_TrxName());
		log.fine("Set C_Country_ID=" + no);
		
		sql = new StringBuffer ("UPDATE I_Postal "	// No DocType
				  + "SET I_IsImported='E', I_ErrorMsg="+ts +"||'ERR=No C_Country_ID, ' "
				  + "WHERE C_Country_ID IS NULL"
				  + " AND I_IsImported<>'Y'").append (clientCheck);
		no = DB.executeUpdate(sql.toString(), get_TrxName());
		if (no != 0)
			log.warning ("No C_Country_ID=" + no);
		
		log.fine("Set Postal ID DocType=" + no);
		
		commit();
		
		/*********************************************************************/

		int noInsert = 0;
		//	Go through Postal Records
		sql = new StringBuffer ("SELECT i.I_POSTAL_ID, i.AD_CLIENT_ID, i.AD_ORG_ID, i.ISACTIVE, i.CREATED, "
				+ " i.CREATEDBY, i.UPDATED, i.UPDATEDBY, i.C_COUNTRY_ID, i.C_REGION_ID, i.I_ERRORMSG, "
				+ " i.I_ISIMPORTED, i.AREACODE, i.OLDZIP, i.POSTAL, p.X_POSTAL_ID, "
				+ " i.X_REGION_NAME_KANA, i.X_CITY_NAME_KANA, i.X_ADDRESS_KANA, i.X_REGION_NAME, "
				+ " i.X_CITY_NAME, i.X_ADDRESS, i.IS_DUPLICATE, i.IS_RECURSIVE, i.IS_INCLUDE_ADDRNO, "
				+ " i.IS_MULTI_ZIP, i.IS_UPDATED, i.UPDATE_REASON, i.PROCESSED, i.PROCESSING " 
				+ " FROM I_Postal i LEFT OUTER JOIN X_Postal p " +
				" ON (p.Postal=i.Postal AND p.AD_Client_ID=i.AD_Client_ID) WHERE i.I_IsImported='N' AND i.IsActive='Y' ");
		sql.append( " AND i.AD_Client_ID=" + p_AD_Client_ID );
		
		try
		{
			PreparedStatement pstmt = DB.prepareStatement (sql.toString (), get_TrxName());
			ResultSet rs = pstmt.executeQuery ();
			//
			while (rs.next())
			{
				X_I_Postal imp = new X_I_Postal (getCtx (), rs, get_TrxName());
				X_X_Postal postal = null;
				if( imp.getX_Postal_ID() != 0 )
					postal = new X_X_Postal (getCtx (), imp.getX_Postal_ID(), get_TrxName());
				else 
					postal = new X_X_Postal (getCtx (), 0, get_TrxName());
				
			    postal.setC_Country_ID(imp.getC_Country_ID());
			    postal.setC_Region_ID(imp.getC_Region_ID());
			    postal.setAreaCode(imp.getAreaCode());
			    postal.setOldzip(imp.getOldzip());
			    postal.setPostal(imp.getPostal());
			    postal.setX_Region_Name_Kana(imp.getX_Region_Name_Kana());
			    postal.setX_City_Name_Kana(imp.getX_City_Name_Kana());
			    postal.setX_Address_Kana(imp.getX_Address_Kana());
			    postal.setX_Region_Name(imp.getX_Region_Name());
			    postal.setX_City_Name(imp.getX_City_Name());
			    postal.setX_Address(imp.getX_Address());
			    postal.setIs_Duplicate("1".equals(imp.getIs_Duplicate()));
			    postal.setIs_Recursive("1".equals(imp.getIs_Recursive()));
			    postal.setIs_Include_Addrno("1".equals(imp.getIs_Include_Addrno()));
			    postal.setIs_Multi_Zip("1".equals(imp.getIs_Multi_Zip()));
			    postal.setIs_Updated("1".equals(imp.getIs_Updated()));
			    postal.setUpdate_Reason(imp.getUpdate_Reason());
				if (!postal.save()){
					sql = new StringBuffer ("UPDATE I_Postal "
							+ "SET I_IsImported='N', Updated=SysDate WHERE I_Postal_ID="+imp.getI_Postal_ID());
					no = DB.executeUpdate(sql.toString(), get_TrxName());
					log.warning("get Error on saving Postal=" + imp.getPostal());
				} else {
					imp.setI_IsImported(true);
					imp.setProcessed(true);
				}
				imp.save();
				noInsert++;

				}
			rs.close();
			pstmt.close();
		}
		catch (Exception e)
		{
			log.log(Level.SEVERE, sql.toString(), e);
		}

		//	Set Error to indicator to not imported
		addLog (0, null, new BigDecimal (noInsert), "@OK@");
		return "";
	}	//	doIt

}	//	ImportPostalCode
