/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package compiere.process;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;

import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

import compiere.model.X_I_PrintFormatItem;

/**
 *	Create print format from I_PrintFormatItem
 *
 * 	@author 	Jirimuto
 * 	@version 	$Id: ImportPrintFormat.java,v 1.1 2008/07/29 16:13:33 jrmt Exp $
 */
public class ImportPrintFormat extends SvrProcess
{
	/**	Client to be imported to		*/
	private int				m_AD_Client_ID = 0;
	/**	Organization to be imported to		*/
	private int				m_AD_Org_ID = 0;
	/**	Delete old Imported				*/
	private boolean			m_deleteOldImported = false;

	private String				m_PrintFormat;

	/** Effective						*/
	private Timestamp		m_DateValue = null;

	private Ctx 		m_ctx;
	/**
	 *  Prepare - e.g., get Parameters.
	 */
	private int printFormatID =0;
 
	
	protected void prepare()
	{
		m_ctx = getCtx();
		ProcessInfoParameter[] para = getParameter();
		for (int i = 0; i < para.length; i++)
		{
			String name = para[i].getParameterName();
			if (name.equals("AD_Client_ID"))
				m_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
			else if (name.equals("AD_Org_ID"))
				m_AD_Org_ID = ((BigDecimal)para[i].getParameter()).intValue();
			else if (name.equals("DeleteOldImported"))
				m_deleteOldImported = "Y".equals(para[i].getParameter());
			else if (name.equals("FormatName"))
				m_PrintFormat = ((String)para[i].getParameter());
			else
				log.log(Level.SEVERE, "Unknown Parameter: " + name);
		}
		if (m_DateValue == null)
			m_DateValue = new Timestamp (System.currentTimeMillis());
	}	//	prepare


	/**
	 *  Perrform process.
	 *  @return Message
	 *  @throws Exception
	 */
	protected String doIt() throws java.lang.Exception
	{
		log.info("");
		StringBuffer sql = null;
		int errNo = 0;	
		int no = 0;	
		String clientCheck = " AND AD_Client_ID=" + m_AD_Client_ID;

		//	Delete Old Imported
		if (m_deleteOldImported)
		{
			sql = new StringBuffer ("DELETE I_PrintFormatItem "
				  + "WHERE I_IsImported='Y'").append (clientCheck);
			no = DB.executeUpdate(sql.toString(), get_TrxName());
			log.fine("Delete Old Impored =" + no);
		}
		//	****	Prepare	****

		//	Set Client, Org, IsActive, Created/Updated
		sql = new StringBuffer ("UPDATE I_PrintFormatItem "
			  + "SET AD_Client_ID = COALESCE (AD_Client_ID,").append (m_AD_Client_ID).append ("),"
			  + " AD_Org_ID = COALESCE (AD_Org_ID,").append (m_AD_Org_ID).append ("),");
		sql.append(" IsActive = COALESCE (IsActive, 'Y'),"
			  + " Created = COALESCE (Created, SysDate),"
			  + " CreatedBy = COALESCE (CreatedBy, 0),"
			  + " Updated = COALESCE (Updated, SysDate),"
			  + " UpdatedBy = COALESCE (UpdatedBy, 0),"
			  + " I_ErrorMsg = NULL,"
			  + " I_IsImported = 'N' "
			  + "WHERE I_IsImported<>'Y' OR I_IsImported IS NULL").append (clientCheck);
		if(m_PrintFormat != null ){
			sql.append( " AND FORMATNAME=" + "'"+m_PrintFormat+"'"); 
		}
		no = DB.executeUpdate(sql.toString(), get_TrxName());
		log.info ("Reset=" + no);

		sql = new StringBuffer ("UPDATE I_PrintFormatItem o "
			+ "SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Org, '"
			+ "WHERE (AD_Org_ID IS NULL"
			+ " OR EXISTS (SELECT * FROM AD_Org oo WHERE o.AD_Org_ID=oo.AD_Org_ID AND (oo.IsSummary='Y' OR oo.IsActive='N')))"
			+ " AND I_IsImported<>'Y'").append (clientCheck);
		no = DB.executeUpdate(sql.toString(), get_TrxName());
		errNo += no;
		if (no != 0)
			log.warning ("Invalid Org=" + no);
			
		//	Set Table ID
		sql = new StringBuffer("SELECT a.AD_TABLE_ID "
		+ " FROM AD_TABLE a "
		+ " WHERE a.TableName =(select TableName from I_PrintFormatItem i "
		+ " WHERE ((i.I_IsImported<>'Y' "
		+ " OR i.I_IsImported IS NULL) and (i.TableName IS NOT NULL) and rownum=1))");

		no = DB.executeUpdate(sql.toString(), get_TrxName());
        if (no!=0)
        {
			sql = new StringBuffer("UPDATE I_PrintFormatItem i "
				+ "SET i.AD_TABLE_ID="
				+ "( "
				+ " SELECT a.AD_TABLE_ID "
				+ " FROM AD_TABLE a "
				+ " WHERE a.TableName=i.TableName "
				+ ") "
				+ "WHERE (i.I_IsImported<>'Y' "
				+ "OR i.I_IsImported IS NULL)").append(clientCheck);
			if(m_PrintFormat != null ){
				sql.append( " AND FORMATNAME=" + "'"+m_PrintFormat+"'"); 
		}
		no = DB.executeUpdate(sql.toString(), get_TrxName());
        }
		if (no != 0)
			log.info("AD_Table_ID=" + no);
		commit();
		//
		sql = new StringBuffer("UPDATE I_PrintFormatItem "
			+ "SET I_isImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Table Name, ' "
			+ "WHERE AD_TABLE_ID IS NULL "
			+ "AND (I_isImported<>'Y' "
			+ "OR I_isImported IS NULL)").append(clientCheck);
		if(m_PrintFormat != null ){
			sql.append( " AND FORMATNAME=" + "'"+m_PrintFormat+"'"); 
		}
		no = DB.executeUpdate(sql.toString(), get_TrxName());
		errNo += no;
		if (no != 0)
			log.warning("Invalid Table Name=" + no);
		 
		//	Set Column ID
		sql = new StringBuffer("UPDATE I_PrintFormatItem i "
				+ "SET i.AD_COLUMN_ID="
				+ "( "
				+ " SELECT a.AD_COLUMN_ID "
				+ " FROM AD_COLUMN a "
				+ " WHERE a.COLUMNNAME=i.COLUMNNAME "
				+ " AND a.AD_TABLE_ID=i.AD_TABLE_ID"
				+ ") "
				+ "WHERE (i.I_IsImported<>'Y' "
				+ "OR i.I_IsImported IS NULL) AND (i.AD_Column_ID IS NULL or i.AD_Column_ID =0)").append(clientCheck);
		if(m_PrintFormat != null ){
			sql.append( " AND i.FORMATNAME=" + "'"+m_PrintFormat+"'"); 
		}
		no = DB.executeUpdate(sql.toString(), get_TrxName());
		if (no != 0)
			log.info("Set Column=" + no);
		//
		sql = new StringBuffer ("UPDATE I_PrintFormatItem "
			+ "SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Column,' "
			+ "WHERE AD_Column_ID IS NULL AND COLUMNNAME IS NOT NULL "
			+ "AND I_IsImported<>'E' "
			+ " AND I_IsImported<>'Y'").append(clientCheck);
		if(m_PrintFormat != null ){
			sql.append( " AND FORMATNAME=" + "'"+m_PrintFormat+"'"); 
		}
		no = DB.executeUpdate(sql.toString(), get_TrxName());
		errNo += no;
		if (no != 0)
			log.warning("Invalid Column=" + no);
		
		//set PrintPaper
		sql = new StringBuffer("UPDATE I_PrintFormatItem i "
				+ "SET i.AD_PRINTPAPER_ID="
				+ "( "
				+ " SELECT a.AD_PRINTPAPER_ID "
				+ " FROM AD_PRINTPAPER a "
				+ " WHERE a.NAME=i.PRINTPAPER "
				+ ") "
				+ "WHERE (i.I_IsImported<>'Y' "
				+ "OR i.I_IsImported IS NULL)").append(clientCheck);
		if(m_PrintFormat != null ){
			sql.append( " AND i.FORMATNAME=" + "'"+m_PrintFormat+"'"); 
		}
		no = DB.executeUpdate(sql.toString(), get_TrxName());
		if (no != 0)
			log.info("Set Printpaper=" + no);
		//
		sql = new StringBuffer ("UPDATE I_PrintFormatItem "
			+ "SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Printpaper,' "
			+ "WHERE AD_PRINTPAPER_ID IS NULL "
			+ "AND I_IsImported<>'E' "
			+ " AND I_IsImported<>'Y'").append(clientCheck);
		if(m_PrintFormat != null ){
			sql.append( " AND FORMATNAME=" + "'"+m_PrintFormat+"'"); 
		}
		no = DB.executeUpdate(sql.toString(), get_TrxName());
		errNo += no;
		if (no != 0)
			log.warning("Invalid PrintPaper=" + no);
		
		//Set PrintColor
		sql = new StringBuffer("UPDATE I_PrintFormatItem i "
				+ "SET i.AD_PRINTCOLOR_ID="
				+ "( "
				+ " SELECT a.AD_PRINTCOLOR_ID "
				+ " FROM AD_PRINTCOLOR a "
				+ " WHERE a.NAME=i.PRINTCOLOR "
				+ ") "
				+ "WHERE (i.I_IsImported<>'Y' "
				+ "OR i.I_IsImported IS NULL)").append(clientCheck);
		if(m_PrintFormat != null ){
			sql.append( " AND i.FORMATNAME=" + "'"+m_PrintFormat+"'"); 
		}
		no = DB.executeUpdate(sql.toString(), get_TrxName());
		if (no != 0)
			log.info("Set PrintColor=" + no);
		//
		sql = new StringBuffer ("UPDATE I_PrintFormatItem "
			+ "SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid PrintColor,' "
			+ "WHERE AD_PRINTCOLOR_ID IS NULL "
			+ "AND I_IsImported<>'E' "
			+ " AND I_IsImported<>'Y'").append(clientCheck);
		if(m_PrintFormat != null ){
			sql.append( " AND FORMATNAME=" + "'"+m_PrintFormat+"'"); 
		}
		no = DB.executeUpdate(sql.toString(), get_TrxName());
		errNo += no;
		if (no != 0)
			log.warning("Invalid PrintColor=" + no);
		
		//Set PrintFont
		sql = new StringBuffer("UPDATE I_PrintFormatItem i "
				+ "SET i.AD_PRINTFONT_ID="
				+ "( "
				+ " SELECT a.AD_PRINTFONT_ID "
				+ " FROM AD_PRINTFONT a "
				+ " WHERE a.NAME=i.PRINTFONT "
				+ ") "
				+ "WHERE (i.I_IsImported<>'Y' "
				+ "OR i.I_IsImported IS NULL)").append(clientCheck);
		if(m_PrintFormat != null ){
			sql.append( " AND i.FORMATNAME=" + "'"+m_PrintFormat+"'"); 
		}
		no = DB.executeUpdate(sql.toString(), get_TrxName());
		if (no != 0)
			log.info("Set PrintFont=" + no);
		//
		sql = new StringBuffer ("UPDATE I_PrintFormatItem "
			+ "SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid PrintColor,' "
			+ "WHERE AD_PRINTFONT_ID IS NULL "
			+ "AND I_IsImported<>'E' "
			+ " AND I_IsImported<>'Y'").append(clientCheck);
		if(m_PrintFormat != null ){
			sql.append( " AND FORMATNAME=" + "'"+m_PrintFormat+"'"); 
		}
		no = DB.executeUpdate(sql.toString(), get_TrxName());
		errNo += no;
		if (no != 0)
			log.warning("Invalid PrintFont=" + no);
		
		//Set PrintFormatChild
		sql = new StringBuffer("UPDATE I_PrintFormatItem i "
				+ "SET i.AD_PRINTFORMATCHILD_ID="
				+ "( "
				+ " SELECT a.AD_PRINTFORMAT_ID "
				+ " FROM AD_PRINTFORMAT a "
				+ " WHERE a.NAME=i.PRINTFORMATCHILD "
				+ ") "
				+ "WHERE ((i.I_IsImported<>'Y' "
				+ "OR i.I_IsImported IS NULL) and i.PRINTFORMATCHILD is not null)").append(clientCheck);
		if(m_PrintFormat != null ){
			sql.append( " AND i.FORMATNAME=" + "'"+m_PrintFormat+"'"); 
		}
		no = DB.executeUpdate(sql.toString(), get_TrxName());
		if (no != 0)
			log.info("Set PrintFormatChild=" + no);
		
		//Set PrintGraph
		sql = new StringBuffer("UPDATE I_PrintFormatItem i "
				+ "SET i.AD_PRINTGRAPH_ID="
				+ "( "
				+ " SELECT a.AD_PRINTGRAPH_ID "
				+ " FROM AD_PRINTGRAPH a "
				+ " WHERE a.NAME=i.PRINTGRAPH "
				+ ") "
				+ "WHERE ((i.I_IsImported<>'Y' "
				+ "OR i.I_IsImported IS NULL) and i.PRINTGRAPH is not null)").append(clientCheck);
		if(m_PrintFormat != null ){
			sql.append( " AND i.FORMATNAME=" + "'"+m_PrintFormat+"'"); 
		}
		no = DB.executeUpdate(sql.toString(), get_TrxName());
		if (no != 0)
			log.info("Set PrintGraph=" + no);
		
		//Set ItemColor
		sql = new StringBuffer("UPDATE I_PrintFormatItem i "
				+ "SET i.AD_ITEMCOLOR_ID="
				+ "( "
				+ " SELECT a.AD_PRINTCOLOR_ID "
				+ " FROM AD_PRINTCOLOR a "
				+ " WHERE a.NAME=i.ITEMCOLOR "
				+ ") "
				+ "WHERE ((i.I_IsImported<>'Y' "
				+ "OR i.I_IsImported IS NULL) and i.ITEMCOLOR is not null)").append(clientCheck);
		if(m_PrintFormat != null ){
			sql.append( " AND i.FORMATNAME=" + "'"+m_PrintFormat+"'"); 
		}
		no = DB.executeUpdate(sql.toString(), get_TrxName());
		if (no != 0)
			log.info("Set ItemColor=" + no);
		
		//Set ItemFont
		sql = new StringBuffer("UPDATE I_PrintFormatItem i "
				+ "SET i.AD_ITEMFONT_ID="
				+ "( "
				+ " SELECT a.AD_PRINTFONT_ID "
				+ " FROM AD_PRINTFONT a "
				+ " WHERE a.NAME=i.ITEMFONT "
				+ ") "
				+ "WHERE ((i.I_IsImported<>'Y' "
				+ "OR i.I_IsImported IS NULL) and i.ITEMFONT is not null)").append(clientCheck);
		if(m_PrintFormat != null ){
			sql.append( " AND i.FORMATNAME=" + "'"+m_PrintFormat+"'"); 
		}
		no = DB.executeUpdate(sql.toString(), get_TrxName());
		if (no != 0)
			log.info("Set ItemFont=" + no);
		
		commit();
		
		//Import Print Format
		sql = new StringBuffer("SELECT * FROM I_PrintFormatItem"
			+ " WHERE I_IsImported<>'Y' AND SEQNO > 0 AND ROWNUM=1").append(clientCheck);
		if(m_PrintFormat != null ){
			sql.append( " AND FORMATNAME=" + "'"+m_PrintFormat+"'"); 
		};
			
		PreparedStatement pstmt = null; 
		int noInsert = 0;
		int noInsertItem = 0;
		try
		{
			pstmt = DB.prepareStatement(sql.toString(), get_TrxName());
			ResultSet rs = pstmt.executeQuery();
				
			while (rs.next())
			{ 
				X_I_PrintFormatItem imp = new X_I_PrintFormatItem(m_ctx, rs, get_TrxName());
				
				//	New Print Format
				MPrintFormat printFormat = null;
				if (imp.getAD_PrintFormat_ID() != 0)	//	Insert new PrintFormat
				{
					printFormat = new MPrintFormat(getCtx(), imp.getAD_PrintFormat_ID(), get_TrxName());
					printFormat.setAD_PrintColor_ID(imp.getAD_PrintColor_ID());
					printFormat.setAD_PrintFont_ID(imp.getAD_PrintFont_ID());
					printFormat.setAD_PrintPaper_ID(imp.getAD_PrintPaper_ID());
					printFormat.setAD_Table_ID(imp.getAD_Table_ID());
					printFormat.setFooterMargin(imp.getFooterMargin());
					printFormat.setHeaderMargin(imp.getHeaderMargin());
					printFormat.setIsForm(imp.isForm());
					printFormat.setIsStandardHeaderFooter(imp.isStandardHeaderFooter());
					printFormat.setIsTableBased(imp.isTableBased());
					printFormat.setName(imp.getFormatName());

					if (printFormat.save())
					{
						imp.setAD_PrintFormat_ID(printFormat.getAD_PrintFormat_ID());
						log.finest("Insert PrintFormat - " + printFormat.getAD_PrintFormat_ID());
						printFormatID = printFormat.getAD_PrintFormat_ID();
						noInsert++;
					}
					else
					{
						sql = new StringBuffer ("UPDATE I_PrintFormatItem i "
							+ "SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Cannot Insert PrintFormat,'")
							.append(" WHERE AD_PrintFormat_ID=").append(imp.getAD_PrintFormat_ID());
						DB.executeUpdate(sql.toString(), get_TrxName());
						continue;     
					}
				}
				else				//	Update existing PrintFormat
				{
					printFormat = new MPrintFormat(m_ctx, 0, get_TrxName());
					printFormat.setClientOrg(imp);
					printFormat.setAD_PrintColor_ID(imp.getAD_PrintColor_ID());
					printFormat.setAD_PrintFont_ID(imp.getAD_PrintFont_ID());
					printFormat.setAD_PrintPaper_ID(imp.getAD_PrintPaper_ID());
					printFormat.setAD_Table_ID(imp.getAD_Table_ID());
					printFormat.setFooterMargin(imp.getFooterMargin());
					printFormat.setHeaderMargin(imp.getHeaderMargin());
					printFormat.setIsForm(imp.isForm());
					printFormat.setIsStandardHeaderFooter(imp.isStandardHeaderFooter());
					printFormat.setIsTableBased(imp.isTableBased());
					printFormat.setName(imp.getFormatName());
					
					//	Save PrintFormat
					if (printFormat.save())
					{
						imp.setAD_PrintFormat_ID(printFormat.getAD_PrintFormat_ID());
						imp.save();
						printFormatID = printFormat.getAD_PrintFormat_ID();
						noInsert++;
					}
					else
					{
						sql = new StringBuffer ("UPDATE I_PrintFormatItem i "
								+ "SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Cannot Update PrintFormat,'")
								.append(" WHERE AD_PrintFormat_ID=").append(imp.getAD_PrintFormat_ID());
							DB.executeUpdate(sql.toString(), get_TrxName());
						continue;
					}
				}
				//commit();
			}
			
			//	Close database connection
			rs.close();
			pstmt.close();
			rs = null;
			pstmt = null;

		}
		catch(Exception e)
		{
			log.log(Level.SEVERE, sql.toString(), e);
		}
		
		//Import Print Format Item
		sql = new StringBuffer("SELECT * FROM I_PrintFormatItem"
			+ " WHERE I_IsImported<>'Y' AND  SEQNO > 0 ").append(clientCheck);
		if(m_PrintFormat != null ){
			sql.append( " AND FORMATNAME=" + "'"+m_PrintFormat+"'"); 
		};
		sql.append( " ORDER BY I_PRINTFORMATITEM_ID " );	
		try
		{
			pstmt = DB.prepareStatement(sql.toString(), get_TrxName());
			ResultSet rs = pstmt.executeQuery();
				
			while (rs.next())
			{ 
				X_I_PrintFormatItem imp = new X_I_PrintFormatItem(m_ctx, rs, get_TrxName());
				
				//	New Print Format Item
				MPrintFormatItem printFormatItem = null;
				if (imp.getAD_PrintFormatItem_ID() != 0)	//	Insert new Print Format Item
				{
					imp.setAD_PrintFormat_ID(printFormatID);
					printFormatItem = new MPrintFormatItem(getCtx(), imp.getAD_PrintFormatItem_ID(), get_TrxName());
					printFormatItem.setAD_Org_ID(imp.getAD_Org_ID());
					
			        if ( imp.getAD_Column_ID()>0)
			        	printFormatItem.setAD_Column_ID(imp.getAD_Column_ID());
			        if ( imp.getAD_ItemColor_ID()>0)
			        	printFormatItem.setAD_PrintColor_ID(imp.getAD_ItemColor_ID());
			        if ( imp.getAD_PrintFont_ID()>0)
			        	printFormatItem.setAD_PrintFont_ID(imp.getAD_PrintFont_ID());
			        if ( imp.getAD_PrintFormatChild_ID()>0)
			        	printFormatItem.setAD_PrintFormatChild_ID(imp.getAD_PrintFormatChild_ID());
			        if ( imp.getAD_PrintGraph_ID()>0)
			        	printFormatItem.setAD_PrintGraph_ID(imp.getAD_PrintGraph_ID());
			        
			        printFormatItem.setArcDiameter(imp.getArcDiameter());
			        if ( imp.getBarcodeType()!=null)
			        	printFormatItem.setBarcodeType(imp.getBarcodeType());
			        printFormatItem.setBelowColumn(imp.getBelowColumn());
			        printFormatItem.setFieldAlignmentType(imp.getFieldAlignmentType());
			        printFormatItem.setImageIsAttached(imp.isImageIsAttached());
			        printFormatItem.setImageURL(imp.getImageURL());
			        printFormatItem.setIsAveraged(imp.isAveraged());
			        printFormatItem.setIsCentrallyMaintained(imp.isCentrallyMaintained());
			        printFormatItem.setIsCounted(imp.isCounted());
			        printFormatItem.setIsDeviationCalc(imp.isDeviationCalc());
			        printFormatItem.setIsFilledRectangle(imp.isFilledRectangle());
			        printFormatItem.setIsFixedWidth(imp.isFixedWidth());
			        printFormatItem.setIsGroupBy(imp.isGroupBy());
			        printFormatItem.setIsHeightOneLine(imp.isHeightOneLine());
			        printFormatItem.setIsImageField(imp.isImageField());
			        printFormatItem.setIsMaxCalc(imp.isMaxCalc());
			        printFormatItem.setIsMinCalc(imp.isMinCalc());
			        printFormatItem.setIsNextLine(imp.isNextLine());
			        printFormatItem.setIsNextPage(imp.isNextPage());
			        printFormatItem.setIsOrderBy(imp.isOrderBy());
			        printFormatItem.setIsPageBreak(imp.isPageBreak());
					printFormatItem.setIsPrinted(imp.isPrinted());
			        printFormatItem.setIsRelativePosition(imp.isRelativePosition());
			        printFormatItem.setIsRunningTotal(imp.isRunningTotal());
			        printFormatItem.setIsSetNLPosition(imp.isSetNLPosition());
			        printFormatItem.setIsSummarized(imp.isSummarized());
			        printFormatItem.setIsSuppressNull(imp.isSuppressNull());
			        printFormatItem.setIsVarianceCalc(imp.isVarianceCalc());
			        printFormatItem.setLineAlignmentType(imp.getLineAlignmentType());
			        printFormatItem.setLineWidth(imp.getLineWidth());
			        printFormatItem.setMaxHeight(imp.getMaxHeight());
			        printFormatItem.setMaxWidth(imp.getMaxWidth());
					printFormatItem.setName(imp.getItemName());
			        printFormatItem.setPrintAreaType(imp.getPrintAreaType());
			        printFormatItem.setPrintFormatType(imp.getPrintFormatType());
					printFormatItem.setPrintName(imp.getPrintName());
			        printFormatItem.setPrintNameSuffix(imp.getPrintNameSuffix());
			        printFormatItem.setRunningTotalLines(imp.getRunningTotalLines());
					printFormatItem.setSeqNo(imp.getSeqNo());
			        if ( imp.getShapeType()!=null)
			        	printFormatItem.setShapeType(imp.getShapeType());
			        printFormatItem.setSortNo(imp.getSortNo());
			        printFormatItem.setXPosition(imp.getXPosition());
			        printFormatItem.setXSpace(imp.getXSpace());
			        printFormatItem.setYPosition(imp.getYPosition());
			        printFormatItem.setYSpace(imp.getYSpace());
			        
					if (printFormatItem.save())
					{
						imp.setAD_PrintFormatItem_ID(printFormatItem.getAD_PrintFormatItem_ID());
						imp.setAD_PrintFormat_ID(printFormatItem.getAD_PrintFormat_ID());
						imp.setI_IsImported(true);
						imp.setProcessed(true);
						imp.save();
						log.finest("Insert PrintFormatItem - " + printFormatItem.getAD_PrintFormatItem_ID());
						noInsertItem++;
					}
					else
					{
						sql = new StringBuffer ("UPDATE I_PrintFormatItem i "
							+ "SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Cannot Insert PrintFormatItem,'")
							.append(" WHERE AD_PrintFormatItem_ID=").append(imp.getAD_PrintFormatItem_ID());
						DB.executeUpdate(sql.toString(), get_TrxName());
						continue;
					}
				}
				else				
				{
					printFormatItem = new MPrintFormatItem (m_ctx, 0, get_TrxName());
					printFormatItem.setClientOrg(imp);
					printFormatItem.setAD_PrintFormat_ID(printFormatID);
					
			        if ( imp.getAD_Column_ID()>0)
			        	printFormatItem.setAD_Column_ID(imp.getAD_Column_ID());
			        if ( imp.getAD_ItemColor_ID()>0)
			        	printFormatItem.setAD_PrintColor_ID(imp.getAD_ItemColor_ID());
			        if ( imp.getAD_PrintFont_ID()>0)
			        	printFormatItem.setAD_PrintFont_ID(imp.getAD_PrintFont_ID());
			        if ( imp.getAD_PrintFormatChild_ID()>0)
			        	printFormatItem.setAD_PrintFormatChild_ID(imp.getAD_PrintFormatChild_ID());
			        if ( imp.getAD_PrintGraph_ID()>0)
			        	printFormatItem.setAD_PrintGraph_ID(imp.getAD_PrintGraph_ID());
			        
			        printFormatItem.setArcDiameter(imp.getArcDiameter());
			        if ( imp.getBarcodeType()!=null)
			        	printFormatItem.setBarcodeType(imp.getBarcodeType());
			        printFormatItem.setBelowColumn(imp.getBelowColumn());
			        printFormatItem.setFieldAlignmentType(imp.getFieldAlignmentType());
			        printFormatItem.setImageIsAttached(imp.isImageIsAttached());
			        printFormatItem.setImageURL(imp.getImageURL());
			        printFormatItem.setIsAveraged(imp.isAveraged());
			        printFormatItem.setIsCentrallyMaintained(imp.isCentrallyMaintained());
			        printFormatItem.setIsCounted(imp.isCounted());
			        printFormatItem.setIsDeviationCalc(imp.isDeviationCalc());
			        printFormatItem.setIsFilledRectangle(imp.isFilledRectangle());
			        printFormatItem.setIsFixedWidth(imp.isFixedWidth());
			        printFormatItem.setIsGroupBy(imp.isGroupBy());
			        printFormatItem.setIsHeightOneLine(imp.isHeightOneLine());
			        printFormatItem.setIsImageField(imp.isImageField());
			        printFormatItem.setIsMaxCalc(imp.isMaxCalc());
			        printFormatItem.setIsMinCalc(imp.isMinCalc());
			        printFormatItem.setIsNextLine(imp.isNextLine());
			        printFormatItem.setIsNextPage(imp.isNextPage());
			        printFormatItem.setIsOrderBy(imp.isOrderBy());
			        printFormatItem.setIsPageBreak(imp.isPageBreak());
					printFormatItem.setIsPrinted(imp.isPrinted());
			        printFormatItem.setIsRelativePosition(imp.isRelativePosition());
			        printFormatItem.setIsRunningTotal(imp.isRunningTotal());
			        printFormatItem.setIsSetNLPosition(imp.isSetNLPosition());
			        printFormatItem.setIsSummarized(imp.isSummarized());
			        printFormatItem.setIsSuppressNull(imp.isSuppressNull());
			        printFormatItem.setIsVarianceCalc(imp.isVarianceCalc());
			        printFormatItem.setLineAlignmentType(imp.getLineAlignmentType());
			        printFormatItem.setLineWidth(imp.getLineWidth());
			        printFormatItem.setMaxHeight(imp.getMaxHeight());
			        printFormatItem.setMaxWidth(imp.getMaxWidth());
					printFormatItem.setName(imp.getItemName());
			        printFormatItem.setPrintAreaType(imp.getPrintAreaType());
			        printFormatItem.setPrintFormatType(imp.getPrintFormatType());
					printFormatItem.setPrintName(imp.getPrintName());
			        printFormatItem.setPrintNameSuffix(imp.getPrintNameSuffix());
			        printFormatItem.setRunningTotalLines(imp.getRunningTotalLines());
					printFormatItem.setSeqNo(imp.getSeqNo());
			        if ( imp.getShapeType()!=null)
			        	printFormatItem.setShapeType(imp.getShapeType());
			        printFormatItem.setSortNo(imp.getSortNo());
			        printFormatItem.setXPosition(imp.getXPosition());
			        printFormatItem.setXSpace(imp.getXSpace());
			        printFormatItem.setYPosition(imp.getYPosition());
			        printFormatItem.setYSpace(imp.getYSpace());
			        					
					//	Save PrintFormatItem
					if (printFormatItem.save())
					{
						imp.setAD_PrintFormatItem_ID(printFormatItem.getAD_PrintFormatItem_ID());
						imp.setAD_PrintFormat_ID(printFormatItem.getAD_PrintFormat_ID());
						imp.setI_IsImported(true);
						imp.setProcessed(true);
						imp.save();
						noInsertItem++;
					}
					else
					{
						sql = new StringBuffer ("UPDATE I_PrintFormatItem i "
								+ "SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Cannot Update PrintFormatItem,'")
								.append(" WHERE AD_PrintFormatItem_ID=").append(imp.getAD_PrintFormatItem_ID());
							DB.executeUpdate(sql.toString(), get_TrxName());
						continue;
					}
				}
				commit();
			}
			
			//	Close database connection
			rs.close();
			pstmt.close();
			rs = null;
			pstmt = null;

		}
		catch(Exception e)
		{
			log.log(Level.SEVERE, sql.toString(), e);
		}		
		
		//	Set Error to indicator to not imported
		sql = new StringBuffer ("UPDATE I_PrintFormatItem "
			+ "SET I_IsImported='N', Updated=SysDate "
			+ "WHERE I_IsImported<>'Y'").append(clientCheck);
		no = DB.executeUpdate(sql.toString(), get_TrxName());
		addLog (0, null, new BigDecimal (no), "@Errors@");
		//
		addLog (0, null, new BigDecimal (noInsert), "@AD_PrintFormat_ID@: @Inserted@");
		//
		addLog (0, null, new BigDecimal (noInsertItem), "@AD_PrintFormatItem_ID@: @Inserted@");
		commit();
		
		return "";
	}	//	doIt
	
}//	ImportPrintFormatItem
