/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.app;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.application.ApplicationDescriptor;
import org.osgi.service.application.ApplicationHandle;
import org.osgi.service.application.ScheduledApplication;
import org.osgi.util.tracker.ServiceTracker;

public class AppCommands
implements CommandProvider {
    private static final String LAUNCHABLE_APP_FILTER = "(&(application.locked=false)(application.launchable=true)(application.visible=true))";
    private static final String ACTIVE_APP_FILTER = "(!(application.state=STOPPING))";
    private static final String LOCKED_APP_FILTER = "(application.locked=true)";
    private static AppCommands instance;
    private BundleContext context;
    private ServiceTracker applicationDescriptors;
    private ServiceTracker applicationHandles;
    private ServiceTracker scheduledApplications;
    private Filter launchableApp;
    private Filter activeApp;
    private Filter lockedApp;
    private ServiceRegistration providerRegistration;

    static synchronized void create(BundleContext context) {
        if (instance != null) {
            return;
        }
        instance = new AppCommands();
        instance.start(context);
    }

    static synchronized void destroy(BundleContext context) {
        if (instance == null) {
            return;
        }
        instance.stop(context);
        instance = null;
    }

    protected AppCommands() {
    }

    public void start(BundleContext ctx) {
        this.context = ctx;
        try {
            this.applicationDescriptors = new ServiceTracker(ctx, ApplicationDescriptor.class.getName(), null);
            this.applicationDescriptors.open();
            this.applicationHandles = new ServiceTracker(ctx, ApplicationHandle.class.getName(), null);
            this.applicationHandles.open();
            this.scheduledApplications = new ServiceTracker(ctx, ScheduledApplication.class.getName(), null);
            this.scheduledApplications.open();
            this.launchableApp = ctx.createFilter(LAUNCHABLE_APP_FILTER);
            this.activeApp = ctx.createFilter(ACTIVE_APP_FILTER);
            this.lockedApp = ctx.createFilter(LOCKED_APP_FILTER);
            this.providerRegistration = ctx.registerService(CommandProvider.class.getName(), (Object)this, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
    }

    public void stop(BundleContext ctx) {
        this.providerRegistration.unregister();
        if (this.applicationDescriptors != null) {
            this.applicationDescriptors.close();
        }
        if (this.applicationHandles != null) {
            this.applicationHandles.close();
        }
        if (this.scheduledApplications != null) {
            this.scheduledApplications.close();
        }
    }

    public String getHelp() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n---Application Admin Commands---\n");
        sb.append("\tactiveApps - lists all running application IDs\n");
        sb.append("\tapps - lists all installed application IDs\n");
        sb.append("\tlockApp <application id> - locks the specified application ID\n");
        sb.append("\tschedApp <application id> <time filter> [true|false] - schedules the specified application id to launch at the specified time filter.  Can optionally make the schedule recurring.\n");
        sb.append("\tstartApp <application id> - starts the specified application ID\n");
        sb.append("\tstopApp <application id> - stops the specified running application ID\n");
        sb.append("\tunlockApp <application id> - unlocks the specified application ID\n");
        sb.append("\tunschedApp <application id> - unschedules all scheduled applications with the specified application ID\n");
        return sb.toString();
    }

    private Dictionary getServiceProps(ServiceReference ref) {
        String[] keys = ref.getPropertyKeys();
        Hashtable<String, Object> props = new Hashtable<String, Object>(keys.length);
        int i = 0;
        while (i < keys.length) {
            props.put(keys[i], ref.getProperty(keys[i]));
            ++i;
        }
        return props;
    }

    public void _apps(CommandInterpreter intp) {
        ServiceReference[] apps = this.applicationDescriptors.getServiceReferences();
        if (apps == null) {
            intp.println((Object)"No applications found.");
            return;
        }
        int i = 0;
        while (i < apps.length) {
            String application = (String)apps[i].getProperty("service.pid");
            intp.print((Object)application);
            if (this.getApplication(this.applicationHandles.getServiceReferences(), application, "application.descriptor", true) != null) {
                intp.print((Object)" [running]");
            }
            if (this.getApplication(this.scheduledApplications.getServiceReferences(), application, "service.pid", true) != null) {
                intp.print((Object)" [scheduled]");
            }
            if (!this.launchableApp.match(this.getServiceProps(apps[i]))) {
                intp.print((Object)" [not launchable]");
            } else {
                intp.print((Object)" [launchable]");
            }
            if (this.lockedApp.match(this.getServiceProps(apps[i]))) {
                intp.print((Object)" [locked]");
            }
            intp.println();
            ++i;
        }
    }

    public void _activeApps(CommandInterpreter intp) {
        ServiceReference[] active = this.applicationHandles.getServiceReferences();
        if (active == null) {
            intp.println((Object)"No active applications found");
            return;
        }
        int i = 0;
        while (i < active.length) {
            intp.print(active[i].getProperty("service.pid"));
            intp.print((Object)" [");
            intp.print((Object)(this.activeApp.match(this.getServiceProps(active[i])) ? "running" : "stopping"));
            intp.println((Object)"]");
            ++i;
        }
    }

    private ServiceReference getApplication(ServiceReference[] apps, String targetId, String idKey, boolean perfectMatch) {
        if (apps == null || targetId == null) {
            return null;
        }
        ServiceReference result = null;
        boolean ambigous = false;
        int i = 0;
        while (i < apps.length) {
            String id = (String)apps[i].getProperty(idKey);
            if (targetId.equals(id)) {
                return apps[i];
            }
            if (!perfectMatch && id.indexOf(targetId) >= 0) {
                if (result != null) {
                    ambigous = true;
                }
                result = apps[i];
            }
            ++i;
        }
        return ambigous ? null : result;
    }

    public void _startApp(CommandInterpreter intp) throws Exception {
        String appId = intp.nextArgument();
        ServiceReference application = this.getApplication(this.applicationDescriptors.getServiceReferences(), appId, "service.pid", false);
        if (application != null) {
            ArrayList<String> argList = new ArrayList<String>();
            String arg = null;
            while ((arg = intp.nextArgument()) != null) {
                argList.add(arg);
            }
            String[] args = argList.size() == 0 ? null : argList.toArray(new String[argList.size()]);
            try {
                HashMap<String, String[]> launchArgs = new HashMap<String, String[]>(1);
                if (args != null) {
                    launchArgs.put("application.args", args);
                }
                ApplicationDescriptor appDesc = (ApplicationDescriptor)this.context.getService(application);
                ApplicationHandle handle = appDesc.launch(launchArgs);
                intp.println((Object)("Launched application instance: " + handle.getInstanceId()));
            }
            finally {
                this.context.ungetService(application);
            }
            return;
        }
        intp.println((Object)("\"" + appId + "\" does not exist or is ambigous."));
    }

    public void _stopApp(CommandInterpreter intp) throws Exception {
        String appId = intp.nextArgument();
        ServiceReference application = this.getApplication(this.applicationHandles.getServiceReferences(), appId, "service.pid", false);
        if (application == null) {
            application = this.getApplication(this.applicationHandles.getServiceReferences(), appId, "application.descriptor", false);
        }
        if (application != null) {
            if (this.activeApp.match(this.getServiceProps(application))) {
                try {
                    ApplicationHandle appHandle = (ApplicationHandle)this.context.getService(application);
                    appHandle.destroy();
                    intp.println((Object)("Stopped application instance: " + appHandle.getInstanceId()));
                }
                finally {
                    this.context.ungetService(application);
                }
            } else {
                intp.println((Object)("Application instance is already stopping: " + application.getProperty("service.pid")));
            }
            return;
        }
        intp.println((Object)("\"" + appId + "\" does not exist, is not running or is ambigous."));
    }

    public void _lockApp(CommandInterpreter intp) throws Exception {
        String appId = intp.nextArgument();
        ServiceReference application = this.getApplication(this.applicationDescriptors.getServiceReferences(), appId, "service.pid", false);
        if (application != null) {
            try {
                ApplicationDescriptor appDesc = (ApplicationDescriptor)this.context.getService(application);
                appDesc.lock();
                intp.println((Object)("Locked application: " + appDesc.getApplicationId()));
            }
            finally {
                this.context.ungetService(application);
            }
            return;
        }
        intp.println((Object)("\"" + appId + "\" does not exist or is ambigous."));
    }

    public void _unlockApp(CommandInterpreter intp) throws Exception {
        String appId = intp.nextArgument();
        ServiceReference application = this.getApplication(this.applicationDescriptors.getServiceReferences(), appId, "service.pid", false);
        if (application != null) {
            try {
                ApplicationDescriptor appDesc = (ApplicationDescriptor)this.context.getService(application);
                appDesc.unlock();
                intp.println((Object)("Unlocked application: " + appDesc.getApplicationId()));
            }
            finally {
                this.context.ungetService(application);
            }
            return;
        }
        intp.println((Object)("\"" + appId + "\" does not exist or is ambigous."));
    }

    public void _schedApp(CommandInterpreter intp) throws Exception {
        String appId = intp.nextArgument();
        ServiceReference application = this.getApplication(this.applicationDescriptors.getServiceReferences(), appId, "service.pid", false);
        if (application != null) {
            try {
                ApplicationDescriptor appDesc = (ApplicationDescriptor)this.context.getService(application);
                String filter = intp.nextArgument();
                boolean recure = Boolean.valueOf(intp.nextArgument());
                appDesc.schedule(null, null, "org/osgi/application/timer", filter, recure);
                intp.println((Object)("Scheduled application: " + appDesc.getApplicationId()));
            }
            finally {
                this.context.ungetService(application);
            }
            return;
        }
        intp.println((Object)("\"" + appId + "\" does not exist or is ambigous."));
    }

    public void _unschedApp(CommandInterpreter intp) throws Exception {
        String appId = intp.nextArgument();
        ServiceReference application = this.getApplication(this.scheduledApplications.getServiceReferences(), appId, "service.pid", false);
        if (application == null) {
            intp.println((Object)("\"" + appId + "\" does not exist or is ambigous."));
        } else {
            try {
                ScheduledApplication schedApp = (ScheduledApplication)this.context.getService(application);
                schedApp.remove();
                intp.println((Object)("Unscheduled application: " + application.getProperty("service.pid")));
            }
            finally {
                this.context.ungetService(application);
            }
        }
    }
}

