/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.configuration.ILocalSiteChangedListener;
import org.eclipse.update.configuration.IProblemHandler;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.ConfigurationActivity;
import org.eclipse.update.internal.core.InstallConfiguration;
import org.eclipse.update.internal.core.ListenersList;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.SiteStatusAnalyzer;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.InstallConfigurationModel;
import org.eclipse.update.internal.model.SiteLocalModel;
import org.eclipse.update.internal.model.SiteLocalParser;

public class LocalSite
extends SiteLocalModel
implements ILocalSite {
    private ListenersList listeners = new ListenersList();
    private SiteStatusAnalyzer siteStatusAnalyzer;
    private boolean isTransient = false;
    public static boolean newFeaturesFound = false;

    public static ILocalSite getLocalSite() throws CoreException {
        return LocalSite.internalGetLocalSite();
    }

    public static ILocalSite internalGetLocalSite() throws CoreException {
        LocalSite localSite = new LocalSite();
        IPlatformConfiguration currentPlatformConfiguration = ConfiguratorUtils.getCurrentPlatformConfiguration();
        localSite.isTransient(currentPlatformConfiguration.isTransient());
        try {
            URL configXML = currentPlatformConfiguration.getConfigurationLocation();
            localSite.setLocationURLString(configXML.toExternalForm());
            localSite.resolve(configXML, null);
            LocalSite.parseLocalSiteFile(currentPlatformConfiguration, localSite);
        }
        catch (MalformedURLException exception) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.SiteLocal_UnableToCreateURLFor, (Object[])new String[]{String.valueOf(localSite.getLocationURLString()) + " & " + "platform.xml"}), exception);
        }
        return localSite;
    }

    private static boolean parseLocalSiteFile(IPlatformConfiguration platformConfig, LocalSite localSite) throws CoreException, MalformedURLException {
        try {
            new SiteLocalParser(platformConfig, localSite);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected LocalSite() {
    }

    @Override
    public void addConfiguration(IInstallConfiguration config) {
        if (config != null) {
            this.addConfigurationModel((InstallConfigurationModel)((Object)config));
            this.trimHistoryToCapacity();
            if (this.getCurrentConfigurationModel() != null) {
                this.getCurrentConfigurationModel().setCurrent(false);
            }
            if (config instanceof InstallConfiguration) {
                ((InstallConfiguration)config).setCurrent(true);
            }
            this.setCurrentConfigurationModel((InstallConfigurationModel)((Object)config));
            ((InstallConfigurationModel)((Object)config)).markReadOnly();
            Object[] siteLocalListeners = this.listeners.getListeners();
            int i = 0;
            while (i < siteLocalListeners.length) {
                ((ILocalSiteChangedListener)siteLocalListeners[i]).currentInstallConfigurationChanged(config);
                ++i;
            }
        }
    }

    private void trimHistoryToCapacity() {
        while (this.getConfigurationHistory().length > this.getMaximumHistoryCount() && this.getConfigurationHistory().length > 1) {
            InstallConfigurationModel removedConfig = this.getConfigurationHistoryModel()[1];
            if (!this.removeConfigurationModel(removedConfig)) continue;
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                UpdateCore.debug("Removed configuration :" + removedConfig.getLabel());
            }
            Object[] siteLocalListeners = this.listeners.getListeners();
            int i = 0;
            while (i < siteLocalListeners.length) {
                ((ILocalSiteChangedListener)siteLocalListeners[i]).installConfigurationRemoved((IInstallConfiguration)((Object)removedConfig));
                ++i;
            }
            URL url = removedConfig.getURL();
            UpdateManagerUtils.removeFromFileSystem(new File(url.getFile()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLocalSiteChangedListener(ILocalSiteChangedListener listener) {
        ListenersList listenersList = this.listeners;
        synchronized (listenersList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLocalSiteChangedListener(ILocalSiteChangedListener listener) {
        ListenersList listenersList = this.listeners;
        synchronized (listenersList) {
            this.listeners.add(listener);
        }
    }

    @Override
    public boolean save() throws CoreException {
        return ((InstallConfiguration)this.getCurrentConfiguration()).save();
    }

    @Override
    public IInstallConfiguration cloneCurrentConfiguration() throws CoreException {
        try {
            return new InstallConfiguration(this.getCurrentConfiguration());
        }
        catch (MalformedURLException e) {
            throw Utilities.newCoreException(Messages.SiteLocal_cloneConfig, e);
        }
    }

    @Override
    public void revertTo(IInstallConfiguration configuration, IProgressMonitor monitor, IProblemHandler handler) throws CoreException {
        ConfigurationActivity activity = new ConfigurationActivity(7);
        activity.setLabel(configuration.getLabel());
        activity.setDate(new Date());
        IInstallConfiguration newConfiguration = null;
        try {
            try {
                newConfiguration = this.cloneCurrentConfiguration();
                newConfiguration.setLabel(configuration.getLabel());
                this.addConfiguration(newConfiguration);
                ((InstallConfiguration)newConfiguration).revertTo(configuration, monitor, handler);
                activity.setStatus(0);
            }
            catch (CoreException e) {
                activity.setStatus(1);
                throw e;
            }
            catch (InterruptedException interruptedException) {
                if (newConfiguration != null) {
                    ((InstallConfiguration)newConfiguration).addActivity(activity);
                }
            }
        }
        finally {
            if (newConfiguration != null) {
                ((InstallConfiguration)newConfiguration).addActivity(activity);
            }
        }
    }

    @Override
    public IInstallConfiguration addToPreservedConfigurations(IInstallConfiguration configuration) throws CoreException {
        return null;
    }

    public IInstallConfiguration findPreservedConfigurationFor(IInstallConfiguration configuration) {
        InstallConfigurationModel[] preservedConfigurations;
        InstallConfigurationModel preservedConfig = null;
        if (configuration != null && (preservedConfigurations = this.getPreservedConfigurationsModel()) != null) {
            int indexPreserved = 0;
            while (indexPreserved < preservedConfigurations.length) {
                if (configuration.getCreationDate().equals(preservedConfigurations[indexPreserved].getCreationDate())) {
                    preservedConfig = preservedConfigurations[indexPreserved];
                    break;
                }
                ++indexPreserved;
            }
        }
        return (IInstallConfiguration)((Object)preservedConfig);
    }

    @Override
    public IInstallConfiguration getCurrentConfiguration() {
        if (this.getCurrentConfigurationModel() == null) {
            int index = 0;
            index = this.getConfigurationHistoryModel().length;
            if (index == 0) {
                return null;
            }
            InstallConfigurationModel config = this.getConfigurationHistoryModel()[index - 1];
            config.setCurrent(true);
            this.setCurrentConfigurationModel(config);
        }
        return (IInstallConfiguration)((Object)this.getCurrentConfigurationModel());
    }

    @Override
    public IInstallConfiguration[] getPreservedConfigurations() {
        if (this.getPreservedConfigurationsModel().length == 0) {
            return new IInstallConfiguration[0];
        }
        return (IInstallConfiguration[])this.getPreservedConfigurationsModel();
    }

    @Override
    public void removeFromPreservedConfigurations(IInstallConfiguration configuration) {
        if (this.removePreservedConfigurationModel((InstallConfigurationModel)((Object)configuration))) {
            ((InstallConfiguration)configuration).remove();
        }
    }

    @Override
    public IInstallConfiguration[] getConfigurationHistory() {
        if (this.getConfigurationHistoryModel().length == 0) {
            return new IInstallConfiguration[0];
        }
        return (IInstallConfiguration[])this.getConfigurationHistoryModel();
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    private void isTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    private SiteStatusAnalyzer getSiteStatusAnalyzer() {
        if (this.siteStatusAnalyzer == null) {
            this.siteStatusAnalyzer = new SiteStatusAnalyzer(this);
        }
        return this.siteStatusAnalyzer;
    }

    @Override
    public IStatus getFeatureStatus(IFeature feature) throws CoreException {
        return this.getSiteStatusAnalyzer().getFeatureStatus(feature);
    }

    @Override
    public void setMaximumHistoryCount(int history) {
        super.setMaximumHistoryCount(history);
        this.trimHistoryToCapacity();
    }
}

