/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.conversion;

import com.ibm.icu.text.NumberFormat;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.core.internal.databinding.conversion.StringToNumberParser;
import org.eclipse.core.internal.databinding.validation.NumberFormatConverter;

public class StringToNumberConverter
extends NumberFormatConverter {
    private Class toType;
    private NumberFormat numberFormat;
    private final Number min;
    private final Number max;
    private final Class boxedType;
    private static final Integer MIN_INTEGER = new Integer(Integer.MIN_VALUE);
    private static final Integer MAX_INTEGER = new Integer(Integer.MAX_VALUE);
    private static final Double MIN_DOUBLE = new Double(-1.7976931348623157E308);
    private static final Double MAX_DOUBLE = new Double(Double.MAX_VALUE);
    private static final Long MIN_LONG = new Long(Long.MIN_VALUE);
    private static final Long MAX_LONG = new Long(Long.MIN_VALUE);
    private static final Float MIN_FLOAT = new Float(-3.4028235E38f);
    private static final Float MAX_FLOAT = new Float(Float.MAX_VALUE);

    private StringToNumberConverter(NumberFormat numberFormat, Class toType, Number min, Number max, Class boxedType) {
        super(String.class, toType, numberFormat);
        this.toType = toType;
        this.numberFormat = numberFormat;
        this.min = min;
        this.max = max;
        this.boxedType = boxedType;
    }

    @Override
    public Object convert(Object fromObject) {
        StringToNumberParser.ParseResult result = StringToNumberParser.parse(fromObject, this.numberFormat, this.toType.isPrimitive());
        if (result.getPosition() != null) {
            throw new IllegalArgumentException(StringToNumberParser.createParseErrorMessage((String)fromObject, result.getPosition()));
        }
        if (result.getNumber() == null) {
            return null;
        }
        if (Integer.class.equals((Object)this.boxedType)) {
            if (StringToNumberParser.inIntegerRange(result.getNumber())) {
                return new Integer(result.getNumber().intValue());
            }
        } else if (Double.class.equals((Object)this.boxedType)) {
            if (StringToNumberParser.inDoubleRange(result.getNumber())) {
                return new Double(result.getNumber().doubleValue());
            }
        } else if (Long.class.equals((Object)this.boxedType)) {
            if (StringToNumberParser.inLongRange(result.getNumber())) {
                return new Long(result.getNumber().longValue());
            }
        } else if (Float.class.equals((Object)this.boxedType)) {
            if (StringToNumberParser.inFloatRange(result.getNumber())) {
                return new Float(result.getNumber().floatValue());
            }
        } else if (BigInteger.class.equals((Object)this.boxedType)) {
            return new BigDecimal(result.getNumber().doubleValue()).toBigInteger();
        }
        if (this.min != null && this.max != null) {
            throw new IllegalArgumentException(StringToNumberParser.createOutOfRangeMessage(this.min, this.max, this.numberFormat));
        }
        throw new IllegalArgumentException("Could not convert [" + fromObject + "] to type [" + this.toType + "]");
    }

    public static StringToNumberConverter toInteger(boolean primitive) {
        return StringToNumberConverter.toInteger(NumberFormat.getIntegerInstance(), primitive);
    }

    public static StringToNumberConverter toInteger(NumberFormat numberFormat, boolean primitive) {
        return new StringToNumberConverter(numberFormat, primitive ? Integer.TYPE : Integer.class, MIN_INTEGER, MAX_INTEGER, Integer.class);
    }

    public static StringToNumberConverter toDouble(boolean primitive) {
        return StringToNumberConverter.toDouble(NumberFormat.getNumberInstance(), primitive);
    }

    public static StringToNumberConverter toDouble(NumberFormat numberFormat, boolean primitive) {
        return new StringToNumberConverter(numberFormat, primitive ? Double.TYPE : Double.class, MIN_DOUBLE, MAX_DOUBLE, Double.class);
    }

    public static StringToNumberConverter toLong(boolean primitive) {
        return StringToNumberConverter.toLong(NumberFormat.getIntegerInstance(), primitive);
    }

    public static StringToNumberConverter toLong(NumberFormat numberFormat, boolean primitive) {
        return new StringToNumberConverter(numberFormat, primitive ? Long.TYPE : Long.class, MIN_LONG, MAX_LONG, Long.class);
    }

    public static StringToNumberConverter toFloat(boolean primitive) {
        return StringToNumberConverter.toFloat(NumberFormat.getNumberInstance(), primitive);
    }

    public static StringToNumberConverter toFloat(NumberFormat numberFormat, boolean primitive) {
        return new StringToNumberConverter(numberFormat, primitive ? Float.TYPE : Float.class, MIN_FLOAT, MAX_FLOAT, Float.class);
    }

    public static StringToNumberConverter toBigInteger() {
        return StringToNumberConverter.toBigInteger(NumberFormat.getIntegerInstance());
    }

    public static StringToNumberConverter toBigInteger(NumberFormat numberFormat) {
        return new StringToNumberConverter(numberFormat, BigInteger.class, null, null, BigInteger.class);
    }
}

