/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.BibTeX;

import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jp.sourceforge.concierge.plugin.MappingData;
import jp.sourceforge.concierge.plugin.MappingField;
import org.w3c.dom.Document;

public class BibTeXMappingData
extends MappingData {
    private String citationKey = null;
    private static final String BIBTEX_BUNDLE_NAME = "jp.sourceforge.concierge.plugin.BibTeX.bibtex";
    private static ResourceBundle BIBTEX_BUNDLE = null;
    private static String[] EntryTypes = null;

    public static String[] getEntryTypes() {
        try {
            if (BIBTEX_BUNDLE == null) {
                BIBTEX_BUNDLE = ResourceBundle.getBundle(BIBTEX_BUNDLE_NAME);
            }
            if (EntryTypes == null) {
                EntryTypes = BIBTEX_BUNDLE.getString("EntryTypes").split(", ");
            }
        }
        catch (MissingResourceException e) {
            e.getStackTrace();
        }
        return EntryTypes;
    }

    public static String getEntryType(int index) {
        String[] entryTypes = BibTeXMappingData.getEntryTypes();
        if (index >= 0 && index < entryTypes.length) {
            return entryTypes[index];
        }
        return "";
    }

    public BibTeXMappingData(Document typedoc) {
        this.defaultMappingData(typedoc);
    }

    public BibTeXMappingData(String dataName, String dstTypeName, Document typedoc) {
        super(dataName, dstTypeName, typedoc);
        this.citationKey = "%author%%year%";
    }

    public BibTeXMappingData(String dataName, String dstTypeName, String citationKey, ArrayList<MappingField> fieldsAL) {
        super(dataName, dstTypeName, fieldsAL);
        this.citationKey = citationKey;
    }

    protected void defaultMappingData(Document typedoc) {
        super.defaultMappingData();
        this.setDstType(BibTeXMappingData.getEntryType(0), typedoc);
        this.citationKey = "%author%%year%";
    }

    @Override
    protected String[] getDstElementNames(String entryType) {
        try {
            if (BIBTEX_BUNDLE == null) {
                BIBTEX_BUNDLE = ResourceBundle.getBundle(BIBTEX_BUNDLE_NAME);
            }
            return BIBTEX_BUNDLE.getString(entryType).split(", ");
        }
        catch (MissingResourceException e) {
            e.getStackTrace();
            return null;
        }
    }

    public String getCitationKey() {
        return this.citationKey;
    }

    public void setCitationKey(String citationKey) {
        this.citationKey = citationKey;
    }
}

