/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ReferBibIX;

import java.util.ArrayList;
import java.util.Hashtable;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.parser.AuthorsParser;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.plugin.ExportMappingDataDomImpl;
import jp.sourceforge.concierge.plugin.MappingField;
import jp.sourceforge.concierge.plugin.ReferBibIX.ReferBibIXMappingData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReferBibIXMappingDataDomImpl
extends ExportMappingDataDomImpl {
    public static final String toptagname = "referbibixmappingdata";
    private static Hashtable<String, ReferBibIXMappingData> currentMappingDataList = null;

    public static void readCurrentMappingDataList() {
        if (currentMappingDataList != null) {
            currentMappingDataList.clear();
            currentMappingDataList = null;
        }
        currentMappingDataList = new Hashtable();
        ArrayList typedocs = TypeManager.getAllTypeDocuments((boolean)true, (boolean)true, (boolean)true);
        int i = 0;
        while (i < typedocs.size()) {
            Document typedoc = (Document)typedocs.get(i);
            ReferBibIXMappingData mappingData = ReferBibIXMappingDataDomImpl.readCurrentMappingData(typedoc);
            if (mappingData == null) {
                mappingData = new ReferBibIXMappingData(typedoc);
            }
            currentMappingDataList.put(TypeDomImpl.getTypeName((Document)typedoc), mappingData);
            ++i;
        }
    }

    private static ReferBibIXMappingData readCurrentMappingData(Document typedoc) {
        Document doc;
        Element rootElem;
        String selectString;
        String xpath = "/referbibixmappingdata[@typeid='" + DomImpl.getID((Document)typedoc) + "']";
        Request req = new Request(4, (Object)xpath, "exportmappingdata");
        ArrayList docs = FrameworkPlugin.getDocumentsOfQuery((Request)req);
        if (docs.size() > 0 && (selectString = (rootElem = (doc = (Document)docs.get(0)).getDocumentElement()).getAttribute("select")) != null && selectString.length() > 0) {
            int select = Integer.valueOf(selectString);
            int count = 0;
            Node dataNode = rootElem.getFirstChild();
            while (dataNode != null) {
                if (dataNode.getNodeType() == 1) {
                    if (count == select) {
                        ArrayList<MappingField> fieldsAL = new ArrayList<MappingField>();
                        Node fieldNode = dataNode.getFirstChild();
                        while (fieldNode != null) {
                            if (fieldNode.getNodeType() == 1) {
                                String referbibixValue = ((Element)fieldNode).getAttribute("referbibix");
                                String ccgValue = ((Element)fieldNode).getAttribute("ccg");
                                fieldsAL.add(new MappingField(referbibixValue, ccgValue));
                            }
                            fieldNode = fieldNode.getNextSibling();
                        }
                        String dataName = ((Element)dataNode).getAttribute("dataname");
                        String referenceType = ((Element)dataNode).getAttribute("referencetype");
                        return new ReferBibIXMappingData(dataName, referenceType, fieldsAL);
                    }
                    ++count;
                }
                dataNode = dataNode.getNextSibling();
            }
        }
        return null;
    }

    public static ReferBibIXMappingData getCurrentMappingData(String typename) {
        if (currentMappingDataList == null) {
            ReferBibIXMappingDataDomImpl.readCurrentMappingDataList();
        }
        if (currentMappingDataList != null) {
            return currentMappingDataList.get(typename);
        }
        return null;
    }

    public static void setCurrentMappingData(String typename, ReferBibIXMappingData mappingData) {
        if (currentMappingDataList == null) {
            ReferBibIXMappingDataDomImpl.readCurrentMappingDataList();
        }
        currentMappingDataList.put(typename, mappingData);
    }

    public static String createString(Document datadoc, String typename) {
        if (typename == null || typename.length() == 0) {
            typename = DataDomImpl.getDefaultType((Document)datadoc);
        }
        if (typename == null || typename.length() == 0) {
            return null;
        }
        Element dataElem = DataDomImpl.getDataOfType((Document)datadoc, (String)typename);
        ReferBibIXMappingData mappingData = ReferBibIXMappingDataDomImpl.getCurrentMappingData(typename);
        if (mappingData == null) {
            return null;
        }
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("%0 ");
        strBuf.append(mappingData.getDstTypeName());
        strBuf.append("\n");
        ArrayList<MappingField> fields = mappingData.getFields();
        int i = 0;
        while (i < fields.size()) {
            MappingField field = fields.get(i);
            String tag = field.getDst().substring(0, 2);
            if (tag.equals("%A")) {
                String[] values = ReferBibIXMappingDataDomImpl.getAuthorTextFromDataDocument(dataElem, field.getSrc());
                if (values != null && values.length > 0) {
                    int j = 0;
                    while (j < values.length) {
                        strBuf.append(tag);
                        strBuf.append(" ");
                        strBuf.append(values[j].trim());
                        if (values.length - 1 > j) {
                            strBuf.append("\n");
                        }
                        ++j;
                    }
                } else {
                    strBuf.append(tag);
                    strBuf.append(" ");
                }
            } else {
                strBuf.append(tag);
                strBuf.append(" ");
                strBuf.append(ReferBibIXMappingDataDomImpl.getTextFromDataDocument(dataElem, field.getSrc()));
            }
            strBuf.append("\n");
            ++i;
        }
        return strBuf.toString();
    }

    private static String getTextFromDataDocument(Element dataElem, String elemName) {
        String parsername;
        ITypeParser p;
        StringBuffer strBuf = new StringBuffer();
        Element elem = DataDomImpl.getElement((Element)dataElem, (String)elemName);
        if (elem != null && (p = FrameworkPlugin.getParser((String)(parsername = DataDomImpl.getParserName((Element)elem)))) != null) {
            strBuf.append(p.getSingleText(elem));
        }
        return strBuf.toString();
    }

    private static String[] getAuthorTextFromDataDocument(Element dataElem, String elemName) {
        String parsername;
        ITypeParser p;
        Element elem = DataDomImpl.getElement((Element)dataElem, (String)elemName);
        if (elem != null && (p = FrameworkPlugin.getParser((String)(parsername = DataDomImpl.getParserName((Element)elem)))) != null) {
            if (p instanceof AuthorsParser) {
                AuthorsParser ap = (AuthorsParser)p;
                ArrayList al = ap.getMultiText(elem);
                return al.toArray(new String[0]);
            }
            String value = p.getSingleText(elem);
            String[] values = new String[]{value};
            return values;
        }
        return null;
    }
}

